package serveur;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

import serveur.exceptions.ServeurException;
import tools.Loggeur;
import client.ClientRemote;
import decoupage.Morceau;
import filtre.Contour;
import filtre.EnumTypeFiltre;
import filtre.Flou;
import filtre.Negatif;
import filtre.NoirEtBlanc;


public class ThreadTraitement extends Thread {
	
	private int num;
	
	private JetonTraitement jeton;
	
	private boolean occupe;
	
	public ThreadTraitement(int numThread){
		super("Thread" + numThread);
		num = numThread;
		occupe = false;
	}
	
	public boolean isOccupe(){
		return occupe;
	}
	
	public int getNum(){
		return this.num;
	}
	
	public synchronized void reserverThread(JetonTraitement jeton){
		occupe = true;
		this.jeton = jeton;
	}
	
	public void run(){		
		try {
			Loggeur.writeLog("ThreadTraitement " + num, "Demarrage du thread");
			synchronized(this){
				while(!occupe){
					Loggeur.writeLog("ThreadTraitement " + num, "Attente d'un traitement");
					this.wait();
					if(occupe){
						Loggeur.writeLog("ThreadTraitement " + num, "Traitement jeton " + jeton.getId() + "  du client ");
						
						Morceau traitement = ThreadTraitement.effectuerTraitement(jeton.morceau, jeton.filtre);
						
						try {
							Loggeur.writeLog("ThreadTraitement " + num, "Connexion au client " + jeton.client);
							Registry rServeur;
							rServeur = LocateRegistry.getRegistry(jeton.client.hote, jeton.client.port);
							ClientRemote client = (ClientRemote)rServeur.lookup(jeton.client.nom);
							Loggeur.writeLog("ThreadTraitement " + num, "Connexion au client OK");
							client.recupererTraitementImage(traitement);
							Loggeur.writeLog("ThreadTraitement " + num, "Morceau envoyé au client");
						} catch (ServeurException e) {
							e.printStackTrace();
						} catch (RemoteException e) {
							e.printStackTrace();
						} catch (NotBoundException e) {
							e.printStackTrace();
						}
						
						occupe = false;
						jeton = null;
					}
				}
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	public static Morceau effectuerTraitement(Morceau morceau, EnumTypeFiltre filtre){

		Morceau m;
		int pixels[];
		
		if(filtre == EnumTypeFiltre.CONTOUR){
			Contour contour = new Contour(morceau);
			pixels = contour.traitementContour();
		}else if(filtre == EnumTypeFiltre.NEGATIF){
			Negatif negatif = new Negatif(morceau);
			pixels = negatif.traitementNegatif();
		}else if(filtre == EnumTypeFiltre.FLOU){
			Flou floutage = new Flou(morceau);
			pixels = floutage.traitementFlou();
		}else if(filtre == EnumTypeFiltre.NOIR_ET_BLANC){
			NoirEtBlanc noirEtBlanc = new NoirEtBlanc(morceau);
			pixels = noirEtBlanc.traitementNB();
		}else {
			pixels = morceau.getPixelsTab();
		}
		
		m = new Morceau(pixels, morceau.getStartX(), morceau.getStartY(), morceau.getWidth(), morceau.getHeight());
		m.setNum(morceau.getNum());
		m.setMax(morceau.getMax());
		return m;
	}	
}
