package serveur;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class ServeurLauncher {

	private Serveur serveur;
	
	public void run(ServeurInfos serveurInfos, ServeurInfos suivantInfos){
		try {
			serveur = new Serveur(serveurInfos);
			serveur.init();
			System.out.println("\nAppuyer sur Entrée lorsque le suivant est pret :\n");
			BufferedReader val;
			val = new BufferedReader(new InputStreamReader(System.in));
			val.readLine();
			serveur.setSuivant(suivantInfos);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("[ERREUR] " + e.getClass().getSimpleName() + " : "+ e.getMessage());
		}
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {

		if(args.length != 6 ){
			System.out.println("Usage : nom hote port [nomSuivant hoteSuivant portSuivant]");
			System.out.println("\tnom : Nom du serveur");
			System.out.println("\thote : Nom d'hote du serveur");
			System.out.println("\tport : Port du serveur (RMI Registry)(défaut: 1099)");
			System.out.println("\tnomSuivant : Nom du serveur suivant");
			System.out.println("\thoteSuivant : Nom de l'hote du serveur suivant");
			System.out.println("\tportSuivant : Port du serveur suivant");
			return;
		}

		ServeurInfos serveurInfos;
		serveurInfos = new ServeurInfos(args[0], args[1], Integer.parseInt(args[2]));

		ServeurInfos suivantInfos;
		suivantInfos = new ServeurInfos(args[3], args[4], Integer.parseInt(args[5]));

		ServeurLauncher serveur = new ServeurLauncher();
		serveur.run(serveurInfos, suivantInfos);
		
	}
	
}
