package ihm;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

import serveur.ServeurInfos;
import admin.Admin;
import admin.AdminActionListener;
import admin.AdminInfos;
import client.Client;
import client.ClientActionListener;
import client.ClientInfos;
import decoupage.Morceau;
import filtre.EnumTypeFiltre;

/**
 * Ihm - Ihm de notre application de traitement d'images en distribué.
 * 
 * 
 * @version 1.0 - 14/01/2009
 * @author Sebastien Cornevaux
 */
public class Ihm extends JFrame implements ClientActionListener, AdminActionListener {

	private static final long serialVersionUID = 1L;

	public final static String WINDOW_TEXT = "Traitement d'images en distribué";
	public final static int WIDTH_START = 800;
	public final static int HEIGHT_START = 600;
	
	// valeur par defaut variables config Rmi
	public final static String RMI_NAME = "Serv1";
	public final static String SERVEUR_MACHINE_RMI = "localhost";
	public final static String SERVEUR_PORT_RMI = "1099";
	
	public final static String CLIENT_RMI_NAME = "Client1";
	public final static String CLIENT_MACHINE_RMI = "localhost";
	public final static String CLIENT_PORT_RMI = "1099";
	
	public final static String NOM_ADMIN = "Admin1";
	
	
	String serveurRmiName;
	String serveurMachineRmi;
	int serveurPortRmi;
	String clientRmiName;
	String clientMachineRmi;
	String nomAdmin;
	int clientPortRmi;
	Image image;
	JPanel panel;
	JLabel label;
	BufferedImage bufferedImage;
	String imgPath;
	boolean actualisationImg;
	Client client;
	Admin admin;
	
	String currentFolder;
	
	JTextField serveurRmiNameText;
	JTextField serveurMachineRmiText;
	JTextField serveurPortRmiText;
	JTextField clientRmiNameText;
	JTextField clientMachineRmiText;
	JTextField clientPortRmiText;
	JTextField adminNomText;

	
	
	/**
	 * Constructeur
	 */
	public Ihm() {
		// titre de la fenetre
		super(WINDOW_TEXT);
		
		// config Rmi par defaut
		setServeurRmiName(RMI_NAME);
		setServeurMachineRmi(SERVEUR_MACHINE_RMI);
		setServeurPortRmi(new Integer(SERVEUR_PORT_RMI));
		setClientRmiName(CLIENT_RMI_NAME);
		setClientMachineRmi(CLIENT_MACHINE_RMI);
		setClientPortRmi(new Integer(CLIENT_PORT_RMI));
		setNomAdmin(NOM_ADMIN);
		
		
		
		//
		// JFrame de config RMI
		//
		final JFrame configRmiFrame = new JFrame("Configuration Rmi"); // fenetre de configuration Rmi
		configRmiFrame.setSize(400, 300);
		JPanel panelRmi = new JPanel();
		panelRmi.setLayout(new GridLayout(8, 2));
		
		
		
		//
		//
		// Nom serveur Rmi
		//
		//
		JLabel serveurRmiNameLabel = new JLabel("Nom Rmi serveur : ");
		panelRmi.add(serveurRmiNameLabel);
		
		serveurRmiNameText = new JTextField(getServeurRmiName());
		panelRmi.add(serveurRmiNameText);
		
		//
		//
		// Machine serveur Rmi
		//
		//
		JLabel serveurMachineRmiLabel = new JLabel("Machine serveur Rmi : ");
		panelRmi.add(serveurMachineRmiLabel);
		
		serveurMachineRmiText = new JTextField(getServeurMachineRmi());
		panelRmi.add(serveurMachineRmiText);
		
		
		//
		//
		// Port serveur Rmi
		//
		//
		JLabel serveurPortRmiLabel = new JLabel("Port serveur Rmi : ");
		panelRmi.add(serveurPortRmiLabel);
		
		serveurPortRmiText = new JTextField(getServeurPortRmi() + "");
		panelRmi.add(serveurPortRmiText);
		
		
		//
		//
		// Nom client Rmi
		//
		//
		JLabel clientRmiNameLabel = new JLabel("Nom Rmi client : ");
		panelRmi.add(clientRmiNameLabel);
		
		clientRmiNameText = new JTextField(getClientRmiName());
		panelRmi.add(clientRmiNameText);
		
		
		//
		//
		// Machine client Rmi
		//
		//
		JLabel clientMachineRmiLabel = new JLabel("Machine client Rmi : ");
		panelRmi.add(clientMachineRmiLabel);
		
		clientMachineRmiText = new JTextField(getClientMachineRmi());
		panelRmi.add(clientMachineRmiText);
		
		
		//
		//
		// Port client Rmi
		//
		//
		JLabel clientPortRmiLabel = new JLabel("Port client Rmi : ");
		panelRmi.add(clientPortRmiLabel);
		
		clientPortRmiText = new JTextField(getClientPortRmi() + "");
		panelRmi.add(clientPortRmiText);
		
		

		//
		//
		// Nom admin
		//
		//
		JLabel adminNomLabel = new JLabel("Nom Admin : ");
		panelRmi.add(adminNomLabel);
		
		adminNomText = new JTextField(getNomAdmin() + "");
		panelRmi.add(adminNomText);
		
		// panelRmi.setBorder(Border.NORTH);
		
		
		

		//
		//
		// Bouton annuler
		//
		//
		JButton cancelButton = new JButton("Annuler");
		panelRmi.add(cancelButton);
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				serveurRmiName = getServeurRmiName();
				serveurMachineRmi = getServeurMachineRmi();
				serveurPortRmi = getServeurPortRmi();
				clientRmiName = getClientRmiName();
				clientMachineRmi = getClientMachineRmi();
				clientPortRmi = getClientPortRmi();
				nomAdmin = getNomAdmin();
				
				System.out.println(serveurRmiName + " / " +
						serveurMachineRmi + " / " +
						serveurPortRmi + " / " +
						clientRmiName + " / " +
						clientMachineRmi + " / " +
						clientPortRmi);
				
				configRmiFrame.setVisible(false);
				
			}
		});
		
		
		//
		//
		// Bouton ok
		//
		//
		JButton okButton = new JButton("Valider");
		panelRmi.add(okButton);
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setServeurRmiName(serveurRmiNameText.getText());
				setServeurMachineRmi(serveurMachineRmiText.getText());
				setServeurPortRmi(new Integer(serveurPortRmiText.getText()));
				setClientRmiName(clientRmiNameText.getText());
				setClientMachineRmi(clientMachineRmiText.getText());
				setClientPortRmi(new Integer(clientPortRmiText.getText()));
				setNomAdmin(adminNomText.getText());
				
				System.out.println(serveurRmiName + " / " +
						serveurMachineRmi + " / " +
						serveurPortRmi + " / " +
						clientRmiName + " / " +
						clientMachineRmi + " / " +
						clientPortRmi);
				
				configRmiFrame.setVisible(false);
			}
		});
		configRmiFrame.add(panelRmi);
		configRmiFrame.setVisible(false);	
		
		
		client = null;
		actualisationImg = false;
		imgPath = "";
		currentFolder = "";
		
		//
		//
		// BARRE DE MENU
		//
		//
		JMenuBar barreMenu = new JMenuBar();
		this.setJMenuBar(barreMenu);

		//
		//
		// MENU FICHIER
		//
		//
		JMenu fichier = new JMenu("Fichier");
		setJMenuBar(barreMenu);
		barreMenu.add(fichier);

		//
		//
		// MENU FICHIER >> SOUS-MENU OUVRIR IMAGE
		//
		//
		JMenuItem ouvrir = new JMenuItem("Ouvrir une image");
		fichier.add(ouvrir);
		ouvrir.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("OUVERTURE");

				JFileChooser chooser = new JFileChooser();
				
				
				MonFiltre filtre = new MonFiltre( 
						new String[]{"bmp", "gif", "jpeg", "jpg", "png"},
								"les fichiers image (*.bmp, *.gif, *.jpeg, *.png)");				
				chooser.addChoosableFileFilter(filtre);
				
				
				if(currentFolder == "") chooser.setCurrentDirectory(new File("."));
				else chooser.setCurrentDirectory(new File(currentFolder));
				
				int retour = chooser.showOpenDialog(getIhm());
				
				if (retour == JFileChooser.APPROVE_OPTION) {
					
					setImgPath(chooser.getSelectedFile().getAbsolutePath());
					currentFolder = chooser.getSelectedFile().getParent();
					System.out.println("currentFolder = " + currentFolder);
					
					try {
						setBufferedImage(ImageIO.read(new java.io.File(getImgPath())));
						showImage(getBufferedImage());
					} catch (Exception e1) {
						JOptionPane.showMessageDialog(getIhm(), "Vous n'avez pas chargée un fichier image!","Erreur",JOptionPane.ERROR_MESSAGE);
					}
				} 
				else {
					System.out.println("Annulation.");
				}
			}
		});
		



		//
		//
		// MENU FICHIER >> SOUS-MENU ENREGISTRER IMAGE
		//
		//
		JMenuItem enregistrer = new JMenuItem("Enregistrer l'image");
		fichier.add(enregistrer);
		enregistrer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser savChooser = new JFileChooser();
				savChooser.setCurrentDirectory(new File(currentFolder));
				
				int retour = savChooser.showSaveDialog(getIhm());
				
				if (retour == JFileChooser.APPROVE_OPTION) {
					try {
						ImageIO.write(getBufferedImage(), "png", new java.io.File(savChooser.getSelectedFile().getAbsolutePath()));
					} catch (Exception e1) {
						JOptionPane.showMessageDialog(getIhm(), e1.getMessage(),"Erreur",JOptionPane.ERROR_MESSAGE);
					}
				}
				else {
					System.out.println("Annulation.");
				}
			}
		});
		
		/*
		//
		//
		// MENU FICHIER >> SOUS-MENU FERMER IMAGE
		//
		//
		JMenuItem fermer = new JMenuItem("Fermer l'image");
		fichier.add(fermer);
		fermer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getPanel().removeAll();
				repaint();
			}
		});
		*/
		
		//
		//
		// MENU FICHIER >> SOUS-MENU QUITTER APPLICATION
		//
		//
		JMenuItem quitter = new JMenuItem("Quitter");
		fichier.add(quitter);
		quitter.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int n = JOptionPane.showConfirmDialog(getIhm(),
						"Voulez-vous quitter ?", WINDOW_TEXT,
						JOptionPane.YES_NO_OPTION);
				if (n == JOptionPane.YES_OPTION) {
					System.exit(0);
				}
			}
		});

		//
		//
		// MENU CONFIGURATION
		//
		//
		JMenu configuration = new JMenu("Configuration");
		barreMenu.add(configuration);
		
		//
		//
		// MENU CONFIGURATION >> SOUS-MENU RMI
		//
		//
		JMenuItem rmi = new JMenuItem("Rmi");
		configuration.add(rmi);
		rmi.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				configRmiFrame.setVisible(true);
			}
		});
		
		
		
		
		//
		//
		// MENU TRAITEMENT
		//
		//
		JMenu traitement = new JMenu("Traitement");
		barreMenu.add(traitement);

		//
		//
		// MENU TRAITEMENT >> DETECTION DE CONTOUR
		//
		//
		JMenuItem contour = new JMenuItem("Détection de contour");
		traitement.add(contour);
		contour.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (imgPath != "") traitementIhm(EnumTypeFiltre.CONTOUR);
				else JOptionPane.showMessageDialog(getIhm(), "Pas d'image chargee","Erreur",JOptionPane.ERROR_MESSAGE);
			}
		});
		
		
		//
		//
		// MENU TRAITEMENT >> NEGATIF
		//
		//
		JMenuItem negatif = new JMenuItem("Negatif");
		traitement.add(negatif);
		negatif.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (imgPath != "") traitementIhm(EnumTypeFiltre.NEGATIF);
				else JOptionPane.showMessageDialog(getIhm(), "Pas d'image chargee","Erreur",JOptionPane.ERROR_MESSAGE);
			}
		});
		
		
		//
		//
		// MENU TRAITEMENT >> NOIR ET BLANC
		//
		//
		JMenuItem noirEtBlanc = new JMenuItem("Noir et blanc");
		traitement.add(noirEtBlanc);
		noirEtBlanc.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (imgPath != "") traitementIhm(EnumTypeFiltre.NOIR_ET_BLANC);
				else JOptionPane.showMessageDialog(getIhm(), "Pas d'image chargee","Erreur",JOptionPane.ERROR_MESSAGE);
			}
		});
		

		//
		//
		// MENU TRAITEMENT >> FLOU
		//
		//
		JMenuItem flou = new JMenuItem("Flou");
		traitement.add(flou);
		flou.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (imgPath != "") traitementIhm(EnumTypeFiltre.FLOU);
				else JOptionPane.showMessageDialog(getIhm(), "Pas d'image chargee","Erreur",JOptionPane.ERROR_MESSAGE);
			}
		});
		
		panel = new JPanel();
		
		panel.addComponentListener(new ComponentAdapter() {

			// optimisation pour bouffer moins de proc lors du 
			// redimensionnement de la fenetre contenant l'img 
			// (c Cyril qui m'a donne ça)
			public void componentResized(ComponentEvent e) {
				if (!actualisationImg) {
					actualisationImg = true;
					SwingUtilities.invokeLater(new Runnable(){
						public void run() {
							if (image != null)
								showImage(image);
							actualisationImg = false;
						}
					}
					);
				}
				
				
			}

		});

		
		
		//
		//
		// MENU MAINTENANCE
		//
		//
		JMenu maintenance = new JMenu("Maintenance");
		barreMenu.add(maintenance);

		
		//
		//
		// MENU MAINTENANCE >> ARRET DE LA PLATE-FORME
		//
		//
		JMenuItem arret = new JMenuItem("Arrêt de la plate-forme");
		maintenance.add(arret);
		arret.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					
					admin = new Admin(new AdminInfos(getIhm().getNomAdmin(),
							getIhm().getClientMachineRmi(),
							getIhm().getClientPortRmi()));
					admin.addAdminActionListener(getIhm());
					admin.init();
					
					admin.setServeur(new ServeurInfos(getIhm().getServeurRmiName(),
							getIhm().getServeurMachineRmi(),
							getIhm().getServeurPortRmi()));
					admin.demarrerTerminaison();
					
					
				} catch (Exception e1) {
					JOptionPane.showMessageDialog(getIhm(), e1.getMessage(),"Erreur",JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		
		panel.setLayout(new FlowLayout());
		label = new JLabel("");
		panel.add(label);

		setContentPane(panel);

		setSize(WIDTH_START, HEIGHT_START); // On donne une taille à notre
											// fenêtre
		// setLocationRelativeTo(null); //On centre la fenêtre sur l'écran
		// setResizable(false); //On interdit la redimensionnement de la fenêtre
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); // On dit à
														// l'application de se
														// fermer lors du clic
														// sur la croix
		setVisible(true);

	} // fin

	
	
	
	
	/**
	 * ajoutMorceau() - Place un morceau
	 * sur l'image dans l'ihm.
	 * 
	 * @param morceau
	 */
	public void ajoutMorceau(Morceau morceau){

		this.getBufferedImage().setRGB(
				morceau.getStartX(), 
				morceau.getStartY(), 
				morceau.getWidth(),
				morceau.getHeight(),
				morceau.getPixelsTab(),
				0,
				morceau.getWidth());
		this.showImage(this.getBufferedImage());
	}
	
	
	/**
	 * traitementIhm() - Instruction pour un traitement sur
	 * une image (methode appellee dans les listeners des 
	 * boutons des traitements).
	 * 
	 * @param filtre
	 */
	public void traitementIhm(EnumTypeFiltre filtre) {
		try {
			client = new Client(new ClientInfos(getIhm().getClientRmiName(),
					getIhm().getClientMachineRmi(),
					getIhm().getClientPortRmi()));
			client.addClientActionListener(getIhm());
			client.init();
			// TODO Spécifier le traitement
			client.setTraitement(filtre);
			client.setServeur(new ServeurInfos(getIhm().getServeurRmiName(),
					getIhm().getServeurMachineRmi(),
					getIhm().getServeurPortRmi()));
			client.readImage(getBufferedImage());
			client.traitementImage();
			
		} catch (Exception e1) {
			JOptionPane.showMessageDialog(getIhm(), e1.getMessage(),"Erreur",JOptionPane.ERROR_MESSAGE);
		}
	} // fin traitementIhm()
	
	
	
	/**
	 * showImage() - affichage d'une Image.
	 * 
	 * @param img
	 */
	public void showImage(Image img) {
		Image newIcon = img.getScaledInstance(panel.getWidth(), panel
				.getHeight(), Image.SCALE_DEFAULT);
		label.setIcon(new ImageIcon(newIcon));
		label.setText("");
		image = img;
	}
	
	/**
	 * showImage() - affichage d'un BufferedImage.
	 * 
	 * @param img
	 */
	public void showImage(BufferedImage img) {
		Image newIcon = img.getScaledInstance(panel.getWidth(), panel
				.getHeight(), Image.SCALE_DEFAULT);
		label.setIcon(new ImageIcon(newIcon));
		label.setText("");
		image = img;
	}
	
	/**
	 * Getters & Setters
	 * 
	 * 
	 */
	public Ihm getIhm() {
		return this;
	}
	public String getServeurRmiName() {
		return serveurRmiName;
	}
	public void setServeurRmiName(String serveurRmiName) {
		this.serveurRmiName = serveurRmiName;
	}
	public String getServeurMachineRmi() {
		return serveurMachineRmi;
	}
	public void setServeurMachineRmi(String serveurMachineRmi) {
		this.serveurMachineRmi = serveurMachineRmi;
	}
	public int getServeurPortRmi() {
		return serveurPortRmi;
	}
	public void setServeurPortRmi(int serveurPortRmi) {
		this.serveurPortRmi = serveurPortRmi;
	}
	public String getClientRmiName() {
		return clientRmiName;
	}
	public void setClientRmiName(String clientRmiName) {
		this.clientRmiName = clientRmiName;
	}
	public String getClientMachineRmi() {
		return clientMachineRmi;
	}
	public void setClientMachineRmi(String clientMachineRmi) {
		this.clientMachineRmi = clientMachineRmi;
	}
	public int getClientPortRmi() {
		return clientPortRmi;
	}
	public void setClientPortRmi(int clientPortRmi) {
		this.clientPortRmi = clientPortRmi;
	}
	public Image getImage() {
		return image;
	}
	public void setImage(Image image) {
		this.image = image;
	}
	public BufferedImage getBufferedImage() {
		return bufferedImage;
	}
	public void setBufferedImage(BufferedImage bufferedImage) {
		this.bufferedImage = bufferedImage;
	}
	public String getImgPath() {
		return imgPath;
	}
	public void setImgPath(String imgPath) {
		this.imgPath = imgPath;
	}
	public JPanel getPanel() {
		return panel;
	}
	public void setPanel(JPanel panel) {
		this.panel = panel;
	}

	public String getNomAdmin() {
		return nomAdmin;
	}
	public void setNomAdmin(String nomAdmin) {
		this.nomAdmin = nomAdmin;
	}
	
	
	/**
	 * Classe Filtre pour les jFileChooser.
	 * 
	 */
	class MonFiltre extends FileFilter {
		   String [] lesSuffixes;
		   String  laDescription;
		   public MonFiltre(String []lesSuffixes, 
		                         String laDescription){
		      this.lesSuffixes = lesSuffixes;
		      this.laDescription = laDescription;
		   }
		   boolean appartient( String suffixe ){
		      for( int i = 0; i<lesSuffixes.length; ++i)
		         if(suffixe.equals(lesSuffixes[i]))
		            return true;
		         return false;
		   }
		   public boolean accept(File f) {
		      if (f.isDirectory())  return true;
		      String suffixe = null;
		      String s = f.getName();
		      int i = s.lastIndexOf('.');
		      if(i > 0 &&  i < s.length() - 1)
		         suffixe=s.substring(i+1).toLowerCase();
		      return suffixe!=null&&appartient(suffixe);
		   }
		   // la description du filtre
		   public String getDescription() {
		      return laDescription;
		   }
		}

	public void onReceptionMorceau(Morceau m) {
		this.ajoutMorceau(m);		
	}

	public void onFinTraitement() {
		try {
			client.destroy();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		JOptionPane.showMessageDialog(getIhm(), "Le traitement s'est correctement terminé !", "Oh yeah !!", JOptionPane.INFORMATION_MESSAGE);
		
	}

	public void onFinTerminaison() {
		try {
			admin.destroy();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		JOptionPane.showMessageDialog(getIhm(), "La plate-forme été correctement arreté ! ", "Oh yeah !!", JOptionPane.INFORMATION_MESSAGE);
	}

} // fin classe Ihm