package decoupage;

import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;

/**
 * Decoupage - Decoupage d'une image en
 * un tableau de tableau de pixels.
 * 
 * @version 1.0 - 15/01/2008
 * @author Beuque & Cornevaux
 */
public class Decoupage {

	/** img a traiter */
	BufferedImage src;
	
	/** tableau contenant les morceaux d'images à traiter */
	Morceau[] tabMorceaux;
	
	
	
	
	/**
	 * getTabMorceaux() - Retourne tabMorceaux.
	 * 
	 * @return tabMorceaux
	 */
	public Morceau[] getTabMorceaux() {
		return tabMorceaux;
	}
	
	
	

	/**
	 * getTabMorceaux() - Retourne
	 * un morceau de l'image (suivant
	 * l'indice, du tableau de morceaux,
	 * passe en param).
	 * 
	 * 
	 * @param i
	 * @return
	 */
	public Morceau getTabMorceaux(int i) {
		return tabMorceaux[i];
	}
		
	/**
	 * Constructeur - Pour le moment je
	 * fait tout le decoupage ici, a 
	 * revoir eventuellement plus tard
	 * (decoupage en methode?)
	 * 
	 * @param imageIn
	 * @throws IOException
	 */
	public Decoupage(File imageIn) throws IOException {
		System.out.println("Decoupage de l'img en morceau : go!");
		
		BufferedImage src = ImageIO.read(new java.io.File(imageIn.getAbsolutePath()));
		
		int width = src.getWidth();

		int height = src.getHeight();

		int nbMorceaux = 0;

		int nbImgColonneApresDecoupage = width / 200;
		if (width % 200 != 0)
			nbImgColonneApresDecoupage++;
		int nbImgLigneApresDecoupage = height / 200;
		if (height % 200 != 0)
			nbImgLigneApresDecoupage++;

		for (int ligne = 0; ligne < nbImgLigneApresDecoupage; ligne++) {
			for (int colonne = 0; colonne < nbImgColonneApresDecoupage; colonne++) {
				nbMorceaux++;
			}
		}

		tabMorceaux = new Morceau[nbMorceaux];

		int tabMorceauxIndice = 0;

		int srcPixels[];
		int widthLittleImg = 0;
		int heightLittleImg = 0;

		for (int ligne = 0; ligne < nbImgLigneApresDecoupage; ligne++) {
			for (int colonne = 0; colonne < nbImgColonneApresDecoupage; colonne++) {
				if (colonne < nbImgColonneApresDecoupage - 1)
					widthLittleImg = 200;
				else
					widthLittleImg = (width - (colonne * 200));
				if (ligne < nbImgLigneApresDecoupage - 1)
					heightLittleImg = 200;
				else
					heightLittleImg = (height - (ligne * 200));

				srcPixels = src.getRGB(colonne * 200, ligne * 200,
						widthLittleImg, heightLittleImg, null, 0,
						widthLittleImg);
				
				System.out.println("Morceau " + (tabMorceauxIndice + 1) + " : ");
				System.out.println("\tStart x : " + colonne * 200);
				System.out.println("\tStart y : " + ligne * 200);
				System.out.println("\tWidth : " + widthLittleImg);
				System.out.println("\tHeight : " + heightLittleImg);
				tabMorceaux[tabMorceauxIndice] = new Morceau(srcPixels, colonne * 200, ligne * 200, widthLittleImg, heightLittleImg);
				tabMorceauxIndice++;

			} // fin for colonne
		} // fin for ligne
		
		System.out.println("Decoupage de l'img en morceau ok!");
		
	} // fin constructeur
	
	public static List<Morceau> decoupe(ImageSerializable image) throws IOException {
		
		int width = image.width;
		int height = image.height;

		int nbMorceaux = 0;

		int nbImgColonneApresDecoupage = width / 200;
		if (width % 200 != 0)
			nbImgColonneApresDecoupage++;
		int nbImgLigneApresDecoupage = height / 200;
		if (height % 200 != 0)
			nbImgLigneApresDecoupage++;

		for (int ligne = 0; ligne < nbImgLigneApresDecoupage; ligne++) {
			for (int colonne = 0; colonne < nbImgColonneApresDecoupage; colonne++) {
				nbMorceaux++;
			}
		}

		List<Morceau> lstMorceau = new ArrayList<Morceau>(nbMorceaux);

		int tabMorceauxIndice = 0;

		int widthLittleImg = 0;
		int heightLittleImg = 0;

		for (int ligne = 0; ligne < nbImgLigneApresDecoupage; ligne++) {
			for (int colonne = 0; colonne < nbImgColonneApresDecoupage; colonne++) {
				if (colonne < nbImgColonneApresDecoupage - 1)
					widthLittleImg = 200;
				else
					widthLittleImg = (width - (colonne * 200));
				if (ligne < nbImgLigneApresDecoupage - 1)
					heightLittleImg = 200;
				else
					heightLittleImg = (height - (ligne * 200));				
				
				int[] pixelsMorceau;
				pixelsMorceau = new int[widthLittleImg * heightLittleImg];
				PixelGrabber pg = new PixelGrabber(image.getImage(),
						colonne * 200, ligne * 200,
						widthLittleImg, heightLittleImg, pixelsMorceau, 0, widthLittleImg);
				try {
					pg.grabPixels();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				tabMorceauxIndice++;
				
				System.out.println("Morceau " + (tabMorceauxIndice + 1) + " : ");
				System.out.println("\tStart x : " + colonne * 200);
				System.out.println("\tStart y : " + ligne * 200);
				System.out.println("\tWidth : " + widthLittleImg);
				System.out.println("\tHeight : " + heightLittleImg);
				Morceau m = new Morceau(pixelsMorceau, colonne * 200, ligne * 200, widthLittleImg, heightLittleImg);
				m.setNum(tabMorceauxIndice);
				m.setMax(nbMorceaux);
				lstMorceau.add(m);

			} // fin for colonne
		} // fin for ligne
		
		System.out.println("Decoupage de l'img en morceau ok!");
		
		return lstMorceau;
		
	}

} // fin classe Decoupage
