package client;

import serveur.ServeurInfos;
import decoupage.Morceau;
import filtre.EnumTypeFiltre;

public class ClientLauncher implements ClientActionListener {

	private Client client;
	
	public void run(ClientInfos clientInfos, ServeurInfos serveurInfos, String fichier){	
		try {
			client = new Client(clientInfos);
			client.addClientActionListener(this);
			client.init();
			client.setServeur(serveurInfos);
			client.readImage(fichier);
			client.setTraitement(EnumTypeFiltre.CONTOUR);
			client.traitementImage();
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("[ERREUR] " + e.getClass().getSimpleName() + " : "+ e.getMessage());
		}
	}

	public void onReceptionMorceau(Morceau m){
	
	}
	
	public void onFinTraitement(){
		try {
			client.destroy();
		} catch (Exception e) {
			System.out.println("[ERREUR] " + e.getClass().getSimpleName() + " : "+ e.getMessage());
		}
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {

		if(args.length != 7){
			System.out.println("Usage : nom hote port nomServeur hoteSuivant portSuivant image");
			System.out.println("\tnom : Nom du client");
			System.out.println("\thote : Nom d'hote du client");
			System.out.println("\tport : Port du client (RMI Registry)(défaut: 1099)");
			System.out.println("\tnomServeur : Nom du serveur");
			System.out.println("\thoteServeur : Nom de l'hote du serveur");
			System.out.println("\tportServeur : Port du serveur");
			System.out.println("\timage : Image a envoyer au serveur");
			return;
		}

		ClientInfos clientInfos;
		clientInfos = new ClientInfos(args[0], args[1], Integer.parseInt(args[2]));

		ServeurInfos serveurInfos;
		serveurInfos = new ServeurInfos(args[3], args[4], Integer.parseInt(args[5]));

		String fichier = args[6];

		ClientLauncher client = new ClientLauncher();
		client.run(clientInfos, serveurInfos, fichier);
	}
}
