/*
 **********************************************************
 *
 *  Programme : siam.h
 *
 *  ecrit par : LP / JMN / FB
 *
 *  resume : entete pour la validation des coups
 *
 *  date :      29/ 02 /08
 *  modifie : 
 ***********************************************************
 */
#ifndef _siam_h
#define _siam_h

#include "protocolArbitre.h"

/* Nombre colonnes */
#define NB_COLONNE 5

/* Nombre lignes */
#define NB_LIGNE 5

/* Etat des cases */
typedef enum { CS_VIDE, CS_RHINO, CS_ELEPH, CS_ROCHER } TypEtatPiece;
typedef enum { O_SANS, O_NORD, O_EST, O_SUD, O_OUEST } TypOrientationCase;
typedef struct {

  TypEtatPiece piece;
  TypOrientationCase orientation;

} TypEtatCase;

/* Definition d'une partie */
typedef struct {

  int joueur1;  /* Joueur jouant en premier */
  int joueur2;  /* joueur jouant en second */
  int gagnant;  /* id du joueur gagnant */
  int numeroCoup; /* Numero du coup */
  TypEtatCase plateau[NB_LIGNE][NB_COLONNE];  /* plateau de siam */
			/*  0 : pas de pion
			 *  1 : pion */

} TypPartie;

/* Initialisation d'une partie */
TypPartie* nouvellePartie(int j1, int j2);


/* Validation d'un coup on doit passer :
 * une partie
 * le numero du joueur 0 pour A et 1 pour B
 * le deplacement joue
 * le type de coup (TypPropCoup)
 Elle renvoie TypBooleen */
TypBooleen validationCoup(
			  TypPartie*  par, 
			  int         joueur, 
			  TypDeplace  deplace, 
			  TypPropCoup tCoup
			  );

/*
 * Affichage d'une partie
 */
void afficher(TypPartie * par);

#endif
