/**
 *
 */
package relais;

import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;

import server.ICertificatServeur;
import RelaisApp.RelaisPOA;

/**
 * Serveur relais ProjetSD <br>
 * RelaisServer -
 * 
 * @version 1.0
 * @author Cyril
 * @date 10 janv. 2009
 * @notes
 */
public class RelaisServer extends RelaisPOA implements Runnable {
	private final java.lang.Object demande = new java.lang.Object();
	boolean demanderCertificatServeur = false;
	boolean demanderCertificatClient = false;
	boolean demandeEnCours = false;
	boolean attenteCertificat = false;
	private String certificat = null;
	private boolean run = false;
	private QueueRelaisServeur queue;
	private TopicRelaisServeur topic;
	private String openSSLReq;

	/**
	 * Constructeur
	 * 
	 * @throws NamingException
	 * 
	 * @throws NamingException
	 * @throws JMSException
	 */
	public RelaisServer() {
	}

	/**
	 * Créer un serveur relais
	 * 
	 * @return Serveur crée
	 */
	public static RelaisServer create() {
		RelaisServer serveur = new RelaisServer();
		Thread thread = new Thread(serveur, "ServeurRelais");
		thread.start();
		return serveur;
	}

	public static void main(String[] args) {
		// create servant
		RelaisServer serveur = RelaisServer.create();
		for (int i = 0; i < 2; i++) {
			String certificat = serveur.getCertificatAutorite();
			System.out.println(certificat);
			certificat = serveur.getNouveauCertificat("toto");
			System.out.println(certificat);
		}

	}

	/**
	 * @see RelaisApp.RelaisOperations#getCertificatAutorite()
	 */
	public String getCertificatAutorite() {
		System.out.println("getCertificatAutorite");
		synchronized (demande) {
			demanderCertif();
			demanderCertificatServeur = true;
			demande.notifyAll();
			return recupererCertificat();
		}
	}

	/**
	 * Methode de demande d'un certificat jusqu'à ce que la demande précedente
	 * soit réalisée
	 * 
	 * 
	 * @Author Cyril
	 * @date 10 janv. 2009
	 */
	private void demanderCertif() {
		synchronized (demande) {
			while (demandeEnCours) {
				try {
					demande.wait();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			demandeEnCours = true;
			demande.notifyAll();
		}
	}

	/**
	 * Attend jusqu'à la reception du certificat
	 * 
	 * @return Certificat
	 * 
	 * @Author Cyril
	 * @date 10 janv. 2009
	 */
	private String recupererCertificat() {
		synchronized (demande) {
			while (certificat == null) {
				System.out.println("Attendre certificat !!!");
				try {
					demande.wait();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}

			String res = certificat;
			certificat = null;
			demandeEnCours = false;
			demanderCertificatClient = false;
			demanderCertificatServeur = false;
			attenteCertificat = false;
			demande.notifyAll();
			return res;
		}
	}

	/**
	 * @see RelaisApp.RelaisOperations#getNouveauCertificat(java.lang.String)
	 */
	public String getNouveauCertificat(String openSSLReq) {
		System.out.println("getNouveauCertificat");
		synchronized (demande) {
			demanderCertif();
			this.openSSLReq = openSSLReq;
			demanderCertificatClient = true;
			demande.notifyAll();
			return recupererCertificat();
		}
	}

	/**
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		System.out.println("Initialisation du relais");
		try {
			// Tant que le topic n'a pas démarré réessayer toutes les 2secondes
			while (!run) {
				try {
					topic = new TopicRelaisServeur(this,
							ICertificatServeur.DEFAULT_TOPIC,
							ICertificatServeur.DEFAULT_TOPIC_FACTORY);
					run = true;
				} catch (Exception e) {
					e.printStackTrace();
					System.err.println("Topic not find "
							+ "\n Veuillez démarrer le serveur de certificat");
				}
				Thread.sleep(2000);
			}

			System.out.println("Serveur relais pret");
			while (run) {
				synchronized (this) {
					wait();
				}
			}
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		} finally {
			topic.close();
		}
	}

	public void stopServeur() {
		run = false;
		synchronized (this) {
			this.notify();
		}
	}

	public void retournerCertificat(String certificat) {
		System.out.println("Certificat retourné");
		synchronized (demande) {
			this.certificat = certificat;
			demande.notifyAll();
		}
	}

	public void setServeurPret(Queue q, QueueConnectionFactory qcf) {
		synchronized (demande) {
			if (demandeEnCours && !attenteCertificat) {
				System.out
						.println("Serveur de certificat prêt pour généner certificat !! ");
				try {
					if (queue != null) {
						queue.close();
					}
					queue = new QueueRelaisServeur(this, q, qcf);
					if (demanderCertificatClient) {
						queue.demanderCertificatClient(openSSLReq);
						attenteCertificat = true;
					} else if (demanderCertificatServeur) {
						queue.demanderCertificatServeur();
						attenteCertificat = true;
					}
				} catch (JMSException e) {
					e.printStackTrace();
				}
			}
		}
	}

	private void affichageInfoCertificat(String certif) {
		int index = certif.indexOf("CN=");
		int index2 = certif.indexOf("\n", index);
		System.out.println(certif.substring(index, index2));

		int index1 = certif.indexOf("Not After : ") + 12;
		int index3 = certif.indexOf("\n", index1);
		System.out.println("Date de validité="
				+ certif.substring(index1, index3));

	}
}
