package projet.jsr;
import java.util.ArrayList;
import java.util.Iterator;

import projet.jsr.Person;

import jsr166y.forkjoin.ForkJoinPool;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.ParallelArray;
import jsr166y.forkjoin.ParallelArray.SummaryStatistics;

public class Test {

	/**
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {
		// Creation du pool de threads et initialisation du ParallelArray :
		final ForkJoinPool pool = new ForkJoinPool(2);
		ArrayList<Person> people = new ArrayList<Person>();
		people.add(new Person("toto", Person.MALE, 12, 120));
		people.add(new Person("toto1", Person.MALE, 12, 120));
		people.add(new Person("toto2", Person.MALE, 12, 120));
		people.add(new Person("toto3", Person.MALE, 12, 120));
		people.add(new Person("toto4", Person.MALE, 12, 120));
		people.add(new Person("toto5", Person.MALE, 12, 120));

		Person[] peopleList = new Person[people.size()];
		Iterator<Person> iter = people.iterator();
		int i= 0;
		while(iter.hasNext()){
			peopleList[i] = iter.next();
			i++;
		}


		final ParallelArray<Person> peopleArray = ParallelArray.createFromCopy(

		peopleList, pool);

		// Creation du filtre: les hommes entre 18 et 25 ans
		final Ops.Predicate<Person> isYoungMan = new Ops.Predicate<Person>() {
			public boolean op(final Person p) {
				return p.getGender() == Person.MALE && p.getAge() > 18
						&& p.getAge() <= 25;
			}
		};

		// Creation de l'opération de calcul de l'IMC
		final Ops.ObjectToDouble<Person> retrieveBMI = new Ops.ObjectToDouble<Person>() {
			public double op(Person p) {
				return p.getHeight() / (p.getHeight() * p.getHeight());
			}
		};

		SummaryStatistics<Person>  summary =(SummaryStatistics<Person>) peopleArray.withFilter(
				isYoungMan).withMapping(retrieveBMI).summary();

		System.out.println("Personne à plus haut IMC : "
				+ peopleArray.get(summary.indexOfMax()).getName());

	}
}