/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

final class PoolBarrier {
    final AtomicLong counter = new AtomicLong();
    final AtomicReference<QNode> head = new AtomicReference();

    PoolBarrier() {
    }

    final long getCount() {
        return this.counter.get();
    }

    final long sync(long prev) {
        long count = this.counter.get();
        if (count != prev || this.enqAndWait(count)) {
            this.releaseAll();
        }
        return count;
    }

    final void signal() {
        this.counter.incrementAndGet();
        this.releaseAll();
    }

    final boolean trySignal() {
        QNode q;
        AtomicReference<QNode> hd = this.head;
        AtomicLong ctr = this.counter;
        long c = ctr.get();
        boolean inc = ctr.compareAndSet(c, c + 1L);
        while (!((q = hd.get()) == null || q.count > c || hd.compareAndSet(q, q.next) && q.signal())) {
        }
        return inc;
    }

    private final boolean enqAndWait(long count) {
        QNode h;
        AtomicReference<QNode> hd = this.head;
        AtomicLong ctr = this.counter;
        QNode node = null;
        while (((h = hd.get()) == null || h.count == count) && ctr.get() == count) {
            if (node == null) {
                node = new QNode(count);
                continue;
            }
            node.next = h;
            if (!hd.compareAndSet(node.next, node)) continue;
            while (!Thread.interrupted() && node.thread != null && ctr.get() == count) {
                LockSupport.park(this);
            }
            node.thread = null;
            if (ctr.get() != count) break;
            return false;
        }
        return true;
    }

    private final void releaseAll() {
        QNode q;
        AtomicReference<QNode> hd = this.head;
        while ((q = hd.get()) != null) {
            if (!hd.compareAndSet(q, null)) continue;
            do {
                q.signal();
            } while ((q = q.next) != null);
            break;
        }
    }

    static final class QNode {
        QNode next;
        volatile Thread thread;
        final long count;

        QNode(long c) {
            this.count = c;
            this.thread = Thread.currentThread();
        }

        final boolean signal() {
            Thread t = this.thread;
            if (t == null) {
                return false;
            }
            this.thread = null;
            LockSupport.unpark(t);
            return true;
        }
    }
}

