/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import jsr166y.forkjoin.AbstractParallelAnyArray;
import jsr166y.forkjoin.CommonOps;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.PAS;
import jsr166y.forkjoin.ParallelDoubleArray;
import jsr166y.forkjoin.ParallelDoubleArrayWithDoubleMapping;

public abstract class ParallelDoubleArrayWithFilter
extends ParallelDoubleArrayWithDoubleMapping {
    ParallelDoubleArrayWithFilter(ForkJoinExecutor ex, int origin, int fence, double[] array) {
        super(ex, origin, fence, array);
    }

    public ParallelDoubleArrayWithFilter replaceWithMapping(Ops.DoubleOp op) {
        this.ex.invoke(new PAS.FJDTransform(this, this.origin, this.fence, null, op));
        return this;
    }

    public ParallelDoubleArrayWithFilter replaceWithMappedIndex(Ops.IntToDouble op) {
        this.ex.invoke(new PAS.FJDIndexMap(this, this.origin, this.fence, null, op));
        return this;
    }

    public ParallelDoubleArrayWithFilter replaceWithMappedIndex(Ops.IntAndDoubleToDouble op) {
        this.ex.invoke(new PAS.FJDBinaryIndexMap(this, this.origin, this.fence, null, op));
        return this;
    }

    public ParallelDoubleArrayWithFilter replaceWithGeneratedValue(Ops.DoubleGenerator generator) {
        this.ex.invoke(new PAS.FJDGenerate(this, this.origin, this.fence, null, generator));
        return this;
    }

    public ParallelDoubleArrayWithFilter replaceWithValue(double value) {
        this.ex.invoke(new PAS.FJDFill(this, this.origin, this.fence, null, value));
        return this;
    }

    public ParallelDoubleArrayWithFilter replaceWithMapping(Ops.BinaryDoubleOp combiner, ParallelDoubleArrayWithDoubleMapping other) {
        this.ex.invoke(new PAS.FJDPACombineInPlace(this, this.origin, this.fence, null, other, other.origin - this.origin, combiner));
        return this;
    }

    public ParallelDoubleArrayWithFilter replaceWithMapping(Ops.BinaryDoubleOp combiner, double[] other) {
        this.ex.invoke(new PAS.FJDCombineInPlace(this, this.origin, this.fence, null, other, -this.origin, combiner));
        return this;
    }

    public ParallelDoubleArray allUniqueElements() {
        PAS.UniquifierTable tab = new PAS.UniquifierTable(this.fence - this.origin, this, false);
        PAS.FJDUniquifier f = new PAS.FJDUniquifier(this, this.origin, this.fence, null, tab);
        this.ex.invoke(f);
        double[] res = tab.uniqueDoubles(f.count);
        return new ParallelDoubleArray(this.ex, res);
    }

    public abstract ParallelDoubleArrayWithFilter withFilter(Ops.DoublePredicate var1);

    public ParallelDoubleArrayWithFilter withFilter(Ops.BinaryDoublePredicate selector, ParallelDoubleArrayWithDoubleMapping other) {
        return this.withIndexedFilter(AbstractParallelAnyArray.indexedSelector(selector, other, this.origin));
    }

    public abstract ParallelDoubleArrayWithFilter withIndexedFilter(Ops.IntAndDoublePredicate var1);

    public boolean hasAllEqualElements(ParallelDoubleArrayWithDoubleMapping other) {
        return this.withFilter(CommonOps.doubleInequalityPredicate(), other).anyIndex() < 0;
    }

    @Override
    final void leafTransfer(int lo, int hi, double[] dest, int offset) {
        double[] a = this.array;
        for (int i = lo; i < hi; ++i) {
            dest[offset++] = a[i];
        }
    }

    @Override
    final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
        double[] a = this.array;
        for (int i = loIdx; i < hiIdx; ++i) {
            dest[offset++] = a[indices[i]];
        }
    }

    @Override
    final double dget(int i) {
        return this.array[i];
    }
}

