package memoire;

/**
 * @author Ludovic RICHARD et Ronald SREY
 * 
 * Cette classe creee des objets quadruplets. Ces objet sont stockes 
 * en memoire dans la pile ou dans le tas.
 *
 */
public class Qua {

	protected String id; // identifiant.
	protected Object val; // valeur.
	protected String obj; // type objet minijaja.
	protected String sorte; // type (entier ou booleen).

	/* *** Constructeurs *** */
	
	/**
	 * Constructeur d'un Qua 
	 * @param id identifiant
	 * @param val valeur
	 * @param obj objet (cst, var, meth, vcst)
	 * @param sorte (entier, booleen)
	 */
	public Qua(String id, Object val, String obj, String sorte) {
		this.id = id;
		this.val = val;
		this.obj = obj;
		this.sorte = sorte;
	}
	
	/**
	 *  Constructeur par recopie.
	 */
	public Qua(Qua q){
		this.id = q.id;
		this.val = q.val;
		this.obj = q.obj;
		this.sorte = q.sorte;
	}
	
	/* *** Methode d'acces aux attributs *** */
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Object getVal() {
		return val;
	}

	public void setVal(Object val) {
		this.val = val;
	}

	public String getObj() {
		return obj;
	}

	public void setObj(String obj) {
		this.obj = obj;
	}

	public String getSorte() {
		return sorte;
	}

	public void setSorte(String sorte) {
		this.sorte = sorte;
	}
	
	/* *** Autres *** */
	
	/**
	 * Renvoi une chaine de caractere representant un Qua
	 * @return chaine de caractere representant le Qua
	 */
	public String toString(){
		String ret = "<";
		if(this.id==null){
			ret+="~";
		}else{
			ret+=this.id;
		}
		ret += "," + this.val + "," + this.obj + ",";
		if(this.sorte==null){
			ret+="*";
		}else{
			ret+=this.sorte;
		}
		ret += ">";
		return ret;
	}
	
	public boolean compareTo(Qua q2){
		return(this.id == q2.getId() && this.obj == q2.getObj() && this.sorte == q2.getSorte());
	}
}
