package memoire;

/**
 * trunk.memoire.Bloc.java
 * @author Ludovic
 */
public class Bloc {

	private int valeur;
	private int psuivant; // pointeur sur l'lment suyivant dans le tas
	private boolean markflag; // le drapeau

	/**
	 * Constructeur de la classe memoire.Bloc.java
	 * @param valeur Entier contenu dans le bloc
	 */
	public Bloc(int valeur) {
		this.valeur = valeur;
	}
	/**
	 * Constructeur par recopie de la classe memoire.Bloc.java
	 * @param b un bloc
	 */
	public Bloc(Bloc b) {
		this.valeur = b.getValeur();
		this.setPsuivant(b.getPsuivant());
		this.markflag = b.isMarkflag();
	}
	/**
	 * Revoie la valeur du membre psuivant.
	 */
	public int getPsuivant() {
		return psuivant;
	}
	/**
	 * Affecte une nouvelle valeur au membre psuivant.
	 */
	public void setPsuivant(int psuivant) {
		this.psuivant = psuivant;
	}
	/**
	 * Revoie la valeur du membre valeur.
	 */
	public int getValeur() {
		return valeur;
	}
	/**
	 * Affecte une nouvelle valeur au membre valeur.
	 */
	public void setValeur(int valeur) {
		this.valeur = valeur;
	}
	/**
	 * Revoie la valeur du membre markflag.
	 */
	public boolean isMarkflag() {
		return markflag;
	}
	/**
	 * Affecte une nouvelle valeur au membre markflag.
	 */
	public void setMarkflag(boolean markflag) {
		this.markflag = markflag;
	}
	
	/**
	   * Affiche le bloc dans une chaine de caracteres
	   * @return une chaine de caracteres
	   */
	public String toString(){
		return(new String("["+this.valeur+"|"+this.psuivant+"]"));		
	}
	
	
	/* test*/
	public static void main(String[] args) {
		
		 int k = 15; 
		 Bloc bloc = new Bloc(k);		
			
		 System.out.println("Dbut du test de bloc");
			
		
		 System.out.println("Bloc ="+bloc.toString());	
		 System.out.println("valeur ="+bloc.getValeur());
		 System.out.println("drapeau ="+bloc.isMarkflag());
		
		 System.out.println("fin du test de bloc !");
	}
	
}
