package jajacode.interpreteur;

import jajacode.jjtree.*;
import jajacode.exception.*;;

public class ToStringJajaCodeInstrVisitor implements JajaCodeVisitor {
	
	public Object visit(SimpleNode node, Object data) throws JajaCodeVisitorException{
		return new String("Erreur...");
	}
	
	public Object visit(ASTJajaCode node, Object data) throws JajaCodeVisitorException {
		
		int adresse = ((Integer)data).intValue();
	    
	    if(adresse<=0){
			return new String("");
		}
		// Si egal, on interprete, l'instruction du noeud courant
		if(adresse==((ASTJCNbre)node.jjtGetChild(0)).getValeur()){
			String s="";
		    s+=node.jjtGetChild(1).jjtAccept(this,data);
		    s+=" at line ";
		    s+=node.jjtGetChild(0).jjtAccept(this,data);
			return s;
		}else{
			return node.jjtGetChild(2).jjtAccept(this,data);
		}
	}
	
	public Object visit(ASTJCNil node, Object data) throws JajaCodeVisitorException {
		return new String("");
	}
	
	public Object visit(ASTInit node, Object data) throws JajaCodeVisitorException {
		return new String("init");
	}
	
	public Object visit(ASTSwap node, Object data) throws JajaCodeVisitorException {
		return new String("swap");
	}
	
	public Object visit(ASTNew node, Object data) throws JajaCodeVisitorException {
		String s="new(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=",";
	    s+=node.jjtGetChild(1).jjtAccept(this,data);
	    s+=",";
	    s+=node.jjtGetChild(2).jjtAccept(this,data);
	    s+=",";
	    s+=node.jjtGetChild(3).jjtAccept(this,data);
	    s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTNewArray node, Object data) throws JajaCodeVisitorException {
		String s="newarray(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=",";
	    s+=node.jjtGetChild(1).jjtAccept(this,data);
	    s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTInvoke node, Object data) throws JajaCodeVisitorException {
		String s="invoke(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTReturn node, Object data) throws JajaCodeVisitorException {
		return new String("return");
	}
	
	
	public Object visit(ASTPush node, Object data) throws JajaCodeVisitorException {
		String s="push(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTPop node, Object data) throws JajaCodeVisitorException {
		return new String("pop");
	}
	
	public Object visit(ASTLoad node, Object data) throws JajaCodeVisitorException {
		String s="load(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTALoad node, Object data) throws JajaCodeVisitorException {
		String s="aload(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTStore node, Object data) throws JajaCodeVisitorException {
		String s="store(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTAStore node, Object data) throws JajaCodeVisitorException {
		String s="astore(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTIf node, Object data) throws JajaCodeVisitorException {
		String s="if(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTGoto node, Object data) throws JajaCodeVisitorException {
		String s="goto(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTInc node, Object data) throws JajaCodeVisitorException {
		String s="inc(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTAInc node, Object data) throws JajaCodeVisitorException {
		String s="ainc(";
		s+=node.jjtGetChild(0).jjtAccept(this,data);
		s+=")";
	    return new String(s);
	}
	
	public Object visit(ASTNop node, Object data) throws JajaCodeVisitorException {
		return new String("nop");
	}
	
	public Object visit(ASTJCStop node, Object data) throws JajaCodeVisitorException {
		return new String("jcstop");
	}
	
	public Object visit(ASTJCIdent node, Object data) throws JajaCodeVisitorException {
		return node.getValeur();
	}
	
	public Object visit(ASTJCType node, Object data) throws JajaCodeVisitorException {
		return node.getValeur();
	}
	
	public Object visit(ASTJCSorte node, Object data) throws JajaCodeVisitorException {
		return node.getValeur();
	}
	
	public Object visit(ASTJCVrai node, Object data) throws JajaCodeVisitorException {
		return new String("true");
	}
	
	public Object visit(ASTJCFaux node, Object data) throws JajaCodeVisitorException {
		return new String("false");
	}
	
	public Object visit(ASTNeg node, Object data) throws JajaCodeVisitorException {
		return new String("neg");
	}
	
	public Object visit(ASTNot node, Object data) throws JajaCodeVisitorException {
		return new String("not");
	}
	
	public Object visit(ASTAdd node, Object data) throws JajaCodeVisitorException {
		return new String("add");
	}
	public Object visit(ASTSub node, Object data) throws JajaCodeVisitorException {
		return new String("sub");
	}
	public Object visit(ASTMul node, Object data) throws JajaCodeVisitorException {
		return new String("mul");
	}
	public Object visit(ASTDiv node, Object data) throws JajaCodeVisitorException {
		return new String("div");
	}
	public Object visit(ASTCmp node, Object data) throws JajaCodeVisitorException {
		return new String("cmp");
	}
	public Object visit(ASTSup node, Object data) throws JajaCodeVisitorException {
		return new String("sup");
	}
	public Object visit(ASTInf node, Object data) throws JajaCodeVisitorException {
		return new String("inf");
	}
	public Object visit(ASTOr node, Object data) throws JajaCodeVisitorException {
		return new String("or");
	}
	public Object visit(ASTAnd node, Object data) throws JajaCodeVisitorException {
		return new String("and");
	}
	public Object visit(ASTJCNbre node, Object data) throws JajaCodeVisitorException {
		return node.getValeur();
	}
}
