package jajacode.interpreteur;

import java.io.*;

import memoire.*;
import minijaja.compilateur.CompilateurMiniJaja;
import minijaja.exception.MiniJajaVisitorException;
import jajacode.jjtree.*;
import jajacode.exception.*;

public class InterpreteurJajaCode {
	
	
	public Node arbreAnalyse;
	public Reader jajacode;
	
	public InterpreteurJajaCodeData idata;
	
	public InterpreteurJajaCode(Reader jajacode){
		idata = new InterpreteurJajaCodeData();
		this.jajacode = jajacode;
		arbreAnalyse = null;
	}
	
	public void parseJajaCode() throws FileNotFoundException, ParseException {
		JajaCode parser = new JajaCode(this.jajacode);
	    parser.Classe();
	    arbreAnalyse = parser.getJJTree().rootNode();
	}
	
	public Object executeVisitor(JajaCodeVisitor visitor, Object data) throws JajaCodeVisitorException{
		return this.arbreAnalyse.jjtAccept(visitor,data);
	}
	
	public void interpreteJajaCode() throws JajaCodeInstructionException {
		while(this.hasNextInstructionToInterperte()){
			this.interpreteNextInstruction();
		}
	}
	
	public void interpreteNextInstruction() throws JajaCodeInstructionException {
		try{
			System.out.println(this.executeVisitor(new ToStringJajaCodeInstrVisitor(),new Integer(idata.getAdresse())));
			this.executeVisitor(new InterpreteJajaCodeVisitor(),idata);
			System.out.println(idata.memoire);
		}catch(JajaCodeVisitorException e){
			throw new JajaCodeInstructionException(e.toString());
		}
		
	}
	
	public boolean hasNextInstructionToInterperte(){
		if(idata.getAdresse()>0){
			return true;
		}else{
			return false;
		}
	}
	
	public static void main(String args[]) throws Exception {
		InterpreteurJajaCode interpreteur;
		//InterpreteurJajaCode interpreteur = new InterpreteurJajaCode(new FileReader(new File("./src/jajacode/exemple.txt")));

		if(args.length>=1 && args.length<=2){
			
			if(args.length==1){
				interpreteur = new InterpreteurJajaCode(new FileReader(new File(args[0])));
				try{
				    interpreteur.parseJajaCode();
				    interpreteur.interpreteJajaCode();
				}catch(JajaCodeInstructionException e){
					System.err.println(e.toString());
				}
			}else{
				interpreteur = new InterpreteurJajaCode(new FileReader(new File(args[0])));
				try{
				    interpreteur.parseJajaCode();
				    while(interpreteur.hasNextInstructionToInterperte()){
				    	interpreteur.interpreteNextInstruction();
				    	System.out.println("Ctrl-D pour continuer");
				    	System.in.read();
					}
				    interpreteur.interpreteJajaCode();
				}catch(JajaCodeInstructionException e){
					System.err.println(e.toString());
				}
			}
			
		}else{
			System.err.println("USAGE : fichierJajaCode [-p (pas à pas)]");
		}
	    
	}
}
