/** La classe ListeDoublementOrdonnee permet de modliser graphiquement 
 * une liste doublement ordonne en utilisant Swing.
 *  
 * @author Eric Beuque et Stphane Chenevoy
 *
 */
public class ListeDoublementOrdonnee extends ListeDoublementChainee implements Ordonnee{
	/** Construit une liste doublement ordonne vide au point de coordonne (0,0).
	 */
	public ListeDoublementOrdonnee(){
		super();
	}
	public void ajouterMaillon(Maillon m){
		MaillonDouble tmp=new MaillonDouble(m.getInfo());
		if(this.getTete()==null){
			this.setTete(tmp);			
		}else{
			this.setTete(this.placeMaillon(this.getTete(),tmp));
		}
		this.recalcCentreMaillon();
		
	}
	public Maillon placeMaillon(Maillon listMaillon, Maillon m){
		
		if(listMaillon==null){
			return m;
		}else{
			if(m.compareTo(listMaillon)<0){
				((MaillonDouble)m).setPrecedent(((MaillonDouble)listMaillon).getPrecedent());
				m.setSuivant(listMaillon);
				((MaillonDouble)listMaillon).setPrecedent(m);
				return m;
			}else{
				((MaillonDouble)m).setPrecedent(listMaillon);
				listMaillon.setSuivant(this.placeMaillon(listMaillon.getSuivant(),m));
				return listMaillon;
			}
		}
	}
	public void fusionner(Liste l) throws FusionListeError{
		Maillon tmp;
		if(l.getClass().getName()!="ListeDoublementOrdonnee"){
			throw new FusionListeError("Impossible de fusionner une liste ordonne  une liste non ordonne.");
		}
		while(l.getTete()!=null){
			tmp=l.getTete();
			try{
				l.retirerMaillon(l.getTete());
				this.ajouterMaillon(tmp);
			}catch(ListeChaineeCreatorError err){}
		}
	}
}
