import java.awt.Point;

/** La classe ListeDoublementCirculaire permet de modliser graphiquement 
 * une liste doublement circulaire en utilisant Swing.
 *  
 * @author Eric Beuque et Stphane Chenevoy
 *
 */
public class ListeDoublementCirculaire extends ListeDoublementChainee {
	/** Construit une liste doublement circulaire vide au point de coordonne (0,0).
	 */
	public ListeDoublementCirculaire(){
		super();
	}
	public void ajouterMaillon(Maillon m){
		MaillonDouble tmp=new MaillonDouble(m.getInfo());
		if(this.getTete()==null){
			this.setTete(tmp);
			tmp.setSuivant(this.getTete());
			tmp.setPrecedent(this.getTete());
		}else{
			tmp.setPrecedent(this.getLast());
			this.getLast().setSuivant(tmp);
			tmp.setSuivant(this.getTete());
			this.setTete(tmp);
			((MaillonDouble)this.getTete().getSuivant()).setPrecedent(tmp);
		}
		this.recalcCentreMaillon();
	}
	public Maillon getLast(){
		Maillon tmp;
		if(this.getTete()!=null){
			tmp=this.getTete();
			while(tmp.getSuivant()!=this.getTete()){
				tmp=tmp.getSuivant();
			}
			return tmp;
		}
		return null;
	}
	public void retirerMaillon(Maillon m){
		if(this.getTete()!=null){
			if(this.getTete()==m){
				this.retirerMaillon();
			}else{
				if(m==this.getLast()){
					((MaillonDouble)m).getPrecedent().setSuivant((this.getTete()));
					((MaillonDouble)this.getTete()).setPrecedent(((MaillonDouble)m).getPrecedent());
				}else{
					
					((MaillonDouble)m.getSuivant()).setPrecedent(((MaillonDouble)m).getPrecedent());
					((MaillonDouble)m).getPrecedent().setSuivant(((MaillonDouble)m).getSuivant());
				}
			}
		}
		this.recalcCentreMaillon();
	}
	public void retirerMaillon(){
		MaillonDouble m =((MaillonDouble)this.getTete());
		
		if(this.getTete()!=null){
				if(this.getTete().getSuivant()==this.getTete()){
					this.setTete(null);
				}else{
					((MaillonDouble)this.getTete().getSuivant()).setPrecedent(this.getLast());
					this.getLast().setSuivant(this.getTete().getSuivant());
					this.setTete(m.getSuivant());
				}
		}
		this.recalcCentreMaillon();
	}
	public void recalcCentreMaillon(){
		Maillon m;
		if(this.getTete()!=null){
			m=this.getTete();
			m.setCentre(new Point(this.getCentre().x+40,this.getCentre().y+40));
			while(m.getSuivant()!=this.getTete()){
				m.getSuivant().setCentre(new Point(m.getCentre().x+m.largeurMaillon()+40,m.getCentre().y));
				m=m.getSuivant();
			}
		}
	}
	public Maillon renvoiMaillonSousPoint(Point p){
		Maillon m;
		if(this.getTete()!=null){
			if(this.getTete().isPointSurMaillon(p)){
				return this.getTete();
			}
			m=this.getTete().getSuivant();
			while(m!=this.getTete()){
				if(m.isPointSurMaillon(p)){
					return m;
				}
				m=m.getSuivant();
			}
		}
		return null;
	}
}
