import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

/** La classe ListeCirculaire permet de modliser graphiquement 
 * une liste chaine circulaire en utilisant Swing.
 *  
 * @author Eric Beuque et Stphane Chenevoy
 *
 */
public class ListeCirculaire extends ListeChaineeSimple implements Circulaire{
	/** Construit une liste chaine circulaire vide au point de coordonne (0,0).
	 */
	public ListeCirculaire(){
		super();
	}
	public void ajouterMaillon(Maillon m){
		Maillon tmp;
		if(this.getTete()==null){
			this.setTete(m);
			m.setSuivant(this.getTete());
		}else{
			tmp=this.getLast();
			tmp.setSuivant(m);
			m.setSuivant(this.getTete());
			this.setTete(m);
		}
		this.recalcCentreMaillon();
	}
	public void retirerMaillon(Maillon m){
		Maillon tmp;
		if(this.getTete()!=null){
			if(this.getTete()==m){
				if(m==m.getSuivant()){
					this.setTete(null);
				}else{
					this.getLast().setSuivant(m.getSuivant());
					this.setTete(m.getSuivant());
				}
			}else{
				tmp=this.getTete();
				while(tmp.getSuivant()!=m && tmp.getSuivant()!=this.getTete()){
					tmp=tmp.getSuivant();
				}
				tmp.setSuivant(m.getSuivant());
			}
		}
		this.recalcCentreMaillon();
	}
	public void retirerMaillon(){
		Maillon tmp;
		tmp = this.getTete();
		if(this.getTete()!=null){
				if(tmp==tmp.getSuivant()){
					this.setTete(null);
				}else{
					this.getLast().setSuivant(tmp.getSuivant());
					this.setTete(tmp.getSuivant());
				}
		}
		this.recalcCentreMaillon();
	}
	public Maillon getLast(){
		Maillon tmp;
		if(this.getTete()!=null){
			tmp=this.getTete();
			while(tmp.getSuivant()!=this.getTete()){
				tmp=tmp.getSuivant();
			}
			return tmp;
		}
		return null;
	}
	public void recalcCentreMaillon(){
		Maillon m;
		if(this.getTete()!=null){
			m=this.getTete();
			m.setCentre(new Point(this.getCentre().x+40,this.getCentre().y));
			while(m.getSuivant()!=this.getTete()){
				m.getSuivant().setCentre(new Point(m.getCentre().x+m.largeurMaillon()+40,m.getCentre().y));
				m=m.getSuivant();
			}
		}
	}
	public Maillon renvoiMaillonSousPoint(Point p){
		Maillon m;
		if(this.getTete()!=null){
			if(this.getTete().isPointSurMaillon(p)){
				return this.getTete();
			}
			m=this.getTete().getSuivant();
			while(m!=this.getTete()){
				if(m.isPointSurMaillon(p)){
					return m;
				}
				m=m.getSuivant();
			}
		}
		return null;
	}
}
