import java.awt.*;
import java.io.*;

/** La classe Liste permet de modliser graphiquement 
 * une liste en utilisant Swing.
 *  
 * @author Eric Beuque et Stphane Chenevoy
 *
 */
abstract class Liste implements Serializable{
	private Maillon tete;
	private Point centre;
	private boolean etendu;
	private boolean selected;
	/** Construit une liste vide au point de coordonne (0,0).
	 */
	public Liste(){
		tete=null;
		etendu=true;
		centre=new Point(0,0);
		selected=false;
	}
	/** Renvoie la rfrence du maillon de tte de la liste.
	 */
	public Maillon getTete(){
		return tete;
	}
	/** Renvoie le point de coordone de la liste.
	 */
	public Point getCentre(){
		return centre;
	}
	/** Renvoie l'tat d'tirement de la liste.
	 */
	public boolean getEtendu(){
		return etendu;
	}
	/** Renvoie l'tat de slection de la liste.
	 */
	public boolean getSelected(){
		return selected;
	}
	/** Affecte la rfrence du maillon de tete de la liste.
	 */
	public void setTete(Maillon m){
		tete=m;
	}
	/** Affecte le point de coordone de la liste.
	 */
	public void setCentre(Point p){
		centre=p;
		this.recalcCentreMaillon();
	}
	/** Affecte l'tat d'tirement de la liste.
	 */
	public void setEtendu(boolean b){
		etendu=b;
	}
	/** Affecte l'tat de slection de la liste.
	 */
	public void setSelected(boolean b){
		selected=b;
	}
	/** Indique l'tat de slection de la liste.
	 */
	public boolean isSelected(){
		return selected;
	}
	/** Indique l'tat de d'tirement de la liste.
	 */
	public boolean isEtendu(){
		return etendu;
	}
	/** Bascule l'tat d'tirement de la liste.
	 */
	public void basculeEtendu(){
		if(etendu){
			etendu=false;
		}else{
			etendu=true;
		}
	}
	/** Bascule l'tat de slection de la liste.
	 */
	public void basculeSelected(){
		if(selected){
			selected=false;
		}else{
			selected=true;
		}
	}
	/** Indique si un point est inclus dans l'espace de dessin de la tte de la liste.
	 */
	abstract public boolean isPointSurTeteListe(Point p);
	/** Renvoie le maillon de la liste situ sous un point. Si le point n'est sur aucun
	 * maillon alors null est renvoy.
	 */
	public Maillon renvoiMaillonSousPoint(Point p){
		Maillon m;
		m=this.getTete();
		while(m!=null){
			if(m.isPointSurMaillon(p)){
				return m;
			}
			m=m.getSuivant();
		}
		return null;
	}
	/** Ouvre le fichier spcifi et renvoie la liste contenu dedans.
	 */
	public static Liste ouvrir(String cheminFichier){
		
		Liste tmpListe=null;
		try{
			FileInputStream fichier = new FileInputStream(cheminFichier);
			ObjectInputStream fluxListe;
			try{
				fluxListe = new ObjectInputStream(fichier);
				tmpListe=(Liste) fluxListe.readObject();
			}catch(ClassNotFoundException e){}
		}catch(java.io.IOException e){}
		
		return tmpListe;
	
	}
	/** Sauvergarde la liste dans le fichier spcifi.
	 */
	public void sauvegarder(String cheminFichier){
			try{
				FileOutputStream fichier = new FileOutputStream(cheminFichier);
				ObjectOutputStream oos = new ObjectOutputStream(fichier);
				oos.writeObject(this);
				oos.flush();
				oos.close();
			}
			catch(java.io.IOException e) {
				e.printStackTrace();
			}
	}
	/** Ajoute un maillon dans la liste.
	 */
	abstract public void ajouterMaillon(Maillon m);
	/** Retire le maillon spcifi dans la liste.
	 */
	abstract public void retirerMaillon(Maillon m) throws ListeChaineeCreatorError;
	/** Retire un maillon dans la liste.
	 */
	abstract public void retirerMaillon() throws ListeChaineeCreatorError;
	/** Recalcule les coordonnes des maillons de la liste.
	 */
	abstract public void recalcCentreMaillon();
	/** Fusionne la liste  une autre.
	 */
	public void fusionner(Liste l) throws FusionListeError{
		throw new FusionListeError("Impossible de fusionner ces deux listes entre elle.");
	}
	/** Renvoie un rectangle reprsentant la surface occup par la liste.
	 */
	public Rectangle occupeSurface(){
		Rectangle r;
		Maillon tmp;
		if(this.getTete()==null){
			r=new Rectangle(this.getCentre().x-10,this.getCentre().y-10,54,20);
		}else{
			r=new Rectangle(this.getCentre().x-10,this.getCentre().y-10,this.getTete().getCentre().x-this.getCentre().x+10,20);
			r=r.union(this.getTete().occupeSurface());
			tmp=this.getTete().getSuivant();
			while(tmp!=null && tmp!=this.getTete()){
				r=r.union(tmp.occupeSurface());
				tmp=tmp.getSuivant();
			}
		}
		return r;
	}
	/** Dessine la liste dans le contexte graphique spcifi au point de coordonne
	 * de liste.
	 */
	abstract public void paint(Graphics g);
}
