import java.awt.*;
import javax.swing.*;

import java.awt.event.*;



/**
 * Classe gerant l'affichage de lensemble de linterface graphique:
 * -Bouton.
 * -Menu.
 * -Affichage Liste.
 * -Message d'erreur.
 * -etc...
 * @author Chenevoy.S
 * @author Beuque.E 
 */


public class Interface extends JFrame implements WindowListener,ActionListener,MouseListener{

	/*Variables lis aux panels*/
	private JPanel panePrincipal;
	private JPanel paneMenu;
	private JScrollPane paneScrollDessin;
	private JPanel paneStatut;
	
	private JPanel paneChoix;
	private JPanel paneAction;
	private JPanel paneActionHaut;
	private JPanel paneInfoCellule;
	private JPanel paneActionBas;
	private JPanel paneBoutonCreer;
	private JPanel paneCreer;
	
	/*Variables lies au menu du programme*/
	private JMenuBar menuBar;
	private JMenu menuFichier; 
	private JMenu menuAide;
	private JMenuItem menuFichierNouveau;
	private JMenuItem menuFichierOuvrir;
	private JMenuItem menuFichierSauvegarder;
	private JMenuItem menuFichierSauvegarderSous;
	private JMenuItem menuFichierQuitter;
	private JMenuItem menuAideApropos;
	
	/*Variable de selection du type de liste*/
	private ButtonGroup grpListe;
	private JRadioButton btnListeChaineeSimple;
	private JRadioButton btnListeDoublementChainee;
	private JRadioButton btnListeChaineeCirculaire;
	private JRadioButton btnListeDoublementChaineeCirculaire;
	private JRadioButton btnListeOrdonnee;
	private JRadioButton btnListeOrdonneeDoublementChainee;
	private JRadioButton btnFile;
	private JRadioButton btnPile;
	
	/*Bouton de manipulation des listes*/
	private JButton btnAjoutElt;
	private JButton btnRetirerElt;
	private JButton btnFusionner;
	private JButton btnReduireEtendre;
	private JButton btnSauvegarder;
	private JButton btnSupprimer;
	private JButton btnCreer;
	
	private JButton btnAjoutCellVide;
	private JTextArea txtInfoCellule;
	private JButton btnAnnuler;
	
	/*Texte d'indication destin  l'utilisateur*/
	private JLabel lblStatut;
	
	private ListeDeListe tabListe;
	
	private String fichierEnCours;
	private Liste tmpListe;
	
	/*Variable mise a true, lorsque toute modfication de la liste apparait
	  et que le programme n'a pas t enregistr*/
	private boolean isTravailModifier;
	
	
	/* 
	 * mode pour connaitre l'action en cours :
	 * 0 (aucun mode)
	 * 1 (ajout d'une cellule)
	 * 2 (ajout d'une cellule vide)
	 * 3 (ajout d'une cellule existante)
	 * 4 (suppression d'une cellule existante)
	 * 5 (reduire/etendre une liste)
	 * 6 (supprimer une liste)
	 * 7 (fusion d'une liste)
	 * 8 (attente de la deuxieme liste de fusion)
	 * 9 (sauvegarde d'une liste)
	 */
	private int mode;
	private Maillon maillonSelect;
	private Liste listSelect;
	
	/**
	 * Constructeur de la classe Interface{}
	 * @author Chenevoy.S
	 * @author Beuque.E 
	 */
	public Interface(){	
		// Creation de la barre de menu
		menuBar = new JMenuBar();
		menuFichier = new JMenu("Fichier");
		menuFichierNouveau = new JMenuItem("Nouveau fichier de listes");
		menuFichierOuvrir = new JMenuItem("Ouvrir un fichier de listes");
		menuFichierSauvegarder = new JMenuItem("Sauvegarder le fichier de listes");
		menuFichierSauvegarderSous = new JMenuItem("Sauvegarder le fichier de listes sous...");
		menuFichierQuitter = new JMenuItem("Quitter");
		menuAideApropos = new JMenuItem("A propos");
		menuAide = new JMenu("Aide");
		menuFichierQuitter.addActionListener(this);
		menuFichierNouveau.addActionListener(this);
		menuFichierSauvegarder.addActionListener(this);
		menuFichierSauvegarderSous.addActionListener(this);
		menuFichierOuvrir.addActionListener(this);
		menuFichier.add(menuFichierNouveau);
		menuFichier.add(menuFichierOuvrir);
		menuFichier.add(menuFichierSauvegarder);
		menuFichier.add(menuFichierSauvegarderSous);
		menuFichier.addSeparator();
		menuFichier.add(menuFichierQuitter);
		menuAide.add(menuAideApropos);
		menuBar.add(menuFichier);
		menuBar.add(menuAide);
		
		fichierEnCours = null;
		tmpListe = null;
		isTravailModifier = false;
		
		// Creation de la barre de status
		lblStatut = new JLabel("Fichier en cours : (Aucun fichier ouvert)");
		lblStatut.setFont(new Font("TimesRoman",Font.BOLD,10));
		
		// Creation du menu de cot
		paneMenu = new JPanel(new GridLayout(2,0));
		paneChoix = new JPanel(new GridLayout(8,0));
		paneBoutonCreer = new JPanel(new FlowLayout());
		paneActionHaut = new JPanel(new GridLayout(6,0));
		paneActionBas = new JPanel(new GridLayout(3,0));
		paneAction = new JPanel(new BorderLayout());
		paneCreer = new JPanel(new BorderLayout());
		paneChoix.setCursor(new Cursor(Cursor.HAND_CURSOR));
		paneChoix.setBorder(BorderFactory.createTitledBorder("Type de liste"));
		paneActionHaut.setBorder(BorderFactory.createTitledBorder("Actions sur les listes"));
		// Cration des boutons des diffrents types de listes
		grpListe = new ButtonGroup();
		btnListeChaineeSimple = new JRadioButton("Liste chaine simple");
		btnListeDoublementChainee = new JRadioButton("Liste doublement chaine");
		btnListeChaineeCirculaire = new JRadioButton("Liste chaine circulaire");
		btnListeDoublementChaineeCirculaire = new JRadioButton("Liste doublement chaine circulaire");
		btnListeOrdonnee = new JRadioButton("Liste ordonne");
		btnListeOrdonneeDoublementChainee = new JRadioButton("Liste ordonne doublement chaine");
		btnFile = new JRadioButton("File");
		btnPile = new JRadioButton("Pile");
		// Ajout de ces bouton dans un panel
	    grpListe.add(btnListeChaineeSimple);
	    grpListe.add(btnListeDoublementChainee);
	    grpListe.add(btnListeChaineeCirculaire);
	    grpListe.add(btnListeDoublementChaineeCirculaire);
	    grpListe.add(btnListeOrdonnee);
	    grpListe.add(btnListeOrdonneeDoublementChainee);
	    grpListe.add(btnFile);
	    grpListe.add(btnPile);
	    paneChoix.add(btnListeChaineeSimple);
	    paneChoix.add(btnListeDoublementChainee);
	    paneChoix.add(btnListeChaineeCirculaire);
	    paneChoix.add(btnListeDoublementChaineeCirculaire);
	    paneChoix.add(btnListeOrdonnee);
	    paneChoix.add(btnListeOrdonneeDoublementChainee);
	    paneChoix.add(btnFile);
	    paneChoix.add(btnPile);
	    paneChoix.add(btnFile);
	    // Liste chaine simple selectionn par defaut.
	    btnListeChaineeSimple.setSelected(true);
	    // Ajout du bouton "Creer" dans un panel
	    btnCreer = new JButton("Crer");
	    btnCreer.addActionListener(this);
	    paneBoutonCreer.add(btnCreer);
	    // Cration des boutons d'action sur les listes
	    // Partie du haut
	    btnAjoutElt = new JButton("Ajouter lment");	    
	    btnRetirerElt = new JButton("Retirer element");
	    btnFusionner = new JButton("Fusionner 2 listes");
	    btnReduireEtendre = new JButton("Reduire/Etendre liste");
	    btnSauvegarder = new JButton("Sauvegarder liste");
	    btnSupprimer = new JButton("Supprimer liste");
	    btnAjoutElt.addActionListener(this);
	    btnRetirerElt.addActionListener(this);
	    btnReduireEtendre.addActionListener(this);
	    btnFusionner.addActionListener(this);
	    btnSupprimer.addActionListener(this);
	    btnSauvegarder.addActionListener(this);
	    paneActionHaut.add(btnAjoutElt);
	    paneActionHaut.add(btnRetirerElt);
	    paneActionHaut.add(btnFusionner);
	    paneActionHaut.add(btnReduireEtendre);
	    paneActionHaut.add(btnSauvegarder);
	    paneActionHaut.add(btnSupprimer);
	    // Partie du bas
	    btnAjoutCellVide = new JButton("Ajouter une cellule vide");
	    btnAjoutCellVide.addActionListener(this);
	    btnAnnuler = new JButton("Annuler l'action en cours");
	    btnAnnuler.addActionListener(this);
	    paneInfoCellule = new JPanel(new FlowLayout(FlowLayout.LEFT));
	    txtInfoCellule = new JTextArea();
	    txtInfoCellule.setBorder(BorderFactory.createLineBorder(Color.black));
	    txtInfoCellule.setPreferredSize(new Dimension(100,20));
	    paneInfoCellule.add(new JLabel("Infos de la cellule : "));
	    paneInfoCellule.add(txtInfoCellule);
	    paneActionBas.add(btnAjoutCellVide);
	    paneActionBas.add(paneInfoCellule);
	    paneActionBas.add(btnAnnuler);
	    paneAction.add(paneActionHaut,BorderLayout.NORTH);
	    paneAction.add(paneActionBas,BorderLayout.SOUTH);
	    // Constrution du menu
	    paneCreer.add(paneChoix,BorderLayout.NORTH);
	    paneCreer.add(paneBoutonCreer,BorderLayout.SOUTH);
	    paneMenu.add(paneCreer);
		paneMenu.add(paneAction);
		
		// Panel de la zone de dessin
		tabListe = new ListeDeListe();
		tabListe.addMouseListener(this);
		paneScrollDessin = new JScrollPane();
		paneScrollDessin.setViewportView(tabListe);
		
		// Creation des panels		
		panePrincipal = new JPanel(new BorderLayout());
		paneStatut = new JPanel(new FlowLayout(FlowLayout.LEFT));
		paneStatut.setBorder(BorderFactory.createLineBorder(new Color(0,0,0)));
		paneStatut.add(lblStatut);
		panePrincipal.add(paneMenu,BorderLayout.WEST);
		panePrincipal.add(paneScrollDessin,BorderLayout.CENTER);
		panePrincipal.add(paneStatut,BorderLayout.SOUTH);
	    // Creation de la fenetre
		this.setTitle("Liste Chaine Creator");
		this.setSize(900,650);
		this.setLocation(50,50);
		this.setResizable(false);
		this.setJMenuBar(menuBar);
		this.setContentPane(panePrincipal);
		this.addWindowListener(this);
		this.addMouseListener(this);
		this.setVisible(true);
		
		this.modeNormal();
	}	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes.
	 * La barre de statut sera modifi si l'on attend une
	 * action de l'utilisateur.
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeAjout(){
		mode=1;
		btnAjoutElt.setEnabled(false);
		btnRetirerElt.setEnabled(false);
		btnFusionner.setEnabled(false);
		btnReduireEtendre.setEnabled(false);
		btnSauvegarder.setEnabled(false);
		btnSupprimer.setEnabled(false);
		btnAjoutCellVide.setEnabled(true);
		btnAnnuler.setEnabled(true);
		this.textBarreStatut();
	}
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes.
	 * La barre de statut sera modifie si l'on attend une
	 * action de l'utilisateur.
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeRetirer(){
		mode=4;
		btnAjoutElt.setEnabled(false);
		btnRetirerElt.setEnabled(false);
		btnFusionner.setEnabled(false);
		btnReduireEtendre.setEnabled(false);
		btnSauvegarder.setEnabled(false);
		btnSupprimer.setEnabled(false);
		btnAnnuler.setEnabled(true);

		this.textBarreStatut();
	}
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes.
	 * La barre de statut sera modifie si l'on attend une
	 * action de l'utilisateur. 
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeAjoutCelluleVide(){
		mode=2;
		btnAjoutCellVide.setEnabled(false);
		paneInfoCellule.setVisible(true);
		this.textBarreStatut();
	}
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes. 
	 * La barre de statut sera modifie si l'on attend une
	 * action de l'utilisateur. 
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeReduireEtendre(){
		mode=5;
		btnAjoutElt.setEnabled(false);
		btnRetirerElt.setEnabled(false);
		btnFusionner.setEnabled(false);
		btnReduireEtendre.setEnabled(false);
		btnSauvegarder.setEnabled(false);
		btnSupprimer.setEnabled(false);
		btnAnnuler.setEnabled(true);
		this.textBarreStatut();
	}
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes.
	 * La barre de statut sera modifie si l'on attend une
	 * action de l'utilisateur.  
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeSupprimer(){
		mode=6;
		btnAjoutElt.setEnabled(false);
		btnRetirerElt.setEnabled(false);
		btnFusionner.setEnabled(false);
		btnReduireEtendre.setEnabled(false);
		btnSauvegarder.setEnabled(false);
		btnSupprimer.setEnabled(false);
		btnAnnuler.setEnabled(true);
		this.textBarreStatut();
	}
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes. 
	 * La barre de statut sera modifie si l'on attend une
	 * action de l'utilisateur. 
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeFusion(){
		mode=7;
		btnAjoutElt.setEnabled(false);
		btnRetirerElt.setEnabled(false);
		btnFusionner.setEnabled(false);
		btnReduireEtendre.setEnabled(false);
		btnSauvegarder.setEnabled(false);
		btnSupprimer.setEnabled(false);
		btnAnnuler.setEnabled(true);
		this.textBarreStatut();
	}
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes.
	 * La barre de statut sera modifie si l'on attend une
	 * action de l'utilisateur. 
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeAttenteFusion(){
		mode=8;
		btnAjoutElt.setEnabled(false);
		btnRetirerElt.setEnabled(false);
		btnFusionner.setEnabled(false);
		btnReduireEtendre.setEnabled(false);
		btnSauvegarder.setEnabled(false);
		btnSupprimer.setEnabled(false);
		btnAnnuler.setEnabled(true);
		this.textBarreStatut();
	}
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes. 
	 * La barre de statut sera modifie si l'on attend une
	 * action de l'utilisateur. 
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeSauvergarde(){
		mode=9;
		btnAjoutElt.setEnabled(false);
		btnRetirerElt.setEnabled(false);
		btnFusionner.setEnabled(false);
		btnReduireEtendre.setEnabled(false);
		btnSauvegarder.setEnabled(false);
		btnSupprimer.setEnabled(false);
		btnAnnuler.setEnabled(true);
		this.textBarreStatut();
	}	
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes. 
	 * La barre de statut sera modifie si l'on attend une
	 * action de l'utilisateur. 
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeAjoutCelluleExistante(){
		mode=3;
		btnAjoutCellVide.setEnabled(false);
		paneInfoCellule.setVisible(false);
		maillonSelect=tabListe.getMaillonSelected();
		listSelect=tabListe.getListSelected();
		this.textBarreStatut();
	}
	
	/**
	 * Active ou desactive les boutons en fonction de
	 * du mode de manipulation des listes. 
	 * La barre de statut affichera le chemin et 
	 * le nom du fichier en cours d'utilisation
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void modeNormal(){
		mode=0;
		if(tabListe.nbList()>0){
			btnAjoutElt.setEnabled(true);
			btnRetirerElt.setEnabled(true);
			btnFusionner.setEnabled(true);
			btnReduireEtendre.setEnabled(true);
			btnSauvegarder.setEnabled(true);
			btnSupprimer.setEnabled(true);
		}else{
			btnAjoutElt.setEnabled(false);
			btnRetirerElt.setEnabled(false);
			btnFusionner.setEnabled(false);
			btnReduireEtendre.setEnabled(false);
			btnSauvegarder.setEnabled(false);
			btnSupprimer.setEnabled(false);
		}
		btnAnnuler.setEnabled(false);
		btnAjoutCellVide.setEnabled(false);
		paneInfoCellule.setVisible(false);
		txtInfoCellule.setText("");
		maillonSelect=null;
		listSelect=null;
		tabListe.deselectionneList();
		tabListe.deselectionneMaillon();
		this.textBarreStatut();
	}
	
	/**
	 * Modification du texte de la barre de statut en fonction du mode.
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return rien
	 */
	public void textBarreStatut(){
		switch(mode){
		case 0: if(fichierEnCours==null){
				lblStatut.setText("Fichier en cours : (fichier non enregistr)" );
			}else{
				lblStatut.setText("Fichier en cours : "+ fichierEnCours);
			}break;
		case 1: lblStatut.setText("Cliquez sur \"ajouter une cellule vide\" ou sur maillon dans une liste pour dsigner le maillon a ajouter."); break;
		case 2: lblStatut.setText("Tapez les informations de la cellule et cliquez sur la liste dans laquelle vous voulez ajouter le nouveau maillon."); break;
		case 3: lblStatut.setText("Cliquez sur la liste dans laquelle vous voulez dplacer le maillon."); break;
		case 4: lblStatut.setText("Cliquez sur le maillon que vous voulez supprimer."); break;
		case 5: lblStatut.setText("Cliquez sur la liste que vous voulez rduire ou tendre."); break;
		case 6: lblStatut.setText("Slectionner la liste  dtruire."); break;
		case 7: lblStatut.setText("Slectionner la liste qui contiendra les lments fusionns."); break;
		case 8: lblStatut.setText("Slectionner la liste qui contient les lments  fusionner."); break;
		}
	}
	
	/**
	 * L'apparition d'un evenement de type ActionEvent (ici evenement li aux boutons) entraine :
	 * -Des modification sur les listes
	 * ou
	 * -Messages de demande de sauvegarde, de confirmations etc...
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @param event Prend la valeur d'un evenement de type ActionEvent qui survient.
	 * @return rien
	 */
	public void actionPerformed(ActionEvent event){
		
		String tmpFichier=null;
		int retourConfirmeSauvegarde=0;
		int retourConfirmeQuitter=0;
		
		/*Fermeture du programme grace ou bouton quitter
		 * du menu, avec demande de confirmation,
		 * et si besoin, demande de sauvegarde.
		 */
		if(event.getSource()==menuFichierQuitter){
			if(isTravailModifier==true){
        		retourConfirmeSauvegarde = confirmeSauvegarde();
        		if(retourConfirmeSauvegarde==JOptionPane.OK_OPTION){
        			if(fichierEnCours==null){
        				tmpFichier=Interface.choixFichier("Enregistrer");
        			}
        			if(tmpFichier!=null){
        				fichierEnCours = tmpFichier;
        				tabListe.sauvegarder(fichierEnCours);
        				lblStatut.setText("Fichier en cours : " + fichierEnCours);
        				isTravailModifier=false;
        			}
        		}
        	}else{
        		retourConfirmeQuitter = confirmeQuitter();
        	}
            if(retourConfirmeSauvegarde!=JOptionPane.CANCEL_OPTION
            	&&	retourConfirmeQuitter!=JOptionPane.NO_OPTION){ 
            	System.exit(0);
            }
		}
		/*Creation d'une nouvelle liste, dont le type est
		 * choisi grace au selecteur de type de liste.
		 * */
		if(event.getSource()==btnCreer){
			if(btnListeChaineeSimple.isSelected()){
				tabListe.ajouterListe(new ListeChaineeSimple());
				isTravailModifier=true;
			}
			if(btnListeDoublementChainee.isSelected()){
				tabListe.ajouterListe(new ListeDoublementChainee());
				isTravailModifier=true;
			}
			if(btnListeOrdonnee.isSelected()){
				tabListe.ajouterListe(new ListeOrdonnee());
				isTravailModifier=true;
			}
			if(btnListeOrdonneeDoublementChainee.isSelected()){
				tabListe.ajouterListe(new ListeDoublementOrdonnee());
				isTravailModifier=true;
			}
			if(btnPile.isSelected()){
				tabListe.ajouterListe(new Pile());
				isTravailModifier=true;
			}
			if(btnFile.isSelected()){
				tabListe.ajouterListe(new File());
				isTravailModifier=true;
			}
			if(btnListeChaineeCirculaire.isSelected()){
				tabListe.ajouterListe(new ListeCirculaire());
				isTravailModifier=true;
			}
			if(this.btnListeDoublementChaineeCirculaire.isSelected()){
				tabListe.ajouterListe(new ListeDoublementCirculaire());
				isTravailModifier=true;
			}
			this.modeNormal();
		}
		if(event.getSource()==btnAjoutElt){
			this.modeAjout();
		}
		if(event.getSource()==btnRetirerElt){
			this.modeRetirer();
		}
		if(event.getSource()==btnReduireEtendre){
			this.modeReduireEtendre();
		}
		if(event.getSource()==btnAjoutCellVide){
			this.modeAjoutCelluleVide();
		}
		if(event.getSource()==btnFusionner){
			this.modeFusion();
		}
		if(event.getSource()==btnAnnuler){
			this.modeNormal();
		}
		if(event.getSource()==btnSupprimer){
			this.modeSupprimer();
		}
		if(event.getSource()==btnSauvegarder){
			this.modeSauvergarde();
	    }
		/*Sauvegarde avec demande de selection du fichier*/
		if(event.getSource()==menuFichierSauvegarderSous){
             tmpFichier=Interface.choixFichier("Enregistrer");
             if(tmpFichier!=null){
             	fichierEnCours = tmpFichier;
               	tabListe.sauvegarder(fichierEnCours);
               	lblStatut.setText("Fichier en cours : " + fichierEnCours);
               	isTravailModifier=false;
             }
        }
		/*Sauvegarde avec demande de selection du fichier
		 * si celui ci n'avait pas t choisi auparavant.
		 * */
        if(event.getSource()==menuFichierSauvegarder){
        	if(fichierEnCours==null){
            	tmpFichier=Interface.choixFichier("Enregistrer");
            }
            if(tmpFichier!=null){
             	fichierEnCours = tmpFichier;
              	tabListe.sauvegarder(fichierEnCours);
              	lblStatut.setText("Fichier en cours : " + fichierEnCours);
              	isTravailModifier=false;
           	}
        }
        /*Ouverture d'un fichier*/
        if(event.getSource()==menuFichierOuvrir){
        	tmpFichier=Interface.choixFichier("Ouvrir");
        	if(tmpFichier!=null){
             	fichierEnCours = tmpFichier;
             	try{
					tabListe=ListeDeListe.ouvrir(fichierEnCours);
					lblStatut.setText("Fichier en cours : " + fichierEnCours);
					isTravailModifier=false;
				}catch(Exception E){}
				try{
					tmpListe=Liste.ouvrir(fichierEnCours);
					tabListe=new ListeDeListe();
					tabListe.ajouterListe(tmpListe);
					tabListe.addMouseListener(this);
	            	paneScrollDessin.setViewportView(tabListe);
				}catch(Exception E){}
			}		
			tabListe.addMouseListener(this);
			paneScrollDessin.setViewportView(tabListe);
        }
        /*Vide l'espace de travail, et remplace la liste de liste, par une 
         * liste vide.Une demande de sauvegarde apparait si necessaire.
         * */
        if(event.getSource()==menuFichierNouveau){
        	if(isTravailModifier==true){
        		retourConfirmeSauvegarde = confirmeSauvegarde();
        		if(retourConfirmeSauvegarde==JOptionPane.OK_OPTION){
        			if(fichierEnCours==null){
        				tmpFichier=Interface.choixFichier("Enregistrer");
        			}
        			if(tmpFichier!=null){
        				fichierEnCours = tmpFichier;
        				tabListe.sauvegarder(fichierEnCours);
        				lblStatut.setText("Fichier en cours : " + fichierEnCours);
        				isTravailModifier=false;
        			}
        		}
        	}
            if(retourConfirmeSauvegarde!=JOptionPane.CANCEL_OPTION){ 
            	tabListe=new ListeDeListe();
            	tabListe.addMouseListener(this);
            	paneScrollDessin.setViewportView(tabListe);
            	fichierEnCours = "(fichier non enregistr)";
            	lblStatut.setText("Fichier en cours : " + fichierEnCours);
            	isTravailModifier=false;
            	fichierEnCours=null;
            }
        }
	}

	/**
	 * L'apparition d'un evenement de type MouseEvent (evenement li au clique souris) entraine :
	 * -Des modification sur les listes,ou selection de listes/maillon...
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @param e Prend la valeur d'un evenement de type MouseEvent qui survient.
	 * @return rien
	 */
	public void mouseClicked(MouseEvent e){
		if(e.getSource()==tabListe){
			switch(mode){
			case 1: // (ajout d'une cellule)
				if(tabListe.hasMaillonSelected()){
					this.modeAjoutCelluleExistante();
				}else{
					this.modeNormal();
				}
				break;
			case 2: // (ajout d'une cellule vide)
				try{
					tabListe.ajouterMaillonListSelected(new Maillon(new String(txtInfoCellule.getText())));
				}catch(ListeChaineeCreatorError err){
					this.afficheErreur(err.getMessage());
				}
				this.modeNormal();
				break;
			case 3: // (ajout d'une cellule existante)
				try{
					listSelect.retirerMaillon(maillonSelect);
					//maillonSelect.setSuivant(null);
					tabListe.ajouterMaillonListSelected(maillonSelect);
				}catch(ListeChaineeCreatorError err){
					listSelect.ajouterMaillon(maillonSelect);
					this.afficheErreur(err.getMessage());
				}
				this.modeNormal();
				break;
			case 4: // (suppression d'une cellule existante)
				try{
					tabListe.retirerMaillonSelected();
				}catch(ListeChaineeCreatorError err){
					this.afficheErreur(err.getMessage());
				}
				this.modeNormal();
				break;
			case 5: // (reduire/etendre une liste)
				try{
					tabListe.reduireEtendreListeSelected();
				}catch(ListeChaineeCreatorError err){
					this.afficheErreur(err.getMessage());
				}
				this.modeNormal();
				break;
			case 6: // (supprimer une liste)
				try{
					tabListe.supprimerListeSelected();
				}catch(ListeChaineeCreatorError err){
					this.afficheErreur(err.getMessage());
				}
				this.modeNormal();
				break;
			case 7: // (fusion d'une liste)
				if(tabListe.hasListSelected()){
					listSelect=tabListe.getListSelected();
				}
				this.modeAttenteFusion();
				break;
			case 8: // (attente de la deuxieme de fusion)
				if(tabListe.hasListSelected()){
					try{
						listSelect.fusionner(tabListe.getListSelected());
					}catch(FusionListeError err){
						this.afficheErreur(err.getMessage());
					}
				}
				this.modeNormal();
				break;
			case 9: // (mode sauvergarde)
				try{
					tabListe.sauvegarderListeSelected();
				}catch(ListeChaineeCreatorError err){
					this.afficheErreur(err.getMessage());
				}
				this.modeNormal();
				break;
			}
		}
	}
	
	/**
	 * Ouverture d'une fenetre de confirmation de sauvegarde.
	 * On renverra la valeur du bouton cliqu.
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return entier
	 */
	public static int confirmeSauvegarde(){
		
		JPanel fenetre = new JPanel();
		int retour;
		
		retour = JOptionPane.showConfirmDialog(
			    fenetre,
			    "Voulez vous sauvegardez votre travail?",
			    "Confirmez",
			    JOptionPane.YES_NO_CANCEL_OPTION);
		System.out.println(retour);
		return retour;
	}
	
	/**
	 * Ouverture d'une fenetre de confirmation de fermeture du programme.
	 * On renverra la valeur du bouton cliqu.
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @return entier
	 */
	public static int confirmeQuitter(){
		
		JPanel fenetre = new JPanel();
		int retour;
		
		retour = JOptionPane.showConfirmDialog(
			    fenetre,
			    "Voulez vous quitter?",
			    "Confirmez",
			    JOptionPane.YES_NO_OPTION);
		System.out.println(retour);
		return retour;
	}
	
	/**
	 * Ouverture d'une fenetre de confirmation de sauvegarde.
	 * On renvera un string contenant le chemin+nom du fichier.
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @param typeChoix Texte du bouton "d'approbation" de la fenetre
	 * @return entier
	 */
	public static String choixFichier(String typeChoix){		
		
		int retourFichier;

		JFileChooser selectFichier = new JFileChooser();
		String cheminFichierSauvegarde=null;
		String extension="lst";
		ExampleFileFilter filtre = new ExampleFileFilter(extension,"Fichier liste");
	
		selectFichier.setFileFilter(filtre);
		selectFichier.setApproveButtonText(typeChoix);
		retourFichier = selectFichier.showOpenDialog(null);
		if(retourFichier == JFileChooser.APPROVE_OPTION) {
          	if(selectFichier.getSelectedFile().exists()){
          		cheminFichierSauvegarde = selectFichier.getSelectedFile().getAbsolutePath();
          	}else{
          		cheminFichierSauvegarde = selectFichier.getSelectedFile().getAbsolutePath() 
						+ "." + extension;
          	}
   		}
   		System.out.println("Chemin fichier sauvegarde"+cheminFichierSauvegarde);
   		return cheminFichierSauvegarde;
   		
   	}
	/**
	 * Affichage d'un message d'erreur dans un nouvelle petite fenetre
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @param chaine Texte du message a afficher
	 * @return rien
	 */
	public void afficheErreur(String chaine){
		JOptionPane.showMessageDialog(this,chaine,this.getTitle(),JOptionPane.ERROR_MESSAGE);
	}
    public void mousePressed(MouseEvent e){ }
    public void mouseReleased(MouseEvent e){ }
    public void mouseEntered(MouseEvent e){ }
    public void mouseExited(MouseEvent e){ }
	/* Mthodes implmente dans l'interface WindowListener */
	public void windowClosing(WindowEvent e){}
	/**
	 * L'apparition d'un evenement de type WindowsEvent (evenement li a la manipulation de la fenetre) entraine :
	 * -La sauvegarde des listes si necessaire.
	 * -Confirmation de fermeture du programme
	 * @author Chenevoy.S
	 * @author Beuque.E
	 * @param e Prend la valeur d'un evenement de type WindowsEvent qui survient.
	 * @return rien
	 */
	protected void processWindowEvent(WindowEvent e){
		String tmpFichier=null;
		int retourConfirmeSauvegarde=0;
		int retourConfirmeQuitter=0;
		if (e.getID() == WindowEvent.WINDOW_CLOSING){
      		if(isTravailModifier==true){
        		retourConfirmeSauvegarde = confirmeSauvegarde();
        		if(retourConfirmeSauvegarde==JOptionPane.OK_OPTION){
        			if(fichierEnCours==null){
        				tmpFichier=Interface.choixFichier("Enregistrer");
        			}
        			if(tmpFichier!=null){
        				fichierEnCours = tmpFichier;
        				tabListe.sauvegarder(fichierEnCours);
        				lblStatut.setText("Fichier en cours : " + fichierEnCours);
        				isTravailModifier=false;
        			}
        		}
        	}else{
        		retourConfirmeQuitter = confirmeQuitter();
        	}
            if(retourConfirmeSauvegarde!=JOptionPane.CANCEL_OPTION
            	&&	retourConfirmeQuitter!=JOptionPane.NO_OPTION){ 
            	System.exit(0);
            }              
		}
	}
	public void windowOpened(WindowEvent e){ }
	public void windowIconified(WindowEvent e){ }
	public void windowDeiconified(WindowEvent e){ }
	public void windowClosed(WindowEvent e){}
	public void windowActivated(WindowEvent e){ }
	public void windowDeactivated(WindowEvent e){ }
}
