// Maillon.cpp: implementation of the Maillon class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Maillon.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Maillon::Maillon(const InfoTour& inf)
{
	info=inf;
	next=NULL;
}

Maillon::Maillon(const InfoTour& inf, Maillon* m)
{
	info=inf;
	next=m;
}

Maillon::~Maillon()
{
	delete next;

}

InfoTour& Maillon::getInfo()
{
	return this->info;
}

Maillon* Maillon::getNext()
{
	return this->next;
}

void Maillon::setInfo(const InfoTour& inf)
{
	this->info=inf;
}

void Maillon::setNext(const Maillon* m)
{
	this->next=m->next;
}

void Maillon::operator = (const Maillon* m)
{
	info=m->info;
	next=m->next;
}

ostream& operator << (ostream& out, const Maillon* m)
{
	if(m->next!=NULL){
		out << m->next;
	}
	out << m->info << endl;
	return out;
}