// Etoile.cpp: implementation of the Etoile class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Etoile.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Etoile::Etoile()
{
	m_tailleTriangle=4;
	m_nbJoueur=2;
}

Etoile::Etoile(int tailleTriangle, int nbJoueur)
{
	m_tailleTriangle=tailleTriangle;
	if(nbJoueur>=2 && nbJoueur<=6){
		m_nbJoueur=nbJoueur;
	}else{
		m_nbJoueur=2;
	}
}

Etoile::~Etoile()
{
	Pion*** m_tabPion;
	Joueur** m_tabJoueur;
	int m_nbJoueur;
	int i,j;
	if(m_tabPion!=NULL){
		for(i=0;i<getHauteurEtoile();i++){
			if(m_tabPion[i]!=NULL){
				for(j=0;j<getNbCaseLigne(i);j++){
					if(m_tabPion[i][j]!=NULL){
						delete m_tabPion[i][j];
					}
				}
			}
			delete[] m_tabPion[i];
		}
	}
	delete[] m_tabPion;

	if(m_tabJoueur!=NULL){
		for(i=0;i<m_nbJoueur;i++){
			if(m_tabJoueur[i]!=NULL){
				delete[] m_tabPion[i];
			}
		}
	}
	delete[] m_tabPion;

}

//////////////////////////////////////////////////////////////////////
// Mthodes GET
//////////////////////////////////////////////////////////////////////

int Etoile::getTailleTriangle() const
{
	return m_tailleTriangle;
}

int Etoile::getLargeurEtoile() const
{
	return 6*m_tailleTriangle+1;
}

int Etoile::getHauteurEtoile() const
{
	return 4*m_tailleTriangle+1;
}


int Etoile::getNbCaseLigne(int index) const
{
	// L'etoile est dcompos en 4
	// Le triangle du haut
	if(index>=0 && index<m_tailleTriangle){
		return index+1;
	}
	// La premiere moiti, en dessous du triangle du haut
	if(index>=m_tailleTriangle && index<2*m_tailleTriangle){
		return 3*m_tailleTriangle+1-index+m_tailleTriangle;
	}
	// La deuxieme moiti, au dessus du triangle du bas
	if(index>=2*m_tailleTriangle && index<=3*m_tailleTriangle){
		return 2*m_tailleTriangle+1+index-2*m_tailleTriangle;
	}
	// Le triangle du bas
	if(index>3*m_tailleTriangle && index<=4*m_tailleTriangle){
		return m_tailleTriangle-index+3*m_tailleTriangle+1;
	}
	return 0;
}

int Etoile::getNbJoueur() const
{
	return m_nbJoueur;
}

int Etoile::getNoTriangle(int noJoueur) const
{
	// Le numro de triangle de dpart est fonction
	// du numro du joueur et du nombre de joueur
	if(noJoueur==1){
		return 1;
	}
	if(noJoueur==2){
		if(m_nbJoueur!=3){
			return 4;
		}else{
			return 3;
		}
	}
	if(noJoueur==3){
		if(m_nbJoueur!=3){
			return 2;
		}else{
			return 5;
		}
	}
	if(noJoueur==4){
		return 5;
	}
	if(noJoueur==5){
		return 3;
	}
	if(noJoueur==6){
		return 6;
	}
	return -1;
}

int Etoile::getNoTriangleFin(int noJoueur) const
{
	// Le numro de triangle de d'arriv est fonction
	// du numro du joueur et du nombre de joueur
	if(noJoueur==1){
		return 4;
	}
	if(noJoueur==2){
		if(m_nbJoueur!=3){
			return 1;
		}else{
			return 6;
		}
	}
	if(noJoueur==3){
		if(m_nbJoueur!=3){
			return 5;
		}else{
			return 2;
		}
	}
	if(noJoueur==4){
		return 2;
	}
	if(noJoueur==5){
		return 6;
	}
	if(noJoueur==6){
		return 3;
	}
	return -1;
}

//////////////////////////////////////////////////////////////////////
// Mthodes sur l'objet
//////////////////////////////////////////////////////////////////////

bool Etoile::coordValide(int ligne, int colonne) const
{
	bool valide=false;
	int nbCase=getNbCaseLigne(ligne);
	int larg=getLargeurEtoile();

	int debut, fin;
	debut=(larg/2)-nbCase+1;
	fin=(larg/2)+nbCase-1;
	int i=debut;
	while(i<=fin){
		if(i==colonne){
			valide=true;
		}
		i=i+2;
	}

	return valide;
}

bool Etoile::indiceDansTriangle(int indiceLigne, int indiceColonne, int noTriangle) const
{
	// On determine en fonction du numro de triangle
	int limite;
	if(noTriangle==1){
		if(indiceLigne<m_tailleTriangle){
			return true;
		}else{
			return false;
		}
	}
	if(noTriangle==2){
		if(indiceLigne>=m_tailleTriangle && indiceLigne<2*m_tailleTriangle){
			limite=getNbCaseLigne(indiceLigne)-m_tailleTriangle+indiceLigne-m_tailleTriangle;
			if(indiceColonne>=limite){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}
	if(noTriangle==3){
		if(indiceLigne>2*m_tailleTriangle && indiceLigne<=3*m_tailleTriangle){
			limite=getNbCaseLigne(indiceLigne)-m_tailleTriangle-indiceLigne+3*m_tailleTriangle;
			if(indiceColonne>=limite){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}
	if(noTriangle==4){
		if(indiceLigne>3*m_tailleTriangle){
			return true;
		}else{
			return false;
		}
	}
	if(noTriangle==5){
		if(indiceLigne>2*m_tailleTriangle && indiceLigne<=3*m_tailleTriangle){
			limite=m_tailleTriangle+indiceLigne-3*m_tailleTriangle;
			if(indiceColonne<limite){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}
	if(noTriangle==6){
		if(indiceLigne>=m_tailleTriangle && indiceLigne<2*m_tailleTriangle){
			limite=m_tailleTriangle-indiceLigne+m_tailleTriangle;
			if(indiceColonne<limite){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	return false;
}

int Etoile::coor2Indice(int ligne, int colonne) const
{
	bool trouve=false;
	int retour=-1;
	int nbCase=getNbCaseLigne(ligne);
	int larg=getLargeurEtoile();

	int debut, fin;
	debut=(larg/2)-nbCase+1;
	fin=(larg/2)+nbCase-1;
	int i=debut;
	while(i<=fin && trouve==false){
		if(i==colonne){
			trouve=true;
		}
		retour++;
		i=i+2;
	}

	return retour;
}

int Etoile::indice2Coord(int indiceLigne, int indiceColonne) const
{
	bool trouve=false;
	int retour=-1;

	int nbCase=getNbCaseLigne(indiceLigne);
	int larg=getLargeurEtoile();
	int debut, fin;
	
	if(indiceColonne>nbCase){
		return retour;
	}

	retour=0;

	debut=(larg/2)-nbCase+1;
	fin=(larg/2)+nbCase-1;

	int i=debut;
	int iter=0;
	while(i<=fin && trouve==false){
		if(iter==indiceColonne){
			trouve=true;
			retour=i;
		}
		iter++;
		i=i+2;
	}

	return retour;
}


void Etoile::menuPrincipal()
{
	// On demande a l'utilisateur de creer une partie, charger une partie ou quitter
	system("cls");
	cout << "******************************************" << endl;
	cout << "**                                      **" << endl;
	cout << "**    Bienvenue dans Dames Chinoises    **" << endl;
	cout << "**                                      **" << endl;
	cout << "******************************************" << endl;
	cout << "**                                      **" << endl;
	cout << "**                                      **" << endl;
	cout << "**  1 - Nouvelle partie                 **" << endl;
	cout << "**  2 - Charger partie                  **" << endl;
	cout << "**  3 - Quitter                         **" << endl;
	cout << "**                                      **" << endl;
	cout << "**                                      **" << endl;
	cout << "******************************************" << endl;
	cout << endl;
	
	int choix;
	do{
		cout << "  Veuillez entrer votre choix : ";
		cin >> choix;
	}while(choix < 1 || choix > 3);

	switch(choix){
	case 1: this->menuNouvellePartie(); break;
	case 2: this->menuChargerPartie(); break;
	case 3: exit(0);
	}


}

void Etoile::menuNouvellePartie()
{
	// On demande a l'utilisateur d'indiquer le nombre de joueur
	system("cls");
	cout << "******************************************" << endl;
	cout << "**                                      **" << endl;
	cout << "**           Nouvelle partie            **" << endl;
	cout << "**                                      **" << endl;
	cout << "******************************************" << endl;
	cout << "**                                      **" << endl;
	cout << "**  Nombre de joueur : 2, 3, 4 ou 6     **" << endl;
	cout << "**                                      **" << endl;
	cout << "******************************************" << endl;
	cout << endl;

	int choix;
	do{
		cout << "  Veuillez entrer votre choix : ";
		cin >> choix;
	}while(choix < 2 || choix > 6 || choix==5);
	m_nbJoueur=choix;

	// On demande a l'utilisateur de choisir la taille des branches
	system("cls");
	cout << "******************************************" << endl;
	cout << "**                                      **" << endl;
	cout << "**           Nouvelle partie            **" << endl;
	cout << "**                                      **" << endl;
	cout << "******************************************" << endl;
	cout << "**                                      **" << endl;
	cout << "**  Taile des branches : 3 a 10         **" << endl;
	cout << "**                                      **" << endl;
	cout << "******************************************" << endl;
	cout << endl;

	do{
		cout << "  Veuillez entrer votre choix : ";
		cin >> choix;
	}while(choix < 3 || choix > 10);
	m_tailleTriangle=choix;

	// On initialise le tableau de choisir
	this->initialiseJoueurs();
	// On demande la configuation de chaque joueurs
	this->initialiseIA();
	// On initialise l'toile
	this->initialiseEtoile();

	// On fait jouer tour a tour les joueurs tant qu'il n'y a pa de gagnant
	int joueur=1;
	while(!this->lanceTour(joueur)){
		if(joueur==m_nbJoueur){
			joueur=1;
		}else{
			joueur++;
		}
	}

	cout << *this;
	cout << "YOU WIIINNNNNNNNNNN !!!! " << endl;
	cout << "Le joueur " << joueur << "gagne la partie !" << endl;
	system("pause");
	// S'il y a un gagnant on le ramene au menu principale
	this->menuPrincipal();
}

void Etoile::menuChargerPartie()
{
	ifstream fichier;
	
	// Cumulation des modes d'ouverture via l'oprateur binaire "ou"
	fichier.open("partie.txt", ios::in);
	
	if (fichier.bad())
		exit(1);   // Erreur a l'ouverture, on quitte...
	
	// Lit le nombre de joueur
	fichier >> this->m_nbJoueur;
	this->initialiseJoueurs();
	
	int numLu;
	char carLu;

	// Charge les joueurs
	for(int i=0;i<this->m_nbJoueur;i++){
		fichier >> numLu;
		fichier >> numLu;
		this->m_tabJoueur[i]->setNivIA(numLu);
	}
	// Lit la taille des branches
	fichier >> this->m_tailleTriangle;
	this->initialiseEtoile();
	// Initialise l'toile
	for(i=0;i<this->getHauteurEtoile();i++){
		for(int j=0;j<this->getNbCaseLigne(i);j++){
			fichier >> numLu;
			fichier >> numLu;
			fichier >> carLu;
			
			delete m_tabPion[i][j];
			if(carLu=='.'){
				m_tabPion[i][j]=NULL;
			}else{
				m_tabPion[i][j]=new Pion(carLu);
			}
		}
	}
	// Charge l'historique des tours
	int noJoueur=0, ligS, colS, ligD, colD;

	while(!fichier.eof()){
		fichier >> noJoueur;
		fichier >> ligS;
		fichier >> colS;
		fichier >> ligD;
		fichier >> colD;

		if(!fichier.eof()){
			this->ajouteHisto(InfoTour(noJoueur,ligS,colS,ligD,colD));
		}
	};

    // Fermeture du fichier
	fichier.close();

	// Lance la partie
	if(noJoueur==m_nbJoueur){
		noJoueur=1;
	}else{
		noJoueur++;
	}
	while(!this->lanceTour(noJoueur)){
		if(noJoueur==m_nbJoueur){
			noJoueur=1;
		}else{
			noJoueur++;
		}
	}

	cout << *this;
	cout << "YOU WIIINNNNNNNNNNN !!!! " << endl;
	cout << "Le joueur " << noJoueur << "gagne la partie !" << endl;
	system("pause");
	// S'il y a un gagnant on le ramene au menu principale
	this->menuPrincipal();

}


void Etoile::initialiseJoueurs()
{
	int i;
	
	// On alloue une case pour chaque joueurs et 
	// on calcule son triangle de dpart et celui d'arriver
	m_tabJoueur=new Joueur*[m_nbJoueur];
	for(i=0;i<m_nbJoueur;i++){
		m_tabJoueur[i]=new Joueur(i+1,0);
		m_tabJoueur[i][0].setNoTriangle(this->getNoTriangle(i+1));
		m_tabJoueur[i][0].setNoTriangleFin(this->getNoTriangleFin(i+1));
	}
}

void Etoile::initialiseIA()
{
	int i;
	// Pour chaque joueur, on demande sont niveau d'IA
	for(i=0;i<m_nbJoueur;i++){
		system("cls");
		cout << "******************************************" << endl;
		cout << "**                                      **" << endl;
		cout << "**   Configuration du joueur " << i+1 << "          **" << endl;
		cout << "**                                      **" << endl;
		cout << "******************************************" << endl;
		cout << "**                                      **" << endl;
		cout << "**  Controle du joueur                  **" << endl;
		cout << "**  1 - Humain                          **" << endl;
		cout << "**  2 - Ordinateur (Facile)             **" << endl;
		cout << "**                                      **" << endl;
		cout << "******************************************" << endl;
		cout << endl;
		
		int choix;
		do{
			cout << "  Veuillez entrer votre choix : ";
			cin >> choix;
		}while(choix < 1 || choix > 2);
		m_tabJoueur[i][0].setNivIA(choix-1);
	}
}

void Etoile::initialiseEtoile()
{
	int larg,haut,i,j,k;
	// On creer le nombre de ligne en fonction de l'hauteur du triangle
	haut=getHauteurEtoile();
	m_tabPion=new Pion**[haut];
	for(i=0;i<haut;i++){
		// On creer le nombre de colonne en fonction du nombre de case de chaque ligne
		larg=getNbCaseLigne(i);
		m_tabPion[i]=new Pion*[larg];
		for(j=0;j<larg;j++){
			m_tabPion[i][j]=NULL;
			// Pour chaque joueur, on place ses pion dans son triangle de dpart
			for(k=0;k<m_nbJoueur;k++){
				if(indiceDansTriangle(i,j,m_tabJoueur[k][0].getNoTriangle())){
					m_tabPion[i][j]=new Pion(m_tabJoueur[k][0].getTypePion());
				}
			}
		}
	}
}

bool Etoile::lanceTour(int noJoueur)
{
	
	switch(m_tabJoueur[noJoueur-1]->getNivIA()){
	case 0:
		// Si le joueur est un humain, on demande choisir l'action qui veut faire
		system("cls");
		cout << *this;
		cout << endl;
		cout << "Joueur " << noJoueur << " -> Pion " << m_tabJoueur[noJoueur-1]->getTypePion() << endl;
		cout << "1 - Jouer" << endl;
		cout << "2 - Sauvegarder" << endl;
		cout << "3 - Abandonner" << endl;
		if(!histo.pileVide()){
			cout << "4 - Annuler le coup precedent" << endl;
		}
		cout << endl;

		int choix;
		do{
			cout << "  Veuillez entrer votre choix : ";
			cin >> choix;
		}while(choix < 1 || choix > 4 || (histo.pileVide() && choix==4));

		switch(choix){
		case 1:
			// S'il veut jouer
			system("cls");
			cout << *this << endl;
			// On le fait jouer
			this->jouer(noJoueur);
			// On regarde s'il a gagn
			return this->isGagnant(noJoueur);
			break;
		case 2:
			// On sauvegarde, puis on le jouer
			this->menuSauvegarder();
			return this->lanceTour(noJoueur);
			break;
		case 3:
			// On lui demande une confirmation avant d'abandonner
			char abandon;
			cout << endl;
			cout << "Etes vous sur de vouloir abandonner ? (O/N)";
			cin >> abandon;
			cout << endl;
			// S'il abandonne
			if(abandon=='O' || abandon=='o'){
				// Retour au menu principal
				cout << "Le joueur " << noJoueur << " a abandonne, fin de la partie ! " << endl;
				system("pause");
				this->menuPrincipal();
				exit(0);
			}else{
				// Sinon on le fait jouer
				return this->lanceTour(noJoueur);
			}
		case 4:
			// S'il veut annuler le coup prcedent
			try{
				// On recupere le dernier coup jou dans la pile
				InfoTour& dernierCoup=histo.depile();
				// On annule le deplacement
				this->deplace(dernierCoup.getLigD(),dernierCoup.getColD(),dernierCoup.getLigS(),dernierCoup.getColS());
				// On fait jouer le joueur prcedent
				return this->lanceTour(dernierCoup.getNoJoueur());
			}catch(PileVideException &pve){
				cout << "=> Pas de coup precedent !!" << endl;
			}
			return false;
			break;
		}
	case 1:
		// Si le joueur est une IA de niveau 1
		this->deplaceIA(noJoueur);
		return this->isGagnant(noJoueur);
		break;
	}

	return false;

}

void Etoile::jouer(int noJoueur)
{
	cout << "Joueur " << noJoueur << " -> Pion " << m_tabJoueur[noJoueur-1]->getTypePion() << endl;

	int ligS, colS, ligD, colD;
	// On lui demande de saisir un point de dpart et d'arriv
	this->getPointDepart(noJoueur,ligS,colS);
	this->getPointArrive(noJoueur,ligD,colD);

	// Si le deplacement est un deplacement simple valide
	if(isDeplacementSimple(ligS,colS,ligD,colD)){
		// On depalce le pion et on ajoute le deplacement dans l'historique
		this->deplace(ligS,colS,ligD,colD);
		this->ajouteHisto(InfoTour(noJoueur,ligS,colS,ligD,colD));
	}else{
		// Si le deplacement est un deplacement saut valide
		if(isDeplacementSaut(ligS,colS,ligD,colD)){
			// On deplace le pion, et si le joueur n'a pas gagn on lui propose de rejouer
			this->deplace(ligS,colS,ligD,colD);
			if(!isGagnant(noJoueur)){
				system("cls");
				char rejoue;
				cout << *this << endl;
				cout << "Vous avez effectue un saut ! Voulez vous rejouer ? (O/N)";
				cin >> rejoue;
				cout << endl;
				if(rejoue=='O' || rejoue=='o'){
					this->rejouer(noJoueur,ligD,colD);
				}
			}
			// On ajoute le deplacement total dans l'historique
			this->ajouteHisto(InfoTour(noJoueur,ligS,colS,ligD,colD));
		}else{
			// Si le deplacement n'est pas valide, on lui demande de rejouer
			cout << endl;
			cout << "=> Vous ne pouvez pas allez sur cette case !" << endl;
			this->jouer(noJoueur);
		}
	}
	
}

void Etoile::rejouer(int noJoueur, int &ligS, int &colS)
{
	cout << "Joueur " << noJoueur << " -> Pion " << m_tabJoueur[noJoueur-1]->getTypePion() << endl;
	cout << "Vous deplacer le pion [" << ligS << "," << colS << "]" << endl;

	int ligD, colD;
	// Il est oblig de jouer le meme pion, donc lui demande que le point d'arriv
	this->getPointArrive(noJoueur,ligD,colD);

	// Il doit obligatoirement effectuer un nouveau saut
	if(isDeplacementSaut(ligS,colS,ligD,colD)){
		// On deplace le pion, et si le joueur n'a pas gagn on lui propose de rejouer
		deplace(ligS,colS,ligD,colD);
		if(!isGagnant(noJoueur)){
			char rejoue;
			system("cls");
			cout << *this << endl;
			cout << "Vous avez effectue un saut ! Voulez vous rejouer ? (O/N)";
			cin >> rejoue;
			cout << endl;
			if(rejoue=='O' || rejoue=='o'){
				this->rejouer(noJoueur,ligD,colD);
			}
			ligS=ligD;
			colS=colD;
		}
	}else{
		cout << "=> Vous devez effectuer a nouveau un saut !" << endl;
		rejouer(noJoueur, ligS, colS);
	}
}

bool Etoile::isGagnant(int noJoueur) const
{
	int i,j;
	for(i=0;i<getHauteurEtoile();i++){
		for(j=0;j<getNbCaseLigne(i);j++){
			if(isPionJoueur(noJoueur,i,indice2Coord(i,j))==1 && !indiceDansTriangle(i,j,m_tabJoueur[noJoueur-1][0].getNoTriangleFin())){
				return false;
			}
		}
	}

	return true;
}

void Etoile::deplace(int ligS, int colS, int ligD, int colD)
{
	Pion* tmp;
	int colonneIndiceS=coor2Indice(ligS,colS);
	int colonneIndiceD=coor2Indice(ligD,colD);
	if(m_tabPion[ligS][colonneIndiceS]!=NULL){
		if(m_tabPion[ligD][colonneIndiceD]==NULL){
			tmp=m_tabPion[ligS][colonneIndiceS];
			m_tabPion[ligS][colonneIndiceS]=NULL;
			m_tabPion[ligD][colonneIndiceD]=tmp;
		}
	}
}

int Etoile::isPionJoueur(int noJoueur, int lig, int col) const
{
	int indiceColonne=coor2Indice(lig,col);
	if(m_tabPion[lig][indiceColonne]!=NULL){
		if(m_tabPion[lig][indiceColonne]->getType()==m_tabJoueur[noJoueur-1][0].getTypePion()){
			return 1;
		}else{
			return 0;
		}
	}else{
		return -1;
	}
}

void Etoile::getPointDepart(int noJoueur, int& lig, int& col) const
{
	bool valide=false;
	// Tant que le point n'est pas valide
	while(!valide){
		while(!valide){
			// Saisie du point
			cout << "- Point de depart :" << endl;
			cout << "   Ligne = ";
			cin >> lig;
			cout << "   Colonne = ";
			cin >> col;
			// On verifie que la coordonne est valide
			valide=coordValide(lig,col);
			if(!valide){
				cout << "=> Coordonee invalide !" << endl;
			}else{
				// On verifie que le pion est deplacable
				valide=this->isDeplacable(lig,col);
				if(!valide){
					cout << "=> Ce pion ne peut pas etre deplace !" << endl;
				}
			}
		}
		// On verifie que le pion appartient bien au joueur
		if(isPionJoueur(noJoueur,lig,col)==1){
			valide=true;
		}else{
			valide=false;
			cout << "=> Il n'y a pas de pion a vous sur cette case!" << endl;
		}
	}

}

void Etoile::getPointArrive(int noJoueur, int& lig, int& col) const
{
	bool valide=false;
	// Tant que le point n'est pas valide
	while(!valide){
		while(!valide){
			// Saisie du point
			cout << "- Point d'arrivee :" << endl;
			cout << "   Ligne = ";
			cin >> lig;
			cout << "   Colonne = ";
			cin >> col;
			// On verifie que la coordonne est valide
			valide=coordValide(lig,col);
			if(!valide){
				cout << "=> Coordonee invalide !" << endl;
			}
		}
		// On verifie que le point ne comporte aucun pion
		if(isPionJoueur(noJoueur,lig,col)==-1){
			valide=true;
		}else{
			valide=false;
			cout << "=> Cette case n'est pas libre !" << endl;
		}
	}
}

bool Etoile::isDeplacementSimple(int ligS, int colS, int ligD, int colD) const
{
	int lig=ligD-ligS;
	int col=colD-colS;

	if((lig==0 && (col==1 || col==-1)) || ((lig==1 || lig==-1) && col==0) 
		|| ((lig==1 || lig==-1) && (col==1 || col==-1))){
		return true;
	}else{
		return false;
	}
}

bool Etoile::isDeplacementSaut(int ligS, int colS, int ligD, int colD) const
{
	int lig=ligD-ligS;
	int col=colD-colS;

	if((lig==0 && col==4) || (lig==0 && col==-4) || (lig==2 && col==2)
		|| (lig==2 && col==-2)  || (lig==-2 && col==2) || (lig==-2 && col==-2) ){
		if(coordValide(ligS+(lig/2),colS+(col/2))){
			if(m_tabPion[ligS+(lig/2)][coor2Indice(ligS+(lig/2),colS+(col/2))]!=NULL){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	return false;
}

void Etoile::ajouteHisto(const InfoTour& inf)
{
	// Empile un InfoTour dans l'historique
	histo.empile(inf);
}

void Etoile::menuSauvegarder() const
{
	ofstream fichier;
	
	// Cumulation des modes d'ouverture via l'oprateur binaire "ou"
	fichier.open("partie.txt", ios::out | ios::trunc);
	
	if (fichier.bad())
		exit(1);   // Erreur a l'ouverture, on quitte...
	
	// On enregistre le nombre de joueurs
	fichier << this->m_nbJoueur << endl;
	// On enregistre chaque joueur
	for(int i=0;i<this->m_nbJoueur;i++){
		fichier << this->m_tabJoueur[i]->getNoJoueur() << '\t' << this->m_tabJoueur[i]->getNivIA() << endl;
	}
	// On enregistre la taille des branches
	fichier << this->m_tailleTriangle << endl;
	// On enregistre le tableau de pion
	for(i=0;i<this->getHauteurEtoile();i++){
		for(int j=0;j<this->getNbCaseLigne(i);j++){
			fichier << i << '\t' << j << '\t';
			if(m_tabPion[i][j]!=NULL){
				fichier << this->m_tabPion[i][j]->getType();
			}else{
				fichier << ".";
			}
			fichier << endl;
		}
	}
	// On enregistre l'historique des tours
	if(!this->histo.pileVide()){
		fichier << this->histo;
	}

    // Fermeture du fichier
	fichier.close();
}

void Etoile::getObjectifPionIA(int noJoueur, int& ligO, int& colO) const
{
	int triangleFin=m_tabJoueur[noJoueur-1]->getNoTriangleFin();
	bool prem=false;

	switch(m_tabJoueur[noJoueur-1]->getNivIA()){
	case 1:

		for(int i=0;i<this->getHauteurEtoile();i++){
			for(int j=0;j<this->getNbCaseLigne(i);j++){
				if(this->m_tabPion[i][j]==NULL){
					int tmpColO=this->indice2Coord(i,j);
					if(!prem){
						ligO=i;
						colO=tmpColO;
						prem=true;
					}else{
						if(this->pointMieuDsTriangle(triangleFin,i,tmpColO,ligO,colO)){
							ligO=i;
							colO=tmpColO;
						}
					}
				}
			}
		}

		break;
	}
}

void Etoile::getSrcPionIA(int noJoueur, int ligO, int colO, int& ligS, int& colS) const
{
	system("cls");
	cout << *this;
	bool trouve=false;
	int numTriangle=m_tabJoueur[noJoueur-1]->getNoTriangle();
	int numTriangleFin=m_tabJoueur[noJoueur-1]->getNoTriangleFin();
	switch(m_tabJoueur[noJoueur-1]->getNivIA()){
	case 1:
		/* On cherche un pion appartenant au joueur et on regarde s'il est pas
			mieux plac que le point d'objectif, si oui, on en choisi un autre,
			sinon on calcule le point dans lequel on veut l'envoy
		*/
		// On parcours le tableau de pion a la recherche du meilleur pion a deplacer
		for(int i=0;i<this->getHauteurEtoile();i++){
			for(int j=0;j<this->getNbCaseLigne(i);j++){
				// La case doit contenir un pion
				if(this->m_tabPion[i][j]!=NULL){
					// La case doit contenir un pion appartenant au joueur
					if(this->m_tabPion[i][j]->getType()==m_tabJoueur[noJoueur-1]->getTypePion()){
						int tmpColS=this->indice2Coord(i,j);
						// Le pion doit pouvoir etre deplac
						if(this->isDeplacable(i,tmpColS)){
							// Pion par defaut
							if(!trouve){
								if(this->indiceDansTriangle(i,j,numTriangleFin)){
									if(!this->pointMieuDsTriangle(numTriangleFin,i,tmpColS,ligO,colO)){
										trouve=true;
										ligS=i;
										colS=tmpColS;
									}
								}else{
									trouve=true;
									ligS=i;
									colS=tmpColS;
								}
							}else{
								srand(time(NULL));
								int rd=rand()%this->m_tailleTriangle;
								if(rd==0){
									if(this->indiceDansTriangle(ligS,this->coor2Indice(ligS,colS),numTriangle)){
										if(this->indiceDansTriangle(i,j,numTriangle)){
											if(!this->pointMieuDsTriangle(numTriangle,i,tmpColS,ligS,colS)){
												ligS=i;
												colS=tmpColS;
											}
										}
									}else{
										// On selectionne le pion le mieu plac pour atteindre triangle
										if(this->pointMieuDsTriangle(numTriangleFin,i,tmpColS,ligS,colS)){
											// Afin de ne pas choisir un pion deja a sa bonne place
											if(this->indiceDansTriangle(i,j,numTriangleFin)){
												if(!this->pointMieuDsTriangle(numTriangleFin,i,tmpColS,ligO,colO)){
													ligS=i;
													colS=tmpColS;
												}
											}else{
												ligS=i;
												colS=tmpColS;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		break;
	}
}

void Etoile::getDestPionIA(int noJoueur, int ligO, int colO, int ligS, int colS, int& ligD, int& colD) const
{

	/* On cherche le deplacement a effectuer en fonction du niveau de l'IA
		et du point d'objectif a atteindre */
	bool trouve=false;
	int numTriangleFin=m_tabJoueur[noJoueur-1]->getNoTriangleFin();
	if(this->isDeplacementSimple(ligS,colS,ligO,colO) || this->isDeplacementSaut(ligS,colS,ligO,colO)){
		ligD=ligO;
		colD=colO;
		trouve=true;
	}
	switch(m_tabJoueur[noJoueur-1]->getNivIA()){
	case 1:
		int tmpLigD, tmpColD;
		for(int i=1;i<6;i++){
			if(!trouve){
				trouve=this->getDestDirection(ligS,colS,ligD,colD,i,true);
				if(!trouve){
					trouve=this->getDestDirection(ligS,colS,ligD,colD,i,false);
				}
			}else{
				if(this->getDestDirection(ligS,colS,tmpLigD,tmpColD,i,true)){
					if(this->pointMieuDsTriangle(numTriangleFin,tmpLigD,tmpColD,ligD,colD)){
						ligD=tmpLigD;
						colD=tmpColD;
					}
				}
				if(this->getDestDirection(ligS,colS,tmpLigD,tmpColD,i,false)){
					if(this->pointMieuDsTriangle(numTriangleFin,tmpLigD,tmpColD,ligD,colD)){
						ligD=tmpLigD;
						colD=tmpColD;
					}
				}
			}
		}
		break;
	}
}

bool Etoile::getDestDirection(int ligS, int colS, int& ligD, int& colD, int direction, bool saut) const
{
	switch(direction){
	case 1:
		if(saut){
			if(this->coordValide(ligS-1,colS+1)){
				if(m_tabPion[ligS-1][this->coor2Indice(ligS-1,colS+1)]==NULL){
					ligD=ligS-1;
					colD=colS+1;
					return true;
				}else{
					return false;
				}
			}
		}else{
			if(this->coordValide(ligS-2,colS+2)){
				if(m_tabPion[ligS-2][this->coor2Indice(ligS-2,colS+2)]==NULL){
					ligD=ligS-2;
					colD=colS+2;
					return true;
				}else{
					return false;
				}
			}
		}
		break;
	case 2:
		if(saut){
			if(this->coordValide(ligS,colS+2)){
				if(m_tabPion[ligS][this->coor2Indice(ligS,colS+2)]==NULL){
					ligD=ligS;
					colD=colS+2;
					return true;
				}else{
					return false;
				}
			}
		}else{
			if(this->coordValide(ligS,colS+4)){
				if(m_tabPion[ligS][this->coor2Indice(ligS,colS+4)]==NULL){
					ligD=ligS;
					colD=colS+4;
					return true;
				}else{
					return false;
				}
			}
		}
		break;
	case 3:
		if(saut){
			if(this->coordValide(ligS+1,colS+1)){
				if(m_tabPion[ligS+1][this->coor2Indice(ligS+1,colS+1)]==NULL){
					ligD=ligS+1;
					colD=colS+1;
					return true;
				}else{
					return false;
				}
			}
		}else{
			if(this->coordValide(ligS+2,colS+2)){
				if(m_tabPion[ligS+2][this->coor2Indice(ligS+2,colS+2)]==NULL){
					ligD=ligS+2;
					colD=colS+2;
					return true;
				}else{
					return false;
				}
			}
		}
		break;
	case 4:
		if(saut){
			if(this->coordValide(ligS+1,colS-1)){
				if(m_tabPion[ligS+1][this->coor2Indice(ligS+1,colS-1)]==NULL){
					ligD=ligS+1;
					colD=colS-1;
					return true;
				}else{
					return false;
				}
			}
		}else{
			if(this->coordValide(ligS+2,colS-2)){
				if(m_tabPion[ligS+2][this->coor2Indice(ligS+2,colS-2)]==NULL){
					ligD=ligS+2;
					colD=colS-2;
					return true;
				}else{
					return false;
				}
			}
		}
		break;
	case 5:
		if(saut){
			if(this->coordValide(ligS,colS-2)){
				if(m_tabPion[ligS][this->coor2Indice(ligS,colS-2)]==NULL){
					ligD=ligS;
					colD=colS-2;
					return true;
				}else{
					return false;
				}
			}
		}else{
			if(this->coordValide(ligS,colS-4)){
				if(m_tabPion[ligS][this->coor2Indice(ligS,colS-4)]==NULL){
					ligD=ligS;
					colD=colS-4;
					return true;
				}else{
					return false;
				}
			}
		}
		break;
	case 6:
		if(saut){
			if(this->coordValide(ligS-1,colS-1)){
				if(m_tabPion[ligS-1][this->coor2Indice(ligS-1,colS-1)]==NULL){
					ligD=ligS-1;
					colD=colS-1;
					return true;
				}else{
					return false;
				}
			}
		}else{
			if(this->coordValide(ligS-2,colS-2)){
				if(m_tabPion[ligS-2][this->coor2Indice(ligS-2,colS-2)]==NULL){
					ligD=ligS-2;
					colD=colS-2;
					return true;
				}else{
					return false;
				}
			}
		}
		break;
	}
	return false;
}

void Etoile::deplaceIA(int noJoueur)
{
	int ligO, colO, ligS, colS, ligD, colD;
	this->getObjectifPionIA(noJoueur, ligO, colO);
	this->getSrcPionIA(noJoueur, ligO, colO, ligS, colS);
	this->getDestPionIA(noJoueur, ligO, colO, ligS, colS, ligD, colD);
	deplace(ligS,colS,ligD,colD);
	this->ajouteHisto(InfoTour(noJoueur,ligS,colS,ligD,colD));
}

bool Etoile::pointMieuDsTriangle(int numTriangle, int lig1, int col1, int lig2, int col2) const
{
	int colIndex = this->coor2Indice(lig1,col1);
	switch(numTriangle){
	case 1: 
		if(lig1<lig2 || (lig1==lig2 && col1<col2)){
			if(!this->indiceDansTriangle(lig1,colIndex,2) && !this->indiceDansTriangle(lig1,colIndex,6)){
				return true;
			}else{		
				return false;
			}
		}else{		
			return false;
		}
		break;
	case 2: 
		if(col1>col2 || (col1==col2 && lig1<lig2)){
			if(!this->indiceDansTriangle(lig1,colIndex,1) && !this->indiceDansTriangle(lig1,colIndex,3)){
				return true;
			}else{		
				return false;
			}
		}else{
			return false;
		}
		break;
	case 3: 
		if(col1>col2 || (col1==col2 && lig1>lig2)){
			if(!this->indiceDansTriangle(lig1,colIndex,2) && !this->indiceDansTriangle(lig1,colIndex,4)){
				return true;
			}else{		
				return false;
			}
		}else{
			return false;
		}
		break;
	case 4: 
		if(lig1>lig2 || (lig1==lig2 && col1>col2)){
			if(!this->indiceDansTriangle(lig1,colIndex,3) && !this->indiceDansTriangle(lig1,colIndex,5)){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
		break;
	case 5: 
		if(col1<col2 || (col1==col2 && lig1>lig2)){
			if(!this->indiceDansTriangle(lig1,colIndex,4) && !this->indiceDansTriangle(lig1,colIndex,6)){
				return true;
			}else{		
				return false;
			}
		}else{
			return false;
		}
		break;
	case 6: 
		if(col1<col2 || (col1==col2 && lig1<lig2)){
			if(!this->indiceDansTriangle(lig1,colIndex,5) && !this->indiceDansTriangle(lig1,colIndex,1)){
				return true;
			}else{		
				return false;
			}
		}else{
			return false;
		}
		break;
	}
	return false;
}

bool Etoile::isDeplacable(int lig, int col) const
{
	// Deplacement vers le haut-gauche
	if(this->coordValide(lig-1,col-1)){
		if(m_tabPion[lig-1][this->coor2Indice(lig-1,col-1)]==NULL){
			return true;
		}else{
			if(this->coordValide(lig-2,col-2)){
				if(m_tabPion[lig-2][this->coor2Indice(lig-2,col-2)]==NULL){
					return true;
				}
			}
		}
	}

	// Deplacement vers le haut-droite
	if(this->coordValide(lig-1,col+1)){
		if(m_tabPion[lig-1][this->coor2Indice(lig-1,col+1)]==NULL){
			return true;
		}else{
			if(this->coordValide(lig-2,col+2)){
				if(m_tabPion[lig-2][this->coor2Indice(lig-2,col+2)]==NULL){
					return true;
				}
			}
		}
	}
	// Deplacement vers la droite
	if(this->coordValide(lig,col+2)){
		if(m_tabPion[lig][this->coor2Indice(lig,col+2)]==NULL){
			return true;
		}else{
			if(this->coordValide(lig,col+4)){
				if(m_tabPion[lig][this->coor2Indice(lig,col+4)]==NULL){
					return true;
				}
			}
		}
	}
	// Deplacement vers le bas-droite
	if(this->coordValide(lig+1,col+1)){
		if(m_tabPion[lig+1][this->coor2Indice(lig+1,col+1)]==NULL){
			return true;
		}else{
			if(this->coordValide(lig+2,col+2)){
				if(m_tabPion[lig+2][this->coor2Indice(lig+2,col+2)]==NULL){
					return true;
				}
			}
		}
	}
	// Deplacement vers le bas-gauche
	if(this->coordValide(lig+1,col-1)){
		if(m_tabPion[lig+1][this->coor2Indice(lig+1,col-1)]==NULL){
			return true;
		}else{
			if(this->coordValide(lig+2,col-2)){
				if(m_tabPion[lig+2][this->coor2Indice(lig+2,col-2)]==NULL){
					return true;
				}
			}
		}
	}
	// Deplacement vers le gauche
	if(this->coordValide(lig,col-2)){
		if(m_tabPion[lig][this->coor2Indice(lig,col-2)]==NULL){
			return true;
		}else{
			if(this->coordValide(lig,col-4)){
				if(m_tabPion[lig][this->coor2Indice(lig,col-4)]==NULL){
					return true;
				}
			}
		}
	}
	return false;
}

//////////////////////////////////////////////////////////////////////
// Oprateurs
//////////////////////////////////////////////////////////////////////

ostream& operator << (ostream& out, const Etoile& e)
{
	int i,j;

	out << ' ' << ' ';
	for(j=0;j<e.getLargeurEtoile();j++){
		if(j<10){
			out << ' ';
		}else{
			int tmp=(j-j%10)/10;
			out << tmp;
		}
	}

	out << endl;
	out << ' ' << ' ';

	for(j=0;j<e.getLargeurEtoile();j++){
		out << j%10;
	}

	out << endl;

	for(i=0;i<e.getHauteurEtoile();i++){
		if(i<10){
			out << ' ';
		}
		out << i;
		for(j=0;j<e.getLargeurEtoile();j++){
			if(e.coordValide(i,j)){
				if(e.m_tabPion[i][e.coor2Indice(i,j)]==NULL){
					out << ".";
				}else{
					out << e.m_tabPion[i][e.coor2Indice(i,j)][0].getType();
				}
			}else{
				out << " ";
			}
		}
		out << endl;
	}
	return out;
}
