package filtre;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

import decoupage.Morceau;

/**
 * Flou - Traitement flou.
 * 
 * @version 1.0 - 31/01/2008
 * @author Beuque & Cornevaux
 */
public class Flou extends Filtre {

	public Flou(Morceau morceau) {
		this.morceau = morceau;
	}


	/**
	 * traitementFlou() - return un tableau des pixels traites.
	 * 
	 * J'ai applique la solution de faire 2 zooms sur l'image, le
	 * premier qui la minimise et le second qui la maximise de
	 * maniere a retrouver la taille de depart.
	 * 
	 * @version 1.0 - 31/01/2008
	 * @author Beuque & Cornevaux
	 */
	public int[] traitementFlou() {		
		try {
			BufferedImage dst = new BufferedImage(morceau.getWidth(), morceau.getHeight(), BufferedImage.TYPE_INT_ARGB);
			dst.setRGB(0, 0, morceau.getWidth(), morceau.getHeight(), morceau.getPixelsTab(), 0, morceau.getWidth());
			dst = scale(dst, 0.25);
			dst = scale(dst, 4);
			return dst.getRGB(0, 0, morceau.getWidth(), morceau.getHeight(), null, 0, morceau.getWidth());
		} catch (Exception e) {
			System.out.println("Erreur : " + e.toString());
		}
		return null;
	}

	/** 
	 * 
	 * scale - Effectue un zoom sur une BufferedImage.
	 * (méthode de developpez.com)
	 * 
	 * @param bi l'image.
	 * @param scaleValue la valeur de l'homothétie.
	 * @return une image réduite ou agrandie.
	 * 
	 */public static BufferedImage scale(BufferedImage bi, double scaleValue) {
	        AffineTransform tx = new AffineTransform();
	        tx.scale(scaleValue, scaleValue);
	        AffineTransformOp op = new AffineTransformOp(tx,
	                AffineTransformOp.TYPE_BILINEAR);
	        BufferedImage biNew = new BufferedImage( (int) (bi.getWidth() * scaleValue),
	                (int) (bi.getHeight() * scaleValue),
	                bi.getType());
	        return op.filter(bi, biNew);
	                
	} 




} // fin classe Flou

