package serveur;

import java.rmi.Remote;
import java.rmi.RemoteException;

import serveur.exceptions.ServeurException;

import client.ClientInfos;
import decoupage.ImageSerializable;
import filtre.EnumTypeFiltre;

import admin.AdminInfos;

public interface ServeurRemote extends Remote {
	
	/**
	 * Permet de demander l'autorisation d'un traitement sur le serveur
	 * @param clientInfos Informations RMI du client qui demande le traitement
	 * @throws RemoteException Si erreur de communication RMI
	 * @throws ServeurException
	 */
	public abstract void demanderTraitementImage(ClientInfos clientInfos) throws RemoteException, ServeurException;
	
	/**
	 * Recupère le jeton passé en paramètre et l'ajoute dans la file
	 * @param jeton Jeton à ajouter
	 * @throws RemoteException Si erreur de communication RMI
	 * @throws ServeurException
	 */
	public abstract void recevoirJeton(Jeton jeton) throws RemoteException, ServeurException;
	
	/**
	 * Envoi l'image passé en paramètre au serveur
	 * @param clientInfos Informations du client qui envoi l'image
	 * @param image Image serialisable à traiter
	 * @param filtre Type de traitement à réaliser
	 * @throws RemoteException Si erreur de communication RMI
	 * @throws ServeurException
	 */
	public abstract void envoyerImage(ClientInfos clientInfos, ImageSerializable image, EnumTypeFiltre filtre) throws RemoteException, ServeurException;
	
	/**
	 * Initie le lancement de terminaison de la plate-forme de calcul
	 * @param adminInfos Informations de l'admin lance la demande
	 * @throws RemoteException Si erreur de communication RMI
	 */
	public abstract void demarrerTerminaison(AdminInfos adminInfos) throws RemoteException, ServeurException;
}
