package decoupage;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;

public class ImageSerializable implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private int pixels[];
	public final int width;
	public final int height;
	
	
	public ImageSerializable(Image img, int width, int height) throws InterruptedException {
		this.width = width;
		this.height = height;		
		pixels = new int[this.width * this.height];
		PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, pixels, 0, this.width);
		pg.grabPixels();
	}
	
	public int[] getPixels(){
		return this.pixels;
	}
	
	public Image getImage() {
		MemoryImageSource mis = new MemoryImageSource(width, height, pixels,
	0, width);
		Toolkit tk = Toolkit.getDefaultToolkit();
		return tk.createImage(mis);
	}
	
}
