/**************************************
 *
 * Programme : protocolArbitre.h
 *
 * Synopsis : entete du protocole d'acces  l'arbitre
 *            pour SIAM
 *
 * Ecrit par : JMN et LP, 29 / 02 / 08
 * 
 ***************************************/

#ifndef _protocolArbitre_h
#define _protocolArbitre_h

/* Taille des chaines */
#define TAIL_CHAIN 30

/* Identificateurs des requetes */
typedef enum { IDENTIFICATION, PARTIE, COUP, COUP_ADVERS } TypIdRequest;

/* Types d'erreur */
typedef enum { OK,             /* Validation de la requete */
	       ERR_NOM,        /* Nom inconnu */
	       ERR_JOUEUR,     /* Identificateur de joueur inconnu */
	       ERR_COUP,       /* Erreur sur le coup joue */
	       ERR_TYP         /* Erreur sur le type de requete */
} TypErreur;

/* 
 * Structures d'identification 
 */
typedef struct {

  TypIdRequest idRequest;         /* Identificateur de la requete */
  char nom[TAIL_CHAIN];           /* Nom du joueur */
  char nomMachine [TAIL_CHAIN];   /* Nom de la machine du joueur */
  short noPort;                   /* Numero de port du joueur */

} TypIdentificationReq;

typedef struct{

  TypErreur err;                  /* Code d'erreur */
  int joueur;                     /* Identificateur du joueur */

} TypIdentificationRep;

/* 
 * Structures demande de partie
 */
typedef enum { FAUX, VRAI } TypBooleen;

typedef struct{

  TypIdRequest idRequest;         /* Identificateur de la requete */
  int joueur;                     /* Identificateur du joueur */

} TypPartieReq;

/* Type des pieces */
typedef enum { RHINO, ELEPH } TypAnimal;

typedef struct {

  TypErreur err;                  /* Code d'erreur */
  int adversaire;                 /* Identificateur de l'adversaire */
  char nomMachineAdv[TAIL_CHAIN]; /* Nom machine de l'adversaire */
  short noPortAdv;                /* Numero de port de l'aversaire */
  TypBooleen finTournoi;          /* Indicateur de fin */
  TypAnimal typeAnimal;           /* Pour savoir qui debute la partie */

} TypPartieRep;

/*
 * Definition d'un point, d'apres le marquage sur le plateau
 */
typedef enum { A, B, C, D, E, L_NULL } TypLigne;
typedef enum { i, ii, iii, iv, v, C_NULL } TypColumn;
typedef enum { NORD, EST, SUD, OUEST, O_NULL } TypOrientation;

/*
 * Definition de la position d'une pice
 */
typedef struct {

  TypLigne  l;   /* Identificateur de ligne */
  TypColumn c;   /* Numero sur la colonne */

} TypPosition;

/*
 * Definition du dplacement d'une pice
 */
typedef struct {

  TypPosition posDepart;    /* Position de depart */ 
  TypPosition posArrivee;   /* Position d'arrivee */
  TypOrientation o;         /* Orientation */

} TypDeplace;

/* 
 * Structures coup du joueur pour l'arbitre et adversaire
 * et de l'adversaire pour l'arbitre
 */

/* Propriete des coups */
typedef enum { ENTREE, ENTREE_POUSSEE, SORTIE, CHANGE, DEPLACE, POUSSEE, GAGNE, PERDU } TypPropCoup;

typedef struct {

  TypIdRequest idRequest;    /* Identificateur de la requete */
  TypPropCoup  propCoup;     /* Propriete du coup */
  TypDeplace   deplace;      /* Deplacement de la piece */

} TypCoupReq;

/* Validite du coup */
typedef enum { VALID, TIMEOUT, TRICHE } TypValCoup;

/* Reponse a un coup */
typedef struct {

  TypErreur err;                  /* Code d'erreur */
  TypValCoup validCoup;           /* Validite du coup */

} TypCoupRep;

#endif
