/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8-*- */

#include "protocolArbitre.h"
#include "siam.h"

#ifndef JOUEUR_SIAM_H
#define JOUEUR_SIAM_H

typedef struct _JoueurSiam {
	
	char name[TAIL_CHAIN]; /* Nom du joueur */

	char machine[TAIL_CHAIN]; /* Nom de la machine du joueur */
	short port; /* Numero de port du joueur */
	int socket; /* Socket du joueur */
	
	TypBooleen fin_tournoi; /* Indique si le tournoi est termine */
	
	int id; /* Identifiant du joueur dans la partie */
	TypAnimal type_animal; /* Type d'animal dans la partie */
	TypBooleen fin_partie; /* Indique si la partie est termine */

	struct {
		char machine[TAIL_CHAIN]; /* Nom de la machine de l'arbitre */
		short port; /* Numero de port de l'arbitre */
		int socket; /* Socket de l'arbitre */	
	} arbitre;

	struct {
		char machine[TAIL_CHAIN]; /* Nom de la machine de l'adversaire */
		short port; /* Numero de port de l'adversaire */
		int socket; /* Socket de l'adversaire */

		int id; /* Identifiant de l'adversaire dans la partie */
	} adversaire;
	
}JoueurSiam;

/* Creer un joueur */
int 
joueur_siam_init (JoueurSiam *self, char *name, char *machine, short port);

/* Detruit un joueur */
void 
joueur_siam_destroy (JoueurSiam *self);

/* Connexion a l'arbitre */
int 
joueur_siam_connexion_arbitre (JoueurSiam *self, 
			       char *machine, short port);

/* IDENTIFICATION vers l'arbitre */
int 
joueur_siam_identification (JoueurSiam *self);

/* PARTIE demandee a l'arbitre */
int 
joueur_siam_demande_partie (JoueurSiam *self);

/* Connexion avec l'adversaire */
int 
joueur_siam_connexion_adversaire (JoueurSiam *self);

/* Deconnexion de l'adversaire */
int
joueur_siam_deconnexion_adversaire (JoueurSiam *self);

/* Joue un COUP */
int 
joueur_siam_joue_coup (JoueurSiam *self);

/* Attend un COUP de l'adversaire */
int 
joueur_siam_attend_coup_adverse (JoueurSiam *self);

#endif /* JOUEUR_SIAM_H */
