/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8-*- */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>

#include "fonctionsSocket.h"
#include "joueur-siam.h"

static TypPartie *partie_encours;

int
get_next_coup_req (JoueurSiam *self, TypCoupReq *coup_req);

static const char*
p_typanimal (TypAnimal val);

static const char*
p_atypanimal (TypAnimal val);

static const char*
p_typerreur (TypErreur val);

static const char*
p_typvalcoup (TypValCoup val);

static const char*
p_typpropcoup (TypPropCoup val);

static const char*
p_typligne (TypLigne val);

static const char*
p_typcolumn (TypColumn val);

static const char*
p_typorientation (TypOrientation val);


int 
joueur_siam_init (JoueurSiam *self, char *name, char *machine, short port)
{
	self->socket = -1;
	self->arbitre.socket = -1;
	self->adversaire.socket = -1;
	
	strncpy (self->name, name, TAIL_CHAIN);
	strncpy (self->machine, machine, TAIL_CHAIN);
	self->port = port;
	
	printf("Joueur --> Creation du joueur \"%s\" sur \"%s\", port %d.\n", 
	       self->name, self->machine, self->port);
	self->socket = socketServeur (self->port);
	if(self->socket < 0){
		perror ("socketServeur");
		return -1;
	}
	return 0;
}


void 
joueur_siam_destroy (JoueurSiam *self)
{
	if (self->socket >= 0){
		close(self->socket);
	}

	if (self->arbitre.socket >= 0){
		close(self->arbitre.socket);
	}
	
	if (self->adversaire.socket >= 0){
		close(self->adversaire.socket);
	}
}

int 
joueur_siam_connexion_arbitre (JoueurSiam *self, 
			       char *machine, short port)
{
	strncpy (self->arbitre.machine, machine, TAIL_CHAIN);
	self->arbitre.port = port;

	printf("Joueur --> Connexion a l'arbitre sur \"%s\", port %d.\n", 
	       self->arbitre.machine, self->arbitre.port);
	self->arbitre.socket = socketClient(self->arbitre.machine,
					    self->arbitre.port);
	if (self->arbitre.socket < 0){
		perror("socketClient");
		return -1;
	}
	return 0;
}

int 
joueur_siam_connexion_adversaire (JoueurSiam *self)
{
	if(self->type_animal == ELEPH){
		printf("Joueur --> Attente de la connexion de l'adversaire.\n");
		self->adversaire.socket = accept(self->socket, NULL, NULL);
		if(self->adversaire.socket < 0){
			perror("accept");
			return -1;
		}
	}else{
		printf("Joueur --> Connexion a l'adversaire sur \"%s\", port %d.\n", 
		       self->adversaire.machine, self->adversaire.port);
		self->adversaire.socket = socketClient(self->adversaire.machine,
						       self->adversaire.port);
		if (self->adversaire.socket < 0){
			perror("socketClient");
			return -1;
		}
	}
	return 0;
}

int
joueur_siam_deconnexion_adversaire (JoueurSiam *self)
{
	sleep(1);
	printf("Joueur --> Deconnexion de l'adversaire.\n");
	close (self->adversaire.socket);
	return 0;
}

int 
joueur_siam_identification (JoueurSiam *self)
{
	TypIdentificationReq ident_req;
	TypIdentificationRep ident_rep;
	
	int res;

	printf("Joueur --> IDENTIFICATION vers l'arbitre : \"%s\" sur \"%s\", port %d.\n",
	       self->name, self->machine, self->port);
	if (self->arbitre.socket<0){
		printf("Erreur : connexion a l'arbitre inexistante\n");
		return -1;
	}

	/* Envoi de la requete a l'arbitre */
	ident_req.idRequest = IDENTIFICATION;
	strncpy (ident_req.nom, self->name, TAIL_CHAIN);
	strncpy (ident_req.nomMachine, self->machine, TAIL_CHAIN);
	ident_req.noPort = self->port;	
	res = send (self->arbitre.socket, &ident_req, 
		    sizeof(TypIdentificationReq), 0);
	if (res != sizeof(TypIdentificationReq)){
		perror("send");
		return -1;
	}
	
	/* Reponse de l'arbitre */
	res = recv (self->arbitre.socket, &ident_rep, 
		    sizeof(TypIdentificationRep), 0);
	if (res != sizeof(TypIdentificationRep)){
		perror("recv");
		return -1;
	}	
	printf("Arbitre --> IDENTIFICATION = %s.\n", 
	       p_typerreur(ident_rep.err));
	if(ident_rep.err != OK){
		return -1;
	}
	self->id = ident_rep.joueur;
	printf("        --> Vous etes le joueur %d.\n",
	       self->id);

	return 0;
}

int 
joueur_siam_demande_partie (JoueurSiam *self)
{
	TypPartieReq partie_req;
	TypPartieRep partie_rep;
	
	int res;
	
	/* Envoi de la requete a l'arbitre */	
	printf("Joueur --> PARTIE demandee a l'arbitre.\n");
	if (self->arbitre.socket<0){
		printf("connexion a l'arbitre inexistante\n");
		return -1;
	}
	partie_req.idRequest = PARTIE;
	partie_req.joueur = self->id;
	res = send (self->arbitre.socket, &partie_req, sizeof(TypPartieReq), 0);
	if (res != sizeof(TypPartieReq)){
		perror("send");
		return -1;
	}

	/* Reponse de l'arbitre */
	res = recv (self->arbitre.socket, &partie_rep, sizeof(TypPartieRep), 0);
	if (res != sizeof(TypPartieRep)){
		perror("recv");
		return -1;
	}
	printf("Arbitre --> PARTIE = %s.\n", p_typerreur(partie_rep.err));
	if(partie_rep.err != OK){	
		return -1;
	}		
	strncpy (self->adversaire.machine, partie_rep.nomMachineAdv, 
		 TAIL_CHAIN);
	self->adversaire.port = partie_rep.noPortAdv;
	self->adversaire.id = partie_rep.adversaire;
	self->fin_tournoi = partie_rep.finTournoi;
	self->type_animal = partie_rep.typeAnimal;
	printf("        --> Votre adversaire est le joueur %d sur %s, port %d.\n",
	       self->adversaire.id, self->adversaire.machine,
	       self->adversaire.port);	      
	printf("        --> Vous etes %s.\n",
	       p_typanimal(self->type_animal));

	if(self->type_animal == ELEPH){
		partie_encours = nouvellePartie(self->id, self->adversaire.id);
	}else{
		partie_encours = nouvellePartie(self->adversaire.id, self->id);
	}
	self->fin_partie = FAUX;
	
	return 0;
}

int 
joueur_siam_joue_coup (JoueurSiam *self)
{
	TypCoupReq coup_req;
	TypCoupRep coup_rep;
	
	int res;
	
	printf("Jeu --> Tour de %s (vous).\n",
	       p_typanimal(self->type_animal));

	if (self->arbitre.socket<0){
		printf("connexion a l'arbitre inexistante\n");
		return -1;
	}
	if (self->adversaire.socket<0){
		printf("connexion a l'adversaire inexistante\n");
		return -1;
	}

	/* Recupere le nouveau COUP a jouer */
	coup_req.idRequest = COUP;
	printf("Joueur --> Demande COUP au moteur de jeu.\n");
	get_next_coup_req (self, &coup_req);
	printf("Joueur --> COUP est %s ([%s,%s] [%s,%s] (%s)) .\n",
	       p_typpropcoup (coup_req.propCoup),
	       p_typligne (coup_req.deplace.posDepart.l),
	       p_typcolumn (coup_req.deplace.posDepart.c),
	       p_typligne (coup_req.deplace.posArrivee.l),
	       p_typcolumn (coup_req.deplace.posArrivee.c),
	       p_typorientation (coup_req.deplace.o));
	
	/* Regarde si l'arbitre a envoye un TIMEOUT */
	int on = 1;
	ioctl (self->arbitre.socket, FIONBIO, &on);
	res = recv (self->arbitre.socket, &coup_rep, sizeof(TypCoupRep) + 50, 0);
	if (res == sizeof(TypCoupRep)){	
		printf("Arbitre --> COUP = %s.\n",
		       p_typerreur(coup_rep.err));
		printf("        --> Le COUP est %s.\n",
		       p_typvalcoup (coup_rep.validCoup));
		on = 0;
		ioctl (self->arbitre.socket, FIONBIO, &on);
		return -1;
	}
	on = 0;
	ioctl (self->arbitre.socket, FIONBIO, &on);
	printf("Arbitre --> Pas encore de TIMEOUT pour COUP.\n");

	/* Envoi de la requete a l'arbitre */
	printf("Joueur --> Envoi du COUP a l'arbitre.\n");
	res = send (self->arbitre.socket, &coup_req, sizeof(TypCoupReq), 0);
	if (res != sizeof(TypCoupReq)){
		perror("send");
		return -1;
	}

	/* Reponse de l'arbitre */
	res = recv (self->arbitre.socket, &coup_rep, sizeof(TypCoupRep) + 50, 0);
	if (res != sizeof(TypCoupRep)){
		perror("recv");
		return -1;
	}
	printf("Arbitre --> COUP = %s.\n", p_typerreur(coup_rep.err));
	if(coup_rep.err != OK){
		return -1;
	}
	printf("        --> Le COUP est %s.\n",
	       p_typvalcoup (coup_rep.validCoup));
	if(coup_rep.validCoup != VALID){
		return -1;
	}

	/* Validation du coup dans le jeu */
	if(validationCoup(partie_encours, self->id, 
			  coup_req.deplace, coup_req.propCoup) == FAUX){
		return -1;
	}

	/* Envoi de la requete a l'adversaire */
	printf("Joueur --> Envoi du coup a l'adversaire.\n");
	res = send (self->adversaire.socket, &coup_req, sizeof(TypCoupReq), 0);
	if (res != sizeof(TypCoupReq)){
		perror("send");
		return -1;
	}

	/* Confirmation de l'adversaire */
	res = recv (self->adversaire.socket, &coup_rep, sizeof(TypCoupRep) + 50, 0);
	if (res != sizeof(TypCoupRep)){
		perror("recv");
		return -1;
	}
	printf("Adversaire --> COUP est %s.\n",
	       p_typerreur(coup_rep.err));
	if(coup_rep.err != OK){
		return -1;
	}

	if(coup_req.propCoup == GAGNE || coup_req.propCoup == PERDU){
		self->fin_partie = VRAI;
	}

	return 0;
}

int 
joueur_siam_attend_coup_adverse (JoueurSiam *self)
{
	TypCoupReq coup_req;
	TypCoupRep coup_rep;
	
	int res;
	fd_set fdset;
	
	FD_ZERO(&fdset);
	FD_SET(self->arbitre.socket, &fdset);
	FD_SET(self->adversaire.socket, &fdset);
	
	printf("Jeu --> Tour de %s.\n",
	       p_atypanimal(self->type_animal));

	printf("Joueur --> Attente de COUP_ADVERS ou TIMEOUT.\n");
	res = select(FD_SETSIZE, &fdset, NULL, NULL, NULL);
	if(res < 0){
		perror("select");
		return -1;	
	}

	/* Reception de l'arbitre */
	if(FD_ISSET(self->arbitre.socket, &fdset)){
		printf("test 1\n");
		res = recv (self->arbitre.socket, &coup_rep, 
			     sizeof(TypCoupRep), 0);
		if (res != sizeof(TypCoupRep)){
			perror("recv");
			return -1;
		}
		printf("Arbitre --> COUP_ADVERS est %s.\n",
		       p_typvalcoup (coup_rep.validCoup));
		return -1;
	}

	/* Reception du coup de l'adversaire */
	if(FD_ISSET(self->adversaire.socket, &fdset)){
		printf("test 2\n");
		res = recv (self->adversaire.socket, &coup_req, sizeof(TypCoupReq), 0);
		if (res != sizeof(TypCoupReq)){
			perror("recv");
			return -1;
		}
		printf("Adversaire  --> COUP joue est %s.\n",
		       p_typpropcoup (coup_req.propCoup));

		/* Envoi de la requete a l'adversaire */		
		printf("Joueur --> Envoi confirmation a l'adversaire.\n");
		coup_rep.err = OK;
		res = send (self->adversaire.socket, &coup_rep, sizeof(TypCoupRep), 0);
		if (res != sizeof(TypCoupRep)){
			perror("send");
			return -1;
		}
	
		coup_req.idRequest = COUP_ADVERS;

		/* Envoi de la validation de l'adversaire a l'arbitre */
		printf("Joueur --> Envoi du coup de l'adversaire a l'arbitre.\n");
		res = send (self->arbitre.socket, &coup_req, sizeof(TypCoupReq), 0);
		if (res != sizeof(TypCoupReq)){
			perror("send");
			return -1;
		}
		
		/* Reponse de l'arbitre */
		res = recv (self->arbitre.socket, &coup_rep, sizeof(TypCoupRep), 0);
		if (res != sizeof(TypCoupRep)){
			perror("recv");
			return -1;
		}
		printf("Arbitre --> COUP_ADVERS = %s.\n", p_typerreur(coup_rep.err));
		if(coup_rep.err != OK){
			return -1;
		}
		printf("        --> Le COUP_ADVERS est %s.\n",
		       p_typvalcoup (coup_rep.validCoup));
		if(coup_rep.validCoup != VALID){
			return -1;
		}

		/* Validation du coup dans le jeu */
		if(validationCoup(partie_encours, self->adversaire.id, 
				  coup_req.deplace, coup_req.propCoup) == FAUX){
			return -1;
		}

		if(coup_req.propCoup == GAGNE || coup_req.propCoup == PERDU){
			self->fin_partie = VRAI;
		}
	}
	return 0;
}

int
get_next_coup_req (JoueurSiam *self, TypCoupReq *coup_req)
{
	
	int sock;
	int port = 8007;
	int err;
	int clen = 50;
	int g, j, k;
	
	char recu[50];
	char plateau[256];
	int plen = 0;
	char tabvar[7][20];

	afficher(partie_encours);
	
	printf("Joueur --> Recuperation du prochain COUP a jouer.\n");
       	
	printf("Joueur --> Connexion au moteur de l'IA sur le port %d.\n", port);
	sock = socketClient("localhost", port);
	if (sock < 0){
		perror("socketClient");
		return -1;
	}

	printf("Joueur --> Envoi de l'tat du jeu a l'IA.\n");
	
	/* Met le plateau de jeu dans une chaine */
	strncpy(plateau, "coup_suivant([", 14);
	plen = 14;
	for(g=0;g<NB_LIGNE;g++){
		if(g!=0){
			plateau[plen] = ',';
			plen++;
		}
		plateau[plen] = '[';
		plen++;
		for(j=0;j<NB_COLONNE;j++){
			if(j!=0){
				plateau[plen] = ',';
				plen++;
			}
			if(partie_encours->plateau[g][j].piece == CS_VIDE){
				plateau[plen] = '0';
				plen++;
			}
			if(partie_encours->plateau[g][j].piece == CS_ROCHER){
				plateau[plen] = 'm';
				plen++;
			}
			if(partie_encours->plateau[g][j].piece == CS_RHINO || 
			   partie_encours->plateau[g][j].piece == CS_ELEPH){
				plateau[plen] = '[';
				plen++;
				if(partie_encours->plateau[g][j].piece == CS_RHINO){
					plateau[plen] = 'r';
					plen++;
				}else{
					plateau[plen] = 'e';
					plen++;	
				}
				plateau[plen] = ',';
				plen++;
				switch(partie_encours->plateau[g][j].orientation){
				case O_SANS : strncpy(plateau+plen,"null",4); plen+= 4; break;
				case O_NORD : plateau[plen] = 'h'; plen++; break;
				case O_EST : plateau[plen] = 'd'; plen++; break;
				case O_SUD : plateau[plen] = 'b'; plen++; break;
				case O_OUEST : plateau[plen] = 'g'; plen++; break;
				}
				plateau[plen] = ']';
				plen++;
			}
		}
		plateau[plen] = ']';
		plen++;
	}
	strncpy(plateau+plen, "],", 2);
	plen+=2;
	if(self->type_animal == ELEPH){
		plateau[plen] = 'e';
		plen++;	
	}else{
		plateau[plen] = 'r';
		plen++;	
	}
	strncpy(plateau+plen, ",[J,TC,[L1,C1],[L2,C2],O]).", 27);
	plen+=27;
	plateau[plen] = '\0';
	printf("       --> %s\n", plateau);
	
	err = send( sock, plateau, strlen(plateau), 0);
	if (err!= strlen(plateau)) {
		perror("Erreur sur le send\n");
		return -1;
	}
	
	printf("Moteur IA --> Reception du coup.\n");
	err = recv(sock, recu, clen, 0);
	if (err < 0) {
		perror("recv");
		return -1;
	}
	recu[err - 1]='\0';
	printf("          --> %d - '%s'\n", err, recu);
	
	/* Recupere la liste des parametres du COUP */
	g = 0;
	j = 0;
	k = 0;
	while (recu[g]!='\0'){
		if (recu[g]!=';') {
			tabvar[j][k] = recu[g];
			k++;
		}else{
			tabvar[j][k] = '\0';	
			j++;
			k = 0;
		}		
		g++;
	}
	tabvar[j][k] = '\0';
	
	/* Met le coup dans la structure */
	/* Type de coup */
	if(strcmp(tabvar[1], "entree") == 0){
		coup_req->propCoup = ENTREE;
	}
	if(strcmp(tabvar[1], "entreepoussee") == 0){
		coup_req->propCoup = ENTREE_POUSSEE;
	}
	if(strcmp(tabvar[1], "sortie") == 0){
		coup_req->propCoup = SORTIE;
	}
	if(strcmp(tabvar[1], "change") == 0){
		coup_req->propCoup = CHANGE;
	}
	if(strcmp(tabvar[1], "deplace") == 0){
		coup_req->propCoup = DEPLACE;
	}
	if(strcmp(tabvar[1], "poussee") == 0){
		coup_req->propCoup = POUSSEE;
	}
	if(strcmp(tabvar[1], "gagne") == 0){
		coup_req->propCoup = GAGNE;
	}
	if(strcmp(tabvar[1], "perdu") == 0){
		coup_req->propCoup = PERDU;
	}
	/* Ligne de depart */
	if(strcmp(tabvar[2], "null") == 0){
		coup_req->deplace.posDepart.l = L_NULL;
	}
	if(strcmp(tabvar[2], "1") == 0){
		coup_req->deplace.posDepart.l = A;
	}
	if(strcmp(tabvar[2], "2") == 0){
		coup_req->deplace.posDepart.l = B;
	}
	if(strcmp(tabvar[2], "3") == 0){
		coup_req->deplace.posDepart.l = C;
	}	
	if(strcmp(tabvar[2], "4") == 0){
		coup_req->deplace.posDepart.l = D;
	}
	if(strcmp(tabvar[2], "5") == 0){
		coup_req->deplace.posDepart.l = E;
	}
	/* Colonne de depart */
	if(strcmp(tabvar[3], "null") == 0){
		coup_req->deplace.posDepart.c = C_NULL;
	}
	if(strcmp(tabvar[3], "1") == 0){
		coup_req->deplace.posDepart.c = i;
	}
	if(strcmp(tabvar[3], "2") == 0){
		coup_req->deplace.posDepart.c = ii;
	}
	if(strcmp(tabvar[3], "3") == 0){
		coup_req->deplace.posDepart.c = iii;
	}	
	if(strcmp(tabvar[3], "4") == 0){
		coup_req->deplace.posDepart.c = iv;
	}
	if(strcmp(tabvar[3], "5") == 0){
		coup_req->deplace.posDepart.c = v;
	}
	/* Ligne d'arrivee */
	if(strcmp(tabvar[4], "null") == 0){
		coup_req->deplace.posArrivee.l = L_NULL;
	}
	if(strcmp(tabvar[4], "1") == 0){
		coup_req->deplace.posArrivee.l = A;
	}
	if(strcmp(tabvar[4], "2") == 0){
		coup_req->deplace.posArrivee.l = B;
	}
	if(strcmp(tabvar[4], "3") == 0){
		coup_req->deplace.posArrivee.l = C;
	}	
	if(strcmp(tabvar[4], "4") == 0){
		coup_req->deplace.posArrivee.l = D;
	}
	if(strcmp(tabvar[4], "5") == 0){
		coup_req->deplace.posArrivee.l = E;
	}
	/* Colonne d'arrivee */
	if(strcmp(tabvar[5], "null") == 0){
		coup_req->deplace.posArrivee.c = C_NULL;
	}
	if(strcmp(tabvar[5], "1") == 0){
		coup_req->deplace.posArrivee.c = i;
	}
	if(strcmp(tabvar[5], "2") == 0){
		coup_req->deplace.posArrivee.c = ii;
	}
	if(strcmp(tabvar[5], "3") == 0){
		coup_req->deplace.posArrivee.c = iii;
	}	
	if(strcmp(tabvar[5], "4") == 0){
		coup_req->deplace.posArrivee.c = iv;
	}
	if(strcmp(tabvar[5], "5") == 0){
		coup_req->deplace.posArrivee.c = v;
	}
	/* Orientation */
	if(strcmp(tabvar[6], "null") == 0){
		coup_req->deplace.o = O_NULL;
	}
	if(strcmp(tabvar[6], "h") == 0){
		coup_req->deplace.o = NORD;
	}
	if(strcmp(tabvar[6], "d") == 0){
		coup_req->deplace.o = EST;
	}
	if(strcmp(tabvar[6], "b") == 0){
		coup_req->deplace.o = SUD;
	}	
	if(strcmp(tabvar[6], "g") == 0){
		coup_req->deplace.o = OUEST;
	}

	close(sock);

	return 0;
}

static const char*
p_typanimal (TypAnimal val)
{
	switch(val){
	case RHINO :
		return "RHINO"; break;
	case ELEPH :
		return "ELEPH"; break;
	}

	return "";	
}

static const char*
p_atypanimal (TypAnimal val)
{
	switch(val){
	case RHINO :
		return "ELEPH"; break;
	case ELEPH :
		return "RHINO"; break;
	}

	return "";	
}

static const char*
p_typerreur (TypErreur val)
{
	switch(val){
	case OK :
		return "OK"; break;
	case ERR_NOM :
		return "ERR_NOM"; break;
	case ERR_JOUEUR :
		return "ERR_JOUEUR"; break;
	case ERR_COUP :
		return "ERR_COUP"; break;
	case ERR_TYP :
		return "ERR_TYP"; break;
	}

	return "";	
}

static const char*
p_typvalcoup (TypValCoup val)
{	
	switch(val){
	case TIMEOUT :
		return "TIMEOUT"; break;
	case TRICHE :
		return "TRICHE"; break;
	case VALID :
		return "VALID"; break;
	}

	return "";
}

static const char*
p_typpropcoup (TypPropCoup val)
{
	switch(val){
	case ENTREE :
		return "ENTREE"; break;
	case ENTREE_POUSSEE :
		return "ENTREE_POUSSEE"; break;
	case SORTIE :
		return "SORTIE"; break;
	case CHANGE :
		return "CHANGE"; break;
	case DEPLACE :
		return "DEPLACE"; break;
	case POUSSEE :
		return "POUSSEE"; break;
	case GAGNE :
		return "GAGNE"; break;
	case PERDU :
		return "PERDU"; break;
	}

	return "";
}

static const char*
p_typligne (TypLigne val)
{
	switch(val){
	case L_NULL :
		return "null"; break;
	case A :
		return "A"; break;
	case B :
		return "B"; break;
	case C :
		return "C"; break;
	case D :
		return "D"; break;
	case E :
		return "E"; break;
	}

	return "";
}

static const char*
p_typcolumn (TypColumn val)
{
	switch(val){
	case L_NULL :
		return "null"; break;
	case i :
		return "i"; break;
	case ii :
		return "ii"; break;
	case iii :
		return "iii"; break;
	case iv :
		return "iv"; break;
	case v :
		return "v"; break;
	}

	return "";
}

static const char*
p_typorientation (TypOrientation val)
{
	switch(val){
	case O_NULL :
		return "null"; break;
	case NORD :
		return "NORD"; break;
	case EST :
		return "EST"; break;
	case SUD :
		return "SUD"; break;
	case OUEST :
		return "OUEST"; break;
	}

	return "";
}
