package relais;

import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class Launch {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			// create and initialize the ORB
			ORB orb = ORB.init(args, null);

			// get reference to rootpoa
			org.omg.CORBA.Object obj = orb
					.resolve_initial_references("RootPOA");
			POA rootpoa = POAHelper.narrow(obj);

			// activate the POAManager
			rootpoa.the_POAManager().activate();

			// create servant
			RelaisServer serveur = RelaisServer.create();

			// get object reference from the servant
			org.omg.CORBA.Object ref = rootpoa.servant_to_reference(serveur);

			// get the root naming context
			org.omg.CORBA.Object objRef = orb
					.resolve_initial_references("NameService");
			NamingContext ncRef = NamingContextHelper.narrow(objRef);

			// bind the Object Reference in Naming
			NameComponent nc = new NameComponent("Relais", "");
			NameComponent path[] = { nc };
			ncRef.rebind(path, ref);

			// wait for invocations from clients
			orb.run();

			// serveur.stopServeur();
		} catch (Exception e) {
			System.err.println("ERROR: " + e);
			e.printStackTrace(System.out);
		}
	}

}
