#!/bin/sh

#export JORAM_HOME=/usr/local/joram-4.3.28

# Verify if JAVA_HOME is well defined
if [ ! -r "$JAVA_HOME"/bin/java ]; then
  echo "The JAVA_HOME environment variable is not defined correctly"
  echo "This environment variable is needed to run this program"
  exit 1
fi

CONFIG_DIR=./config
JORAM_LIBS=$JORAM_HOME/ship/lib
RUN_DIR=./run

# Building the Classpath
CLASSPATH=$JORAM_LIBS/joram-mom.jar
CLASSPATH=$CLASSPATH:$JORAM_LIBS/joram-shared.jar
CLASSPATH=$CLASSPATH:$JORAM_LIBS/jakarta-regexp-1.2.jar
CLASSPATH=$CLASSPATH:$JORAM_LIBS/JCup.jar
CLASSPATH=$CLASSPATH:$JORAM_LIBS/ow_monolog.jar
CLASSPATH=$CLASSPATH:$JORAM_LIBS/jmxri.jar
CLASSPATH=$CLASSPATH:$RUN_DIR

mkdir $RUN_DIR
cp $CONFIG_DIR/a3config.dtd $RUN_DIR/a3config.dtd
cp $CONFIG_DIR/a3debug.cfg $RUN_DIR/a3debug.cfg
cp $CONFIG_DIR/centralized_a3servers.xml $RUN_DIR/a3servers.xml
cp $CONFIG_DIR/jndi.properties $RUN_DIR/jndi.properties

echo "== Launching a non persistent server#0 =="
cd $RUN_DIR; exec $JAVA_HOME/bin/java -classpath $CLASSPATH fr.dyade.aaa.agent.AgentServer 0 ./s0
