package server;

import java.io.*;
import java.net.ConnectException;
import java.net.UnknownHostException;

import javax.jms.*;
import javax.naming.Context;
import javax.naming.NamingException;

import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;

public class CertificatServeur extends Thread implements ICertificatServeur {

	static Context ictx = null;

	private final String host;
	private final String queueName;
	private final String topicName;
	private final String cnxFactory;
	private final String login;
	private final String pwd;
	private final int port;
	private final int cnxTimer;
	private final String topicCnxFactory;
	private javax.jms.TopicConnectionFactory tcf;
	MessageProducer producer;
	Session queueSession;
	private QueueCertificatServeur queueCertificat;
	private TopicCertificatServeur topicCertificat;
	private final String certifDir;
	private final String certifPassword;

	/**
	 * Constructeur
	 * 
	 * @param login
	 *            Nom utilisateur JMS
	 * @param password
	 *            Password JMS
	 * @param certifDir
	 *            Chemin du certificat du serveur
	 */
	public CertificatServeur(String login, String password, String certifDir,
			String certifPassword) {
		host = DEFAULT_HOST;
		queueName = DEFAULT_QUEUE;
		topicName = DEFAULT_TOPIC;
		this.login = login;
		this.pwd = password;
		port = DEFAULT_PORT;
		cnxTimer = DEFAULT_CNX_TIMER;
		topicCnxFactory = DEFAULT_TOPIC_FACTORY;
		cnxFactory = DEFAULT_CNX_FACTORY;
		this.certifDir = certifDir;
		this.certifPassword = certifPassword;
		createQueue();
		createTopic();
		System.out.println("Serveur de certificat prêt");
	}

	/**
	 * Fonction de création d'une queue
	 */
	private void createQueue() {
		try {
			System.out.println("Create queue");
			AdminModule.connect(host, port, login, pwd, cnxTimer);
			System.out.println("Admin connected.");
			Queue queue = Queue.create(queueName);

			System.out.println("Création d'un utilisateur");
			User.create("anonymous", "anonymous");

			System.out.println("Queue created.");
			queue.setFreeReading();
			queue.setFreeWriting();

			QueueConnectionFactory qcf = QueueTcpConnectionFactory.create(host,
					port);
			queueCertificat = new QueueCertificatServeur(this, queue, qcf);

			System.out.println("Queue connexion factory created.");
			AdminModule.disconnect();
			System.out.println("Admin closed.");
		} catch (ConnectException e) {
			System.err.println("Erreur de connexion au serveur " + host);
		} catch (UnknownHostException e) {
			System.err.println("Nom de serveur " + host + " inconnu");
		} catch (AdminException e) {
			System.err.println("Erreur Admin " + e.getMessage());
		} catch (JMSException e) {
			e.printStackTrace();
		}

	}

	/**
	 * Fonction de creation d'un Topic
	 */
	private void createTopic() {
		try {
			AdminModule.connect(host, port, login, pwd, cnxTimer);
			System.out.println("Admin connected");

			System.out.println("Création d'un utilisateur");
			User.create("anonymous", "anonymous");

			Topic topic = Topic.create(topicName);
			System.out.println("Topic created.");

			topic.setFreeReading();
			topic.setFreeWriting();

			javax.jms.ConnectionFactory cf = TcpConnectionFactory.create(host,
					port);

			tcf = TopicTcpConnectionFactory.create(host, port);

			// Déclaration JNDI du topic
			System.out.println("Inscription du topic dans le JNDI");
			Context jndiCtx = new javax.naming.InitialContext();
			jndiCtx.rebind(cnxFactory, cf);
			jndiCtx.rebind(topicCnxFactory, tcf);
			jndiCtx.rebind(topicName, topic);
			jndiCtx.close();

			AdminModule.disconnect();
			System.out.println("Admin closed.");

			topicCertificat = new TopicCertificatServeur(topicName,
					topicCnxFactory, queueCertificat.getQueue(),
					queueCertificat.getQueueConnexionFactory());

		} catch (ConnectException e) {
			System.err.println("Erreur de connexion au serveur " + host);
		} catch (UnknownHostException e) {
			System.err.println("Nom de serveur " + host + " inconnu");
		} catch (AdminException e) {
			System.err.println("Erreur Admin " + e.getMessage());
		} catch (NamingException e) {
			System.err.println("Nom inconnu " + e.getMessage());
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Evoie un message comme quoi le serveur est prêt dans le topic toutes les
	 * 10s
	 */
	@Override
	public void run() {
		while (true) {
			try {
				topicCertificat.sendPret();
			} catch (JMSException e) {
				e.printStackTrace();
			}
			synchronized (this) {
				try {
					wait(5000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * Main
	 * 
	 * @param args
	 */
	static public void main(String[] args) {
		CertificatServeur certificatServer = null;
		try {
			certificatServer = new CertificatServeur("admin", "admin", ".",
					"admin");
			certificatServer.start();
		} catch (Exception e1) {
			e1.printStackTrace();
			System.exit(-1);
			return;
		}

		try {
			certificatServer.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Fonction de generation du certificat client
	 * 
	 * @param openSSLReq
	 * 
	 * @Author Cyril
	 * @date 10 janv. 2009
	 */
	synchronized public void genererCertificatClient(String openSSLReq) {
		System.out.println("Generation du certificat du client");
		File f = new File(certifDir + File.separator + "openSSLReq.req");
		f.getParentFile().mkdirs();
		try {
			FileWriter out = new FileWriter(f);
			out.write(openSSLReq);
			out.close();
		} catch (IOException e1) {
			e1.printStackTrace();
		}

		String filenameCert = certifDir + File.separator + "newcerts"
				+ File.separator + "key.pem";

		try {
			try {
				String[] command = { "openssl", "ca", "-config",
						"../config/openssl.cnf", "-in", f.getCanonicalPath(),
						"-out", filenameCert, "-passin", "stdin" };
				System.out.println("Execution de la commande : openssl ca");
				final Process process = Runtime.getRuntime().exec(command);
				for (String cmd : command) {
					System.out.print(cmd + " ");
				}
				Thread error = new Consumer(process.getErrorStream());
				error.start();
				Thread input = new Consumer(process.getInputStream());
				input.start();

				System.out.println();
				PrintStream printer = new PrintStream(new BufferedOutputStream(
						process.getOutputStream()), true);
				printer.println(certifPassword);
				printer.println("y");
				printer.println("y");
				printer.flush();
				printer.close();

				int exitStatus = process.waitFor();

				error.join();
				input.join();
				
				process.getInputStream().close();
				process.getOutputStream().close();
				process.getErrorStream().close();				

				System.out.println("La commande openssl a renvoyé le code : "
						+ exitStatus);

				f = new File(filenameCert);
				BufferedReader reader = new BufferedReader(
						new InputStreamReader(new FileInputStream(f)));
				String certif = "";
				try {
					String line = "";
					while ((line = reader.readLine()) != null) {
						certif += line + "\n";
					}
				} finally {
					reader.close();
				}
				queueCertificat.retournerCertificat(certif);
			} catch (Exception e) {
				e.printStackTrace();
				queueCertificat
						.retournerCertificat("ERREUR de génération du certificat\n"
								+ e.getMessage());
			}

		} catch (JMSException e) {
			e.printStackTrace();
		}
		synchronized (this) {
			this.notify();
		}
	}

	/**
	 * Fonction de generation du certificat serveur
	 * 
	 * @Author Cyril
	 * @date 10 janv. 2009
	 */
	synchronized public void genererCertificatServeur() {
		System.out.println("Recupération du certificat du serveur");
		try {

			String certif = "";
			try {
				File f = new File(certifDir + File.separator + "cacert.pem");
				System.out.println("Lecture du fichier : "
						+ f.getCanonicalPath());
				BufferedReader reader = new BufferedReader(
						new InputStreamReader(new FileInputStream(f)));
				try {
					String line = "";
					while ((line = reader.readLine()) != null) {
						certif += line + "\n";
					}
				} finally {
					reader.close();
				}
			} catch (Exception e) {
				certif = "ERREUR de génération du certificat\n"
						+ e.getMessage();
				e.printStackTrace();
			}

			queueCertificat.retournerCertificat(certif);
		} catch (JMSException e) {
			e.printStackTrace();
		}
		synchronized (this) {
			this.notify();
		}
	}

	// Consommation de la sortie d'erreur de l'application externe dans un
	// Thread separe
	class Consumer extends Thread {
		InputStream input;

		public Consumer(InputStream input) {
			this.input = input;
		}

		public void run() {
			try {
				BufferedReader reader = new BufferedReader(
						new InputStreamReader(input));
				String line = "";
				try {
					while ((line = reader.readLine()) != null) {
						System.out.println(":"+line);
					}
				} finally {
					reader.close();
				}
			} catch (IOException ioe) {
				ioe.printStackTrace();
			}
		}
	}

}
