/* -*- Mode: C++; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8-*- */
#include<iostream>
#include<fstream>
#include<string>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

// SSL includes
#include<openssl/crypto.h>
#include<openssl/x509.h>
#include<openssl/pem.h>
#include<openssl/ssl.h>
#include<openssl/err.h>

using namespace std;

#include<RelaisApp.hh>

using namespace RelaisApp;

int main(int argc, char **argv){

	bool badParam = false;

	bool isServeur;
	
	// Vérification des parametres
	if(argc < 4){
		badParam = true;
	}
	
	if(strlen(argv[1]) != 2){
		badParam = true;
	}
	
	if(argv[1][0] != '-'){
		badParam = true;
	}	
	
	if(argv[1][1] == 'c'){
		isServeur = false;
		if(argc < 5){
			badParam = true;
		}
	}else if(argv[1][1] == 's'){
		isServeur = true;
	}else{
		badParam = true;
	}

	if(badParam){
		cout << "Usage : " << argv[0] << " [-s|-c] dirClient portServeur [hoteServeur]" << endl;
		cout << "        -s : le client joue le role du serveur" << endl;
		cout << "        -c : le client joue le role du client" << endl;
		cout << "        dirClient : dossier contenant les cles du client" << endl;
		cout << "        portServeur : port du serveur" << endl;
		cout << "        hoteServeur : hote du serveur (client uniquement)" << endl;
		exit(-1);
	}
	
	char *dirClient = argv[2];
	string keyFileName(dirClient);
	keyFileName.append("private/key");
	string reqFileName(dirClient);
	reqFileName.append("private/req");

	int portServeur = atoi(argv[3]);
	char *hoteServeur = argv[4];

	cout << "[Client] Lancement du client" << endl;
	
	// Lecture de la cle dans le fichier
	string reqClient;
	cout << "[Client] Chargement du fichier : " << reqFileName.c_str() << endl;
	ifstream reqFile(reqFileName.c_str(), ios::in);
	if(reqFile){
		string lineContent;
		while(getline(reqFile, lineContent)){
			reqClient.append(lineContent + "\n");
		}
		reqFile.close();
	}else{
		cerr << "[ERREUR] Impossible d'ouvrir le fichier !" << endl;
		exit(-1);
	}	
	cout << reqClient;

	string nouvCertFileName;
	string caCertFileName;

	// Obtention des certificats
	try {
		// Initialize ORB
		cout << "[Client] Initialisation de CORBA" << endl;
		CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "omniORB4");
		cout << "[Client] Recherche du NameService" << endl;
		// Get naming service
		CORBA::Object_var obj;
		obj = orb -> resolve_initial_references("NameService");
		if(CORBA::is_nil(obj)) {
			cerr << "[ERREUR] 'NameService' est une reference nulle" << endl;
			orb->destroy();
			exit(-1);		
		}
    
		CosNaming::NamingContext_var nc = CosNaming::NamingContext::_narrow(obj);

		cout << "[Client] Bind sur le Relais" << endl;
		CORBA::Object_var objRelais;
		try{
			// Compose Name and get reference
			CosNaming::Name ncName;
			ncName.length(1);
      
			ncName[0].id = CORBA::string_dup("Relais");
			ncName[0].kind = CORBA::string_dup("");

			objRelais = nc->resolve(ncName);
		}catch(const CORBA::Exception& ex) {
			cerr << "[ERREUR] Erreur de rebind" << endl;
			orb->destroy();
			exit(-1);
		}    
 
		Relais_ptr refRelais;
		refRelais = Relais::_narrow(objRelais);
		if( CORBA::is_nil(refRelais) ) {
			cerr << "[ERREUR] Le relais a une reference nulle" << endl;
			exit(-1);
		}
		
		// Création d'un certificat
		cout << "[Client] Demande d'un nouveau certificat au serveur" << endl;
		CORBA::String_var nouvCert = refRelais->getNouveauCertificat(reqClient.c_str());
		nouvCertFileName = (dirClient);
		nouvCertFileName.append("key.pem");    
		cout << "[Client] Ecriture dans le fichier " << nouvCertFileName.c_str() << endl;
		ofstream nouvCertFile(nouvCertFileName.c_str(), ios::out | ios::trunc);
		if(nouvCertFile){
			nouvCertFile << nouvCert;
			nouvCertFile.close();
		}else{
			cerr << "[ERREUR] Impossible d'ouvrir le fichier !" << endl;
			exit(-1);
		}

		// Obtention du certificat racine
		cout << "[Client] Demande du certificat d'autorite au serveur" << endl;
		CORBA::String_var caCert = refRelais->getCertificatAutorite();
		caCertFileName = (dirClient);
		caCertFileName.append("cacert.pem");    
		cout << "[Client] Ecriture dans le fichier " << caCertFileName.c_str() << endl;
		ofstream caCertFile(caCertFileName.c_str(), ios::out | ios::trunc);
		if(caCertFile){
			caCertFile << caCert;
			caCertFile.close();
		}else{
			cerr << "[ERREUR] Impossible d'ouvrir le fichier !" << endl;
			exit(-1);
		}
		
		// shutdown orb
		orb->destroy();

	}catch(CORBA::Exception& ex) {
		cerr << "[ERREUR] CORBA Exception :" << endl;
		exit(-1);
	}


	// Variable commune avec le client et le serveur
	int err; // error code
	int sd = -1; // socket descriptors
	struct sockaddr_in sockAddr; // socket address		
	// SSL data declaration
	SSL_CTX* ctx; // SSL context         
	SSL* ssl = NULL;
	SSL_METHOD *meth; // authentification method
	char buf[4096]; // Buffer pour la reception de message

	// Varaible utile au serveur
	int listenSd = -1; // socket descriptors

	// Communication SSL
	if(isServeur){
		cout << "[Client] Lancement du serveur de communication SSL" << endl;
		SSL_load_error_strings(); // errors		
		SSL_library_init(); // registers the available ciphers and digests		
		meth = SSLv23_server_method(); // ssl ctx init
	}else{
		cout << "[Client] Lancement du client de communication SSL" << endl;		
		SSLeay_add_ssl_algorithms();
		meth = SSLv2_client_method();		
		
	}
	
	cout << "[Client] Initialisation de SSL" << endl;
	
	ctx = SSL_CTX_new( meth ); 
	if ( ctx == NULL ) {
		cerr << "[ERREUR] Error initializing ssl ctx" << endl;
		exit(-1);
	}

	// initialize server certificate
	cout << "[Client] Utilisation du certificat public " <<  nouvCertFileName.c_str() << endl;
	err = SSL_CTX_use_certificate_file(ctx, nouvCertFileName.c_str(), SSL_FILETYPE_PEM);
	if ( err == -1 ) {
		cerr << "[ERREUR] Error initializing ssl certificate" << endl;
		exit(-1);
	}
	
	// initialize server private key
	cout << "[Client] Utilisation de la cle privee " <<  keyFileName.c_str() << endl;
	err = SSL_CTX_use_RSAPrivateKey_file(ctx, keyFileName.c_str(), SSL_FILETYPE_PEM);
	if ( err == -1 ) {
		cerr << "[ERREUR] Error initializing ssl private key" << endl;
		exit(-1);
	}
	
	// check private key
	cout << "[Client] Verification du certificat" << endl;
	if (!SSL_CTX_check_private_key(ctx)) {
		cerr << "[ERREUR] Private key does not match the certificate public key" << endl;
		exit(-1);
	}
	
	// initialize ca cert
	cout << "[Client] Parametrage du certificat de l'autorite" << endl;
	SSL_CTX_set_verify(ctx, SSL_VERIFY_PEER, NULL);
	err = SSL_CTX_load_verify_locations(ctx,  caCertFileName.c_str(), NULL);
	if ( err == -1 ) {
		cerr << "[ERREUR] Error loading ssl verify locations" << endl;
		exit(-1);
	}
	
	if(isServeur){		
		struct sockaddr_in cliAddr;   // clisocket address
		X509* myCert;            // X509 certificat
		
		cout << "[Client] Initialisation du serveur sur le port " << portServeur << endl;
		
		// create standard tcp socket and bind it
		listenSd = socket (AF_INET, SOCK_STREAM, 0);
		if ( listenSd == -1 ) {
			cerr << "[ERREUR] Erreur a lors de la creation de la socket" << endl;
			exit(-1);
		}
		
		//memset (&myAddr, '\0', sizeof(myAddr));
		sockAddr.sin_family      = AF_INET;
		sockAddr.sin_addr.s_addr = INADDR_ANY;
		sockAddr.sin_port        = htons (portServeur); // Server Port number
		bzero(sockAddr.sin_zero, 8);
		
		err = bind( listenSd, (struct sockaddr*) &sockAddr, sizeof (sockAddr));
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur lors du bind" << endl;
			exit(-1);
		}
		
		// Receive a connection.
		err = listen ( listenSd, 5);
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur a lors du listen " << endl;
			exit(-1);
		}
		
		cout << "[Client] Attente de connexion du client" << endl;
		
		size_t cliLen = sizeof(cliAddr);
		sd = accept ( listenSd, (struct sockaddr*) &cliAddr, &cliLen);
		if ( sd == -1 ) {
			cerr << "[ERREUR] Erreur a lors du accept" << endl;
			exit(-1);
		}
		
		
	}else{			
		cout << "[Client] Connexion au serveur sur " << hoteServeur << ":" << portServeur << endl;
		
		// Create a socket and connect to server using normal socket calls		
		sd = socket (AF_INET, SOCK_STREAM, 0);       
		if ( sd == -1 ) {
			cerr << "[ERREUR] Erreur a lors de la creation de la socket" << endl;
			exit(-1);
		}
		
		memset (&sockAddr, '\0', sizeof(sockAddr));
		sockAddr.sin_family      = AF_INET;
		sockAddr.sin_addr.s_addr = inet_addr (hoteServeur); // Server IP
		sockAddr.sin_port        = htons(portServeur);      // Server Port number
		
		err = connect(sd, (struct sockaddr*) &sockAddr, sizeof(sockAddr));                   
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur a lors du connect" << endl;
			exit(-1);
		}
		
	}

	// TCP connection is ready. Do server side SSL
	ssl = SSL_new (ctx);  
	if ( ssl == NULL) {
		cerr << "[ERREUR] Erreur lors du ssl_new" << endl;
		exit(-1);
	}
	
	// check ca cert
	cout << "[Client] Verification du certificat de l'autorite" << endl;
	err = SSL_get_verify_result(ssl);
	if ( err != X509_V_OK) {
		cerr << "[ERREUR] Le certificat de l'autorite est invalide" << endl;
		exit(-1);
	}
	
	SSL_set_fd (ssl, sd);
	// Get the cipher - opt		
	cout << "[Client] Connection SSL " << SSL_get_cipher (ssl) << endl;
	
	if(isServeur){
		err = SSL_accept (ssl);
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur a lors du ssl_accept" << endl;
			exit(-1);
		}
		
		// Data exchange - Receive message and send reply.
		cout << "[Client] Reception du message" << endl;
		err = SSL_read (ssl, buf, sizeof(buf) - 1); 
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur a lors du ssl_read" << endl;
			exit(-1);
		}
		cout << "[Client] Message recu : " << buf << endl;

		strcpy(buf, "Bien le bonjour, cher client ! Content de vous voir !");
		cout << "[Client] Envoi du message : " << buf << endl;
		err = SSL_write (ssl, buf, strlen(buf));
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur a lors du ssl_write" << endl;
			exit(-1);
		}
		
		// Clean up
		close (sd);
		close (listenSd);
		SSL_free (ssl);
		SSL_CTX_free (ctx);
		
		cout << "[Client] Fin du serveur SSL" << endl;	
	}else{	
		err = SSL_connect (ssl);
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur lors du ssl_connect" << endl;
			exit(-1);
		}

		// DATA EXCHANGE - Send a message and receive a reply
		strcpy(buf, "Bonjour, monsieur serveur !");
		cout << "[Client] Envoi du message : " << buf << endl;
		err = SSL_write (ssl, buf, strlen(buf));  
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur a lors du ssl_write" << endl;
			exit(-1);
		}
		
		cout << "[Client] Reception du message" << endl;
		err = SSL_read (ssl, buf, sizeof(buf) - 1);                     
		if ( err == -1 ) {
			cerr << "[ERREUR] Erreur a lors du ssl_read" << endl;
			exit(-1);
		}
		
		buf[err] = '\0';
		cout << "[Client] Message recu : " << buf << endl;
		SSL_shutdown (ssl);  // send SSL/TLS close_notify
		
		// Clean up		
		close (sd);
		SSL_free (ssl);
		SSL_CTX_free (ctx);
		
		cout << "[Client] Fin du client SSL" << endl;
	}
	

	return 0;
}
