if test $# -ne 2
then
    echo "USAGE : $0 [-c|-s] dir"
    echo "        -c : generation d'une clé pour client"
    echo "        -s : generation du certificat de l'autorité de certification"
    echo "        dir : repertoires où mettre les fichiers généré"
    exit -1
fi

dir=$2

# Génération d'une clé pour le client
if test "$1" = "-c"
then
  mkdir -p $dir/private
  echo "Création de la clé dans $dir/private/key"
  openssl genrsa -out $dir/private/key 1024
  openssl req -new -key $dir/private/key -out $dir/private/req
fi

# Génération du certificat de l'autorité de certification
if test "$1" = "-s"
then
  mkdir -p $dir/CA/private
  mkdir -p $dir/CA/newcerts
  echo "Création du certificat de l'autorité de certification dans $dir/CA/"
  touch $dir/CA/index.txt
  echo 01 >> $dir/CA/serial
  openssl req -x509 -newkey rsa:1024 -keyout $dir/CA/private/privkey.pem -out $dir/CA/cacert.pem
fi
