/*
 ****************************************************************************
 *
 * Programme : pendu.cpp
 *
 * Ecrit par : Beuque Eric
 *
 * Resume : Affiche le vainqueur d'un jeu de pendu entre deux joueurs.
 *
 * Date : 06/12/04
 *
 ****************************************************************************
 */

#include<iostream>
#include<string>
#include<unistd.h>

using namespace std;

bool estMotValide(string mot);
/* Retourne VRAI si un mot ne comporte que des lettres */
bool estCarValide(char car);
/* Retourne VRAI si un caractere est valide */
void lettreMaj(char &car);
/* Converti une lettre en majuscule */
void motMaj(string &mot);
/* Converti un mot en majuscule */
void afficheEcran(int phase, int nbErreur, string mot, int score1, int score2);
/* Affiche sur l'ecran les informations du le jeu */

const int MAX_FAUTES=11;
const char CACHE='-';
const string DESSIN_PENDU[7]={"  _____  ",
			      "  |/  |  ",
			      "  |   O  ",
			      "  |  -+- ",
			      "  |  / \\",
			      "  |      ",
			      " ---     "};
const int VAL_DESSIN[7][9]={{0,0,4,4,4,4,4,0,0},
			     {0,0,2,3,0,0,5,0,0},
			     {0,0,2,0,0,0,6,0,0},
			     {0,0,2,0,0,8,7,9,0},
			     {0,0,2,0,0,10,0,11,0},
			     {0,0,2,0,0,0,0,0,0},
			     {0,1,1,1,0,0,0,0,0}};
const int NB_CASE_TAB=63;

int main()
{
  string mot, motMasque, nouvManche;
  int i, phase, nbErreur;
  int score1, score2;
  char carLu;
  bool carTrouve;
  bool perdu, gagne;
  
  /* Initialisation du jeu */
  score1=0;
  score2=0;
  system("clear");
  /* Instructions pour chaque manche tant que les joueurs veulent
     continuer d'en faire */
  do{
    /* Instructions des phases, il y a deux phases */ 
    for(phase=1;phase<=2;phase++){
      /* intitialisation de la phase de jeu */
      nbErreur=0;
      perdu=false;
      gagne=false;
      /* Demande au premier joueur d'entrer un mot, vrification 
	 de sa validit puis convertion en majuscule */
      cout << "*** Joueur " << phase << " ***" << endl << endl;
      cout << "Veuiller entrer le mot que votre adversaire devra trouver : ";
      cout << endl;
      do{
	cout << endl << "Mot : ";
	cin >> mot;
      }while(!estMotValide(mot));
      motMaj(mot);
      /* Initialisation du mot masqu, et remplacement des caractres du mot
	 par le caractre CACHE */
      motMasque=mot;
      for(i=0;i<=mot.length()-1;i++){
	motMasque[i]=CACHE;
      }
      /* Affichage du jeu sur l'cran */
      afficheEcran(phase,nbErreur,motMasque,score1,score2);
      /* Demande au second joueur d'entrer un lettre, conversion de cette
	 en majuscule */
      do{
	/* Boucle de jeu du joueur cherchant le mot, s'arrte 
	   lorsqu'il a trouv le mot en entier ou lorsque qu'il a atteint
	   le nombre maximum de fautes */ 
	do{
	  cout << "Entrez une lettre : ";
	  cin >> carLu;
	}while(!estCarValide(carLu));
	lettreMaj(carLu);
	/* Recherche du caractre entr dans le mot, s'il est prsent 
	   on l'affiche dans le mot masqu a sa bonne position, sinon 
	   on augmente le nombre d'erreur de 1 */
	carTrouve=false;
	for(i=0;i<=mot.length();i++){
	  if(mot[i]==carLu ){
	    motMasque[i]=carLu;
	    carTrouve=true;
	  }
	}
	if(carTrouve==false){
	  nbErreur=nbErreur+1;
	  /* Si le total de fautes est gale au nombre maximum de fautes 
	     alors le joueur cherchant le mot a perdu la phase */
	  if(nbErreur==MAX_FAUTES){
	    perdu=true;
	  }
	}
	/* Si le mot masqu ne contient plus de caractre CACHE
	   alors le joueur cherchant le mot a gagn la phase */
	gagne=true;
	for(i=0;i<=mot.length()-1;i++){
	  if(motMasque[i]==CACHE){
	    gagne=false;
	  }
	}
	/* Affichage de l'cran du jeu */
	afficheEcran(phase,nbErreur,motMasque,score1,score2);
      }while(perdu==false && gagne==false);
      system("clear");
      /* Ajustement des scores en fonction du rsultat de la phase.
	 Si le joueur a trouv le mot augmente son score.
	 Si le joueur n'a trouv le mot on augmente celui de son
	 adversaire */
      if(gagne==true){
	if(phase==1){
	  cout << "Le joueur 2 gagne la phase 1." << endl;
	  score2=score2+1;
	}else{
	  cout << "Le joueur 1 gagne la phase 2." << endl;
	  score1=score1+1;
	}
      }else{
	if(phase==2){
	  cout << "Le joueur 1 perd la phase 2." << endl;
	  score2=score2+1;
	}else{
	  cout << "Le joueur 2 perd la phase 1." << endl;
	  score1=score1+1;
	}
      }
      cout << endl;
      cout << "Score joueur 1 : " << score1 << endl;
      cout << "Score joueur 2 : " << score2 << endl;
      cout << endl;
    }
    cout <<  "Une autre manche ? (taper 'oui' pour continuer)";
    cin >> nouvManche;
  }while(nouvManche=="oui");
  system("clear");
  /* Affichage des scores et dsignation du vainqueur s'il y en a un
     sinon on dclare le match nul */
  cout << "*** Match termine ***" << endl << endl;
  cout << "Score joueur 1 : " << score1 << endl;
  cout << "Score joueur 2 : " << score2 << endl;
  cout << endl;
  if(score1<score2){
    cout << "Le joueur 2 remporte la partie." << endl;
  }else{
    if(score2<score1){
      cout << "Le joueur 1 remporte la partie." << endl;
    }else{
      cout << "Match nul entre le joueur 1 et le joueur 2." << endl;
    }
  }
}

/*
 * Fonction    : estMotValide
 *
 * Parametres  : string mot (mot  tester)
 *
 * Retour      : booleen
 * 
 * Description : Renvoie true si le mot ne contient que des lettres en
 *               majuscule ou en minuscule et non accentus.
 *
 */
bool estMotValide(string mot)
{
  int i;  
  bool valide;
  
  /* Teste un par un de la validit de chaque caractre */
  valide=true;
  for(i=0;i<mot.length();i++){
    if(!estCarValide(mot[i])){
      valide=false;
    }
  }
  if(valide){
    return(true);
  }else{
    cout << "Le mot entree est invalide. ";
    cout << "Le mot ne doit comporter que des lettres." << endl;
    return(false);
  }
}

/*
 * Fonction    : estCarValide
 *
 * Parametres  : char car (caractre  tester)
 *
 * Retour      : booleen
 * 
 * Description : Renvoie true si le caractre est une lettres en
 *               majuscule ou en minuscule et non accentu.
 *
 */
bool estCarValide(char car)
{
  /* Si le caractre est compris dans l'intervalle {a;z} ou {A;Z}
     alors il est valide */
  if((car>='a' && car<='z') || (car>='A' && car<='Z')){
    return(true);
  }else{
    cout << "Le caractere " << car << " n'est pas une lettre comprisent "; 
    cout << "entre 'a' et 'z' ou entre 'A' et 'Z'. " << endl;
    return(false);
  }
}

/*
 * Fonction    : afficheEcran
 *
 * Parametres  : int phase (numro de la phase en cours)
 *               int nbErreur (nombre d'erreur effectu par le joueur)
 *               string mot (mot  afficher)
 *               int score1 (score du joueur 1)
 *               int score2 (score du joueur 2)
 *
 * Retour      : vide
 * 
 * Description : Affiche l'cran du jeu en fonction des paramtres.
 *
 */
void afficheEcran(int phase, int nbErreur, string mot, int score1, int score2)
{  
  int i, numLig, numCol;
  system("clear");
  cout << "*** Joueur ";
  if(phase==1){
    cout << "2";
  }else{
    cout << "1";
  }
  cout << " ***" << endl << endl;
  cout << "Score joueur 1 : " << score1 << endl;
  cout << "Score joueur 2 : " << score2 << endl;
  cout << endl;
  numLig=0;
  numCol=0;
  for(i=0;i<NB_CASE_TAB;i++){
    if(VAL_DESSIN[numCol][numLig]<=nbErreur){
      cout << DESSIN_PENDU[numCol][numLig];
    }else{
      cout << " ";
    }
    if(numLig==8){
      cout << endl;
      numLig=0;
      numCol=numCol+1;
    }else{
      numLig=numLig+1;
    }
  }
  cout << endl << endl;
  cout << mot << endl << endl;
}

/*
 * Fonction    : lettreMaj
 *
 * Parametres  : char car (car  transformer)
 *
 * Retour      : vide
 * 
 * Description : Si le caractre donn est une lettre en minuscule,
 *               alors il est converti en masjuscule.
 *
 */
void lettreMaj(char &car)
{
  if(car>='a' && car<='z'){
    car=car+'A'-'a';
  }
}

/*
 * Fonction    : motMaj
 *
 * Parametres  : string mot (mot  transformer)
 *
 * Retour      : vide
 * 
 * Description : Transforme chaque lettre minuscule d'un mot en
 *               majuscule.
 *
 */
void motMaj(string &mot)
{
  int i;

  for(i=0;i<mot.length();i++){
    lettreMaj(mot[i]);
  }
}
