using System;
using System.Threading;

public class Test
{
  static void Main(string[] args)
  {
    int mSize;
    int[,] matrix1;
    int[,] matrix2;
    int[,] matrix3;
    int nbThread;

    int i, j;

    if (args.Length < 2) {
      Console.WriteLine("USAGE : m_size nb_threads [-v]");
      Console.WriteLine("        m_size : size of the matrice");
      Console.WriteLine("        nb_threads : number of threads");
      Console.WriteLine("        -v : verbose");
      return;
    }

    // Début du chrono
    DateTime debut = DateTime.Now;

    mSize = Int32.Parse(args[0]);
    nbThread = Int32.Parse(args[1]);

    // Creation des matrices
    matrix1 = new int[mSize,mSize];
    matrix2 = new int[mSize,mSize];
    matrix3 = new int[mSize,mSize];
    for(i=0;i<mSize;i++){
      for(j=0;j<mSize;j++){
        matrix1[i,j] = i+j+1;
        matrix2[i,j] = i+j+1;
        matrix3[i,j] = 0;
      }
    }
    
    ProduitMatrice foo = new ProduitMatrice(mSize, matrix1, matrix2, matrix3);
    ThreadStart job = new ThreadStart(foo.calc);

    Thread[] tab = new Thread[nbThread];

    for (i = 0; i < nbThread; i++) {
      tab[i] = new Thread(job);
      tab[i].Start();
    }
    for (i = 0; i < nbThread; i++) {
      tab[i].Join();
    }

    // Affichage du resultat
    if(args.Length == 3){
        for(i=0;i<mSize;i++){
	        Console.Write("[");
	        for(j=0;j<mSize;j++){
	          Console.Write("["+ matrix3[i,j] + "]");
	        }
	        Console.Write("]\n");
        }
    }

    // Fin du chrono
    DateTime duree = new DateTime(DateTime.Now.Ticks - debut.Ticks);
    double realtime = (duree.Ticks / 10000000.0);
    Console.WriteLine(mSize + ";" + nbThread + ";CSharpThread;" + realtime);
  }
}

public class ProduitMatrice
{
   private int mSize;
   private int current;
   private object synchro = new object();

   private int[,] matrix1, matrix2, matrix3;

   public ProduitMatrice(int m, int[,] m1, int[,] m2, int[,] m3) {
      current=-1;     
      mSize=m;
      matrix1=m1;
      matrix2=m2;
      matrix3=m3;
   }

   public void calc(){
      int i, j, k;
      
      do{

        Monitor.Enter(synchro);
        current++;
        i=current;
        Monitor.Exit(synchro);

        if(i<mSize){
          for(j=0;j<mSize;j++){
	          for(k=0;k<mSize;k++){
	            matrix3[i,j] += matrix1[i,k] * matrix2[k,j];
	          }
          }
        }
      }while(i<mSize);
   }
}

