using System;
using System.Threading;

public class Test
{
  static void Main(string[] args)
  {
    int mSize;
    int[,] matrix1;
    int[,] matrix2;
    int[,] matrix3;

    int i, j, k;

    if (args.Length < 2) {
      Console.WriteLine("USAGE : m_size [anything -v]");
      Console.WriteLine("        m_size : size of the matrice");
      Console.WriteLine("        anything : just write anything");
      Console.WriteLine("        -v : verbose");
      return;
    }

    // Début du chrono
    DateTime debut = DateTime.Now;

    mSize = Int32.Parse(args[0]);

    // Creation des matrices
    matrix1 = new int[mSize,mSize];
    matrix2 = new int[mSize,mSize];
    matrix3 = new int[mSize,mSize];
    for(i=0;i<mSize;i++){
      for(j=0;j<mSize;j++){
        matrix1[i,j] = i+j+1;
        matrix2[i,j] = i+j+1;
        matrix3[i,j] = 0;
      }
    }
    
    for(i=0;i<mSize;i++){    
      for(j=0;j<mSize;j++){
        for(k=0;k<mSize;k++){
	        matrix3[i,j] += matrix1[i,k] * matrix2[k,j];
        }
      }
    }

    // Affichage du resultat
    if(args.Length == 3){
        for(i=0;i<mSize;i++){
	        Console.Write("[");
	        for(j=0;j<mSize;j++){
	          Console.Write("["+ matrix3[i,j] + "]");
	        }
	        Console.Write("]\n");
        }
    }

    // Fin du chrono
    DateTime duree = new DateTime(DateTime.Now.Ticks - debut.Ticks);
    double realtime = (duree.Ticks / 10000000.0);
    Console.WriteLine(mSize + ";1;CSharpNoThread;" + realtime);
  }
}

