package projet.rmi.client;

// Import general de RMI
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;

import projet.rmi.serveur.IServeur;

public class Client extends Thread {
	IServeur serveur;
	static SimpleDateFormat sdf = new SimpleDateFormat("mm:ss,SSS");

	public Client(IServeur serveur) {
		this.serveur = serveur;
	}

	public void run() {
		try {
			Date toutDebut = new Date();
			for (int i = 0; i < 45; i++) {
				Date debut = new Date();
				serveur.fib(i);
				Date duree = new Date(new Date().getTime() - debut.getTime());
				System.out.println(getName() + ";fib(" + i + ");"
						+ sdf.format(duree) + ";");
			}
			Date duree = new Date(new Date().getTime() - toutDebut.getTime());
			System.out.println(getName() + ";Total;" + sdf.format(duree) + ";");
		} catch (RemoteException e) {
			e.printStackTrace();
		}
	}
}
