package projet.rmi;

// Import general de RMI
import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import projet.rmi.client.Client;
import projet.rmi.serveur.IServeur;

public class LanceurRMI2Thread extends Thread {

	public static void main(String[] args) throws InterruptedException,
			NamingException {

		Hashtable<String, String> env = new Hashtable<String, String>(11);
		env.put(Context.INITIAL_CONTEXT_FACTORY,
				"com.sun.jndi.rmi.registry.RegistryContextFactory");
		env.put(Context.PROVIDER_URL, "rmi://127.0.0.1:8888");
		String name = "serveur";
		// Create the initial context
		Context ctx = new InitialContext(env);
		// Look up an object
		IServeur serv = (IServeur) ctx.lookup(name);
		// Print it out
		Client client1 = new Client(serv);

		// Look up an object
		IServeur serv2 = (IServeur) ctx.lookup(name);
		// Print it out
		Client client2 = new Client(serv2);
		client1.setName("C1");
		client2.setName("C2");

		int nbCore = Runtime.getRuntime().availableProcessors();
		String osName = System.getProperty("os.name");
		String osArch = System.getProperty("os.arch");
		System.out.println("configuration;Intel Core 2 Duo T5500;");
		System.out.println("System;" + osName + " " + osArch + ";");
		System.out.println("Core;" + nbCore + ";");

		System.out.println("Test;lancement de 2 threads;");
		client1.start();
		client2.start();

		client1.join();
		client2.join();

		// Close the context when we're done
		ctx.close();

	}
}
