package projet.matrice;

import java.util.Date;
import java.util.LinkedList;

/**
 * Définition de la classe Matrice (Matrix) dans lequel nous trouvons beaucoup
 * de méthodes, d'opérations sur les matrices Remarque : Cette classe est
 * seulement un outils dans le but d'effectuer des calculs sur les graphes. Ceci
 * n'est pas une classe compléte pour la manipulation de matrice.
 * 
 * @author ASLAN Hikmet
 * @version 1.1
 */

public class MatriceThread implements Runnable {
	class OperMutiplication {
		long[] m1;
		long[] m2;
		int ligne;
		int colonne;
		MatriceThread m;

		public OperMutiplication(long[] m1, long[] m2, int ligne, int colonne,
				MatriceThread m) {
			this.m1 = m1;
			this.m2 = m2;
			this.ligne = ligne;
			this.colonne = colonne;
			this.m = m;
		}

		public long multiply() {
			long value = 0;
			for (int j = 0; j < m1.length; j++) {
				value += m2[j] * m1[j];
			}
			return value;
		}
	}

	LinkedList<OperMutiplication> operations =
		new LinkedList<OperMutiplication>();
	int nbOperationNonFinis = 0;
	private long[][] coeff = null;

	int nbThread = 1;

	/**
	 * Constructeur Matrice
	 * 
	 * @param int i - ligne int j - colonne
	 */
	public MatriceThread(int i, int j) {
		this.setLength(i, j);
	}

	public MatriceThread() {
		this(0, 0);
	}

	/**
	 * Constructeur
	 * 
	 * @param mat
	 */
	public MatriceThread(long[][] mat) {
		this.coeff = mat;
	}

	public void setNbThread(int nbThread) {
		synchronized (operations) {
			this.nbThread = nbThread;
			operations.notifyAll();
		}
	}

	private void initThread() {
		if (nbThread <= 0) {
			nbThread = 1;
		}
		for (int i = 0; i < nbThread; i++) {
			Thread thread = new Thread(this, "M x M " + (i + 1));
			thread.start();
		}
	}

	private OperMutiplication next() {
		synchronized (operations) {
			while (operations.size() == 0 && nbThread > 0) {
				try {
					operations.wait();
				} catch (InterruptedException e) {}
			}
			if (nbThread <= 0) {
				return null;
			} else {
				operations.notifyAll();
				return operations.poll();
			}
		}
	}

	public void run() {
		while (nbThread > 0) {
			OperMutiplication oper = next();
			if (oper != null) {
				long value = oper.multiply();
				this.setValue(oper.ligne, oper.colonne, value);
				synchronized (operations) {
					nbOperationNonFinis--;
					operations.notifyAll();
				}
			}
		}
	}

	/**
	 * Définit une matrice de type long[][]
	 * 
	 * @param mat
	 */
	public void setMatrice(long[][] mat) {
		this.coeff = mat;
	}

	/**
	 * définit une valeur Ã la position i et j
	 * 
	 * @param i Ligne
	 * @param j Colonne
	 * @param value
	 */
	public void setValue(int i, int j, long value) {
		this.coeff[i][j] = value;
	}

	/**
	 * on définit la taille de la mtrice
	 * 
	 * @param i
	 * @param j
	 */
	public void setLength(int i, int j) {
		this.coeff = new long[i][j];
	}

	/**
	 * retourne la matrice sous forme du type long[][]
	 * 
	 * @return
	 */
	public long[][] getMatrice() {
		return this.coeff;
	}

	/**
	 * retourne le nombre de ligne
	 * 
	 * @return
	 */
	public int getRows() {
		return this.coeff.length;
	}

	/**
	 * retourne le nombre de colonne
	 * 
	 * @return
	 */
	public int getColumns() {
		return this.coeff[0].length;
	}

	/**
	 * retourne la valeur Ã la position i et j
	 * 
	 * @param i
	 * @param j
	 * @return
	 */
	public long getValue(int i, int j) {
		return this.coeff[i][j];
	}

	/**
	 * Multiplication d'une matrice par une autre
	 * 
	 * @param matrice
	 * @return
	 */
	public MatriceThread multiply(final MatriceThread matrice) {
		MatriceThread a = new MatriceThread(this.getRows(), this.getColumns());
		int k, i;
		initThread();
		nbOperationNonFinis = 0;

		for (k = 0; k < matrice.getColumns(); k++) {
			// long[] colonne = new long[matrice.getRows()];
			long[] colonne = matrice.coeff[k];
			// for (i = 0; i < matrice.getRows(); i++) {
			// colonne[i] = matrice.getValue(i, k);
			// }
			synchronized (operations) {
				for (i = 0; i < this.getRows(); i++) {
					nbOperationNonFinis++;
					operations.add(new OperMutiplication(coeff[i], colonne, i,
						k, a));
					operations.notifyAll();
				}
			}
		}
		synchronized (operations) {
			while (nbOperationNonFinis != 0) {
				try {
					operations.wait();
				} catch (InterruptedException e) {}
			}
			// Arrete les threads
			setNbThread(0);
		}

		return a;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		String out = "";
		for (int i = 0; i < this.getRows(); i++) {
			for (int j = 0; j < this.getColumns(); j++) {
				out += this.coeff[i][j] + "\t ";
			}
			out += "\n";
		}
		return out;
	}

	/**
	 * definit si deux matrices sont équivalentes
	 * 
	 * @param matrice
	 * @return
	 */
	public boolean equals(MatriceThread matrice) {
		for (int i = 0; i < this.getRows(); i++) {
			for (int j = 0; j < this.getColumns(); j++) {
				if (this.getValue(i, j) != matrice.getValue(i, j)) {
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * Main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		int n;
		int nbThread;

		if (args.length < 2) {
			System.out.println("USAGE : n_fibo nb_threads\n"
				+ "        n_fibo : an integer\n"
				+ "        n_threads : an integer\n");
			return;
		}

		n = Integer.parseInt(args[0]);
		nbThread = Integer.parseInt(args[1]);

		// matrice d'adjacence d'un graphe
		MatriceThread a = new MatriceThread(n, n);
		int v = 0;
		for (int i = 0; i < n; i++) {
			v = i;
			for (int j = 0; j < n; j++) {
				a.setValue(i, j, v);
				v++;
			}
		}
		a.setNbThread(nbThread);

		// Début du chrono
		Date debut = new Date();

		a.multiply(a);

		// Fin du chrono
		Date duree = new Date(new Date().getTime() - debut.getTime());
		double realtime = (duree.getTime() / 1000.0);
		System.out.println(n + ";" + nbThread + ";JavaThread;" + realtime);

	}
}