#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <omp.h>

#include <sys/time.h>

int
fibo(int n)
{
  if(n <= 1){
    /* cas de base */
    return n; /* si n=0 return 0 si n=1 return 1 */
  } else {
    return fibo(n - 1) + fibo(n - 2); 
  }
}


int main(int argc, char **argv) {
  
  struct timeval tv_start, tv_finish;
  double realtime;

  int n_fibo;
  int nb_threads;

  if(argc < 3){
    printf("USAGE : %s n_fibo nb_threads\n        n_fibo : an integer\n        n_threads : an integer\n", argv[0]);
    return -1;
  }
  
  /* Depart du chrono */
  gettimeofday(&tv_start, 0);

  n_fibo=atoi(argv[1]);
  nb_threads=atoi(argv[2]);

  omp_set_num_threads(nb_threads);
  
#pragma omp parallel shared(n_fibo)
  {
    fibo(n_fibo);
  }
  
  /* Fin du chrono */
  gettimeofday(&tv_finish, 0);
  
  /* Affichage du resultat */
  realtime = (double)(tv_finish.tv_sec-tv_start.tv_sec) +
    ((double)(tv_finish.tv_usec-tv_start.tv_usec))*1e-6;
  printf("%d;%d;c_openmp;%f\n", n_fibo, nb_threads, realtime);
  
  return 0;
}
