/*
 * Decompiled with CFR 0.152.
 */
package extra166y;

import extra166y.AbstractParallelAnyArray;
import extra166y.Ops;
import extra166y.PAS;
import extra166y.ParallelArrayWithMapping;
import extra166y.ParallelDoubleArrayWithDoubleMapping;
import extra166y.ParallelLongArrayWithBounds;
import extra166y.ParallelLongArrayWithDoubleMapping;
import extra166y.ParallelLongArrayWithFilter;
import extra166y.ParallelLongArrayWithLongMapping;
import extra166y.ParallelLongArrayWithMapping;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;

public class ParallelLongArray
extends AbstractParallelAnyArray.LUPap {
    AsList listView;

    public static ForkJoinPool defaultExecutor() {
        return PAS.defaultExecutor();
    }

    protected ParallelLongArray(ForkJoinPool executor, long[] array, int limit) {
        super(executor, 0, limit, array);
        if (executor == null || array == null) {
            throw new NullPointerException();
        }
        if (limit < 0 || limit > array.length) {
            throw new IllegalArgumentException();
        }
    }

    ParallelLongArray(ForkJoinPool executor, long[] array) {
        super(executor, 0, array.length, array);
    }

    public static ParallelLongArray create(int size, ForkJoinPool executor) {
        long[] array = new long[size];
        return new ParallelLongArray(executor, array, size);
    }

    public static ParallelLongArray createUsingHandoff(long[] handoff, ForkJoinPool executor) {
        return new ParallelLongArray(executor, handoff, handoff.length);
    }

    public static ParallelLongArray createFromCopy(long[] source, ForkJoinPool executor) {
        int size = source.length;
        long[] array = new long[size];
        System.arraycopy(source, 0, array, 0, size);
        return new ParallelLongArray(executor, array, size);
    }

    public static ParallelLongArray createFromCopy(int size, long[] source, ForkJoinPool executor) {
        long[] array = new long[size];
        System.arraycopy(source, 0, array, 0, Math.min(source.length, size));
        return new ParallelLongArray(executor, array, size);
    }

    public static ParallelLongArray createEmpty(int size, ForkJoinPool executor) {
        long[] array = new long[size];
        return new ParallelLongArray(executor, array, 0);
    }

    public ForkJoinPool getExecutor() {
        return this.ex;
    }

    @Override
    public void apply(Ops.LongProcedure procedure) {
        super.apply(procedure);
    }

    @Override
    public long reduce(Ops.LongReducer reducer, long base) {
        return super.reduce(reducer, base);
    }

    @Override
    public ParallelLongArray all() {
        return super.all();
    }

    @Override
    public ParallelLongArray replaceWithMapping(Ops.LongOp op) {
        super.replaceWithMapping(op);
        return this;
    }

    @Override
    public ParallelLongArray replaceWithMappedIndex(Ops.IntToLong op) {
        super.replaceWithMappedIndex(op);
        return this;
    }

    @Override
    public ParallelLongArray replaceWithMappedIndex(Ops.IntAndLongToLong op) {
        super.replaceWithMappedIndex(op);
        return this;
    }

    @Override
    public ParallelLongArray replaceWithGeneratedValue(Ops.LongGenerator generator) {
        super.replaceWithGeneratedValue(generator);
        return this;
    }

    @Override
    public ParallelLongArray replaceWithValue(long value) {
        super.replaceWithValue(value);
        return this;
    }

    @Override
    public ParallelLongArray replaceWithMapping(Ops.BinaryLongOp combiner, ParallelLongArrayWithLongMapping other) {
        super.replaceWithMapping(combiner, other);
        return this;
    }

    @Override
    public ParallelLongArray replaceWithMapping(Ops.BinaryLongOp combiner, long[] other) {
        super.replaceWithMapping(combiner, other);
        return this;
    }

    @Override
    public int indexOf(long target) {
        return super.indexOf(target);
    }

    @Override
    public int binarySearch(long target) {
        return super.binarySearch(target);
    }

    @Override
    public int binarySearch(long target, Ops.LongComparator comparator) {
        return super.binarySearch(target, comparator);
    }

    @Override
    public SummaryStatistics summary(Ops.LongComparator comparator) {
        return super.summary(comparator);
    }

    @Override
    public SummaryStatistics summary() {
        return super.summary();
    }

    @Override
    public long min(Ops.LongComparator comparator) {
        return super.min(comparator);
    }

    @Override
    public long min() {
        return super.min();
    }

    @Override
    public long max(Ops.LongComparator comparator) {
        return super.max(comparator);
    }

    @Override
    public long max() {
        return super.max();
    }

    @Override
    public ParallelLongArray cumulate(Ops.LongReducer reducer, long base) {
        super.cumulate(reducer, base);
        return this;
    }

    @Override
    public long precumulate(Ops.LongReducer reducer, long base) {
        return super.precumulate(reducer, base);
    }

    @Override
    public ParallelLongArray sort(Ops.LongComparator comparator) {
        super.sort(comparator);
        return this;
    }

    @Override
    public ParallelLongArray sort() {
        super.sort();
        return this;
    }

    public ParallelLongArray removeConsecutiveDuplicates() {
        int k = 0;
        int n = this.fence;
        if (k < n) {
            long[] arr = this.array;
            long last = arr[k++];
            for (int i = k; i < n; ++i) {
                long x = arr[i];
                if (last == x) continue;
                arr[k++] = last = x;
            }
            this.removeSlotsAt(k, n);
        }
        return this;
    }

    public ParallelLongArray addAll(long[] other) {
        int csize = other.length;
        int end = this.fence;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other, 0, this.array, end, csize);
        return this;
    }

    public ParallelLongArray addAll(ParallelLongArrayWithLongMapping other) {
        int end = this.fence;
        if (other.hasFilter()) {
            PAS.FJLAppendAllDriver r = new PAS.FJLAppendAllDriver(other, end, this.array);
            this.ex.invoke((ForkJoinTask)r);
            this.array = r.results;
            this.fence = end + r.resultSize;
        } else {
            int csize = other.size();
            this.insertSlotsAt(end, csize);
            if (other.hasMap()) {
                this.ex.invoke((ForkJoinTask)new PAS.FJLMap(other, other.origin, other.fence, null, this.array, end - other.origin));
            } else {
                System.arraycopy(other.array, 0, this.array, end, csize);
            }
        }
        return this;
    }

    @Override
    public ParallelLongArray allUniqueElements() {
        return super.allUniqueElements();
    }

    public ParallelLongArray removeAll(Ops.LongPredicate selector) {
        AbstractParallelAnyArray.LFPap v = new AbstractParallelAnyArray.LFPap(this.ex, 0, this.fence, this.array, selector);
        PAS.FJRemoveAllDriver f = new PAS.FJRemoveAllDriver(v, 0, this.fence);
        this.ex.invoke((ForkJoinTask)f);
        this.removeSlotsAt(f.offset, this.fence);
        return this;
    }

    @Override
    public boolean hasAllEqualElements(ParallelLongArrayWithLongMapping other) {
        return super.hasAllEqualElements(other);
    }

    @Override
    public long sum() {
        return super.sum();
    }

    @Override
    public ParallelLongArray cumulateSum() {
        super.cumulateSum();
        return this;
    }

    @Override
    public long precumulateSum() {
        return super.precumulateSum();
    }

    @Override
    public ParallelLongArrayWithBounds withBounds(int firstIndex, int upperBound) {
        return super.withBounds(firstIndex, upperBound);
    }

    @Override
    public ParallelLongArrayWithFilter withFilter(Ops.LongPredicate selector) {
        return super.withFilter(selector);
    }

    @Override
    public ParallelLongArrayWithFilter withFilter(Ops.BinaryLongPredicate selector, ParallelLongArrayWithLongMapping other) {
        return super.withFilter(selector, other);
    }

    @Override
    public ParallelLongArrayWithFilter withIndexedFilter(Ops.IntAndLongPredicate selector) {
        return super.withIndexedFilter(selector);
    }

    @Override
    public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
        return super.withMapping(op);
    }

    @Override
    public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
        return super.withMapping(op);
    }

    @Override
    public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
        return super.withMapping(op);
    }

    @Override
    public <V, W, X> ParallelLongArrayWithMapping<W> withMapping(Ops.LongAndObjectToObject<? super V, ? extends W> combiner, ParallelArrayWithMapping<X, V> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V> ParallelLongArrayWithMapping<V> withMapping(Ops.LongAndDoubleToObject<? extends V> combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V> ParallelLongArrayWithMapping<V> withMapping(Ops.LongAndLongToObject<? extends V> combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V, W> ParallelLongArrayWithDoubleMapping withMapping(Ops.LongAndObjectToDouble<? super V> combiner, ParallelArrayWithMapping<W, V> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongAndDoubleToDouble combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongAndLongToDouble combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V, W> ParallelLongArrayWithLongMapping withMapping(Ops.LongAndObjectToLong<? super V> combiner, ParallelArrayWithMapping<W, V> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelLongArrayWithLongMapping withMapping(Ops.LongAndDoubleToLong combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelLongArrayWithLongMapping withMapping(Ops.BinaryLongOp combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    public <U> ParallelLongArrayWithMapping<U> withIndexedMapping(Ops.IntAndLongToObject<? extends U> mapper) {
        return super.withIndexedMapping(mapper);
    }

    @Override
    public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
        return super.withIndexedMapping(mapper);
    }

    @Override
    public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
        return super.withIndexedMapping(mapper);
    }

    public Iterator<Long> iterator() {
        return new ParallelLongArrayIterator(this.array, this.fence);
    }

    public List<Long> asList() {
        AsList lv = this.listView;
        if (lv == null) {
            this.listView = lv = new AsList();
        }
        return lv;
    }

    @Override
    public int size() {
        return this.fence;
    }

    public long[] getArray() {
        return this.array;
    }

    public long get(int i) {
        return this.array[i];
    }

    public void set(int i, long x) {
        this.array[i] = x;
    }

    public String toString() {
        return this.asList().toString();
    }

    public final void setLimit(int newLimit) {
        if (newLimit < 0) {
            throw new IllegalArgumentException();
        }
        int cap = this.array.length;
        if (newLimit > cap) {
            this.resizeArray(newLimit);
        }
        this.fence = newLimit;
    }

    final void replaceElementsParallelLongArrayWith(long[] a) {
        System.arraycopy(a, 0, this.array, 0, a.length);
        this.fence = a.length;
    }

    final void resizeArray(int newCap) {
        int cap = this.array.length;
        if (newCap > cap) {
            long[] a = new long[newCap];
            System.arraycopy(this.array, 0, a, 0, cap);
            this.array = a;
        }
    }

    final void insertElementAt(int index, long e) {
        int hi;
        if ((hi = this.fence++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        if (hi > index) {
            System.arraycopy(this.array, index, this.array, index + 1, hi - index);
        }
        this.array[index] = e;
    }

    final void appendElement(long e) {
        int hi;
        if ((hi = this.fence++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        this.array[hi] = e;
    }

    final void insertSlotsAt(int index, int len) {
        if (len <= 0) {
            return;
        }
        int cap = this.array.length;
        int newSize = this.fence + len;
        if (cap < newSize) {
            if ((cap = cap * 3 / 2 + 1) < newSize) {
                cap = newSize;
            }
            this.resizeArray(cap);
        }
        if (index < this.fence) {
            System.arraycopy(this.array, index, this.array, index + len, this.fence - index);
        }
        this.fence = newSize;
    }

    final void removeSlotAt(int index) {
        System.arraycopy(this.array, index + 1, this.array, index, this.fence - index - 1);
        --this.fence;
    }

    final void removeSlotsAt(int fromIndex, int toIndex) {
        if (fromIndex < toIndex) {
            int newSize;
            int size = this.fence;
            System.arraycopy(this.array, toIndex, this.array, fromIndex, size - toIndex);
            this.fence = newSize = size - (toIndex - fromIndex);
        }
    }

    final int seqIndexOf(long target) {
        long[] arr = this.array;
        int end = this.fence;
        for (int i = 0; i < end; ++i) {
            if (target != arr[i]) continue;
            return i;
        }
        return -1;
    }

    final int seqLastIndexOf(long target) {
        long[] arr = this.array;
        for (int i = this.fence - 1; i >= 0; --i) {
            if (target != arr[i]) continue;
            return i;
        }
        return -1;
    }

    final class AsList
    extends AbstractList<Long>
    implements RandomAccess {
        AsList() {
        }

        @Override
        public Long get(int i) {
            if (i >= ParallelLongArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            return ParallelLongArray.this.array[i];
        }

        @Override
        public Long set(int i, Long x) {
            if (i >= ParallelLongArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            long[] arr = ParallelLongArray.this.array;
            Long t = arr[i];
            arr[i] = x;
            return t;
        }

        @Override
        public boolean isEmpty() {
            return ParallelLongArray.this.fence == 0;
        }

        @Override
        public int size() {
            return ParallelLongArray.this.fence;
        }

        @Override
        public Iterator<Long> iterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<Long> listIterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<Long> listIterator(int index) {
            if (index < 0 || index > ParallelLongArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            return new ListIter(index);
        }

        @Override
        public boolean add(Long e) {
            ParallelLongArray.this.appendElement(e);
            return true;
        }

        @Override
        public void add(int index, Long e) {
            if (index < 0 || index > ParallelLongArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            ParallelLongArray.this.insertElementAt(index, e);
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            int hi = ParallelLongArray.this.fence;
            ParallelLongArray.this.setLimit(hi + csize);
            long[] arr = ParallelLongArray.this.array;
            for (Long l : c) {
                arr[hi++] = l;
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            if (index < 0 || index > ParallelLongArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            ParallelLongArray.this.insertSlotsAt(index, csize);
            long[] arr = ParallelLongArray.this.array;
            for (Long l : c) {
                arr[index++] = l;
            }
            return true;
        }

        @Override
        public void clear() {
            ParallelLongArray.this.fence = 0;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Long)) {
                return false;
            }
            int idx = ParallelLongArray.this.seqIndexOf((Long)o);
            if (idx < 0) {
                return false;
            }
            ParallelLongArray.this.removeSlotAt(idx);
            return true;
        }

        @Override
        public Long remove(int index) {
            Long oldValue = this.get(index);
            ParallelLongArray.this.removeSlotAt(index);
            return oldValue;
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            ParallelLongArray.this.removeSlotsAt(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Long)) {
                return false;
            }
            return ParallelLongArray.this.seqIndexOf((Long)o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof Long)) {
                return -1;
            }
            return ParallelLongArray.this.seqIndexOf((Long)o);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!(o instanceof Long)) {
                return -1;
            }
            return ParallelLongArray.this.seqLastIndexOf((Long)o);
        }
    }

    final class ListIter
    implements ListIterator<Long> {
        int cursor;
        int lastRet;
        long[] arr;
        int hi;

        ListIter(int lo) {
            this.cursor = lo;
            this.lastRet = -1;
            this.arr = ParallelLongArray.this.array;
            this.hi = ParallelLongArray.this.fence;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public Long next() {
            int i = this.cursor;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            long next = this.arr[i];
            this.lastRet = i;
            this.cursor = i + 1;
            return next;
        }

        @Override
        public void remove() {
            int k = this.lastRet;
            if (k < 0) {
                throw new IllegalStateException();
            }
            ParallelLongArray.this.removeSlotAt(k);
            this.hi = ParallelLongArray.this.fence;
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public Long previous() {
            int i = this.cursor - 1;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            long previous = this.arr[i];
            this.lastRet = this.cursor = i;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(Long e) {
            int i = this.lastRet;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            this.arr[i] = e;
        }

        @Override
        public void add(Long e) {
            int i = this.cursor;
            ParallelLongArray.this.insertElementAt(i, e);
            this.arr = ParallelLongArray.this.array;
            this.hi = ParallelLongArray.this.fence;
            this.lastRet = -1;
            this.cursor = i + 1;
        }
    }

    static final class ParallelLongArrayIterator
    implements Iterator<Long> {
        int cursor;
        final long[] arr;
        final int hi;

        ParallelLongArrayIterator(long[] a, int limit) {
            this.arr = a;
            this.hi = limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public Long next() {
            if (this.cursor >= this.hi) {
                throw new NoSuchElementException();
            }
            return this.arr[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface SummaryStatistics {
        public int size();

        public long min();

        public long max();

        public int indexOfMin();

        public int indexOfMax();

        public long sum();

        public double average();
    }
}

