/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import jsr166y.forkjoin.ForkJoinPool;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.ForkJoinWorkerThread;

final class Submission<V>
extends ForkJoinTask<V>
implements Future<V> {
    static final int INITIAL = 0;
    static final int RUNNING = 1;
    static final int DONE = 2;
    private final ForkJoinTask<V> task;
    private final ForkJoinPool pool;
    private final Sync sync;
    private V result;

    Submission(ForkJoinTask<V> t, ForkJoinPool p) {
        this.task = t;
        this.pool = p;
        this.sync = new Sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask() {
        try {
            if (this.sync.transitionToRunning()) {
                this.pool.submissionStarting();
                if (this.status >= 0) {
                    this.result = this.task.forkJoin();
                    this.setDone();
                }
            }
        }
        catch (Throwable rex) {
            this.setDoneExceptionally(rex);
        }
        finally {
            if (this.sync.transitionToDone() == 1) {
                this.pool.submissionCompleted();
            }
        }
    }

    @Override
    public V forkJoin() {
        this.runTask();
        return this.reportAsForkJoinResult();
    }

    @Override
    final boolean exec() {
        this.runTask();
        return this.completedNormally();
    }

    @Override
    public V rawResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        try {
            if (!this.sync.isDone()) {
                this.setCancelled();
                this.task.cancel();
            }
        }
        finally {
            if (this.sync.transitionToDone() == 1) {
                this.pool.submissionCompleted();
            }
        }
    }

    @Override
    public boolean cancel(boolean ignore) {
        this.cancel();
        return this.isCancelled();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            this.quietlyJoin();
        }
        this.sync.acquireSharedInterruptibly(1);
        return this.reportAsFutureResult();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            if (!((ForkJoinWorkerThread)t).doTimedJoinTask(this, nanos)) {
                throw new TimeoutException();
            }
            this.sync.acquireSharedInterruptibly(1);
        } else if (!this.sync.tryAcquireSharedNanos(1, nanos)) {
            throw new TimeoutException();
        }
        return this.reportAsFutureResult();
    }

    public V awaitInvoke() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            this.quietlyJoin();
        }
        this.sync.acquireShared(1);
        return this.reportAsForkJoinResult();
    }

    @Override
    public void reinitialize() {
        this.result = null;
        this.sync.reset();
        super.reinitialize();
    }

    ForkJoinTask<V> getSubmittedTask() {
        return this.task;
    }

    void finishTask(V value) {
        if (this.sync.transitionToRunning()) {
            this.pool.submissionStarting();
        }
        this.result = value;
        this.setDone();
        if (this.sync.transitionToDone() == 1) {
            this.pool.submissionCompleted();
        }
    }

    void finishTaskExceptionally(Throwable rex) {
        if (this.sync.transitionToRunning()) {
            this.pool.submissionStarting();
        }
        this.setDoneExceptionally(rex);
        if (this.sync.transitionToDone() == 1) {
            this.pool.submissionCompleted();
        }
    }

    static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4982264981922014374L;

        Sync() {
        }

        @Override
        public int tryAcquireShared(int acquires) {
            return this.getState() == 2 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int releases) {
            return true;
        }

        public void reset() {
            this.setState(0);
        }

        public boolean isDone() {
            return this.getState() == 2;
        }

        public boolean transitionToRunning() {
            return this.compareAndSetState(0, 1);
        }

        public int transitionToDone() {
            int c;
            while ((c = this.getState()) != 2 && !this.compareAndSetState(c, 2)) {
            }
            this.releaseShared(0);
            return c;
        }
    }
}

