/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import jsr166y.forkjoin.ForkJoinPool;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.RecursiveAction;
import jsr166y.forkjoin.RunState;
import jsr166y.forkjoin.Submission;
import sun.misc.Unsafe;

public class ForkJoinWorkerThread
extends Thread {
    private static final int INITIAL_QUEUE_CAPACITY = 8192;
    private static final int MAXIMUM_QUEUE_CAPACITY = 0x40000000;
    private static final Random randomSeedGenerator = new Random();
    private final RunState runState;
    private final ForkJoinPool pool;
    private ForkJoinTask<?>[] queue;
    private int sp;
    private volatile int base;
    private int scans;
    private int randomVictimSeed;
    private int stealCount;
    private volatile long fullStealCount;
    private long juRandomSeed;
    private long eventCount;
    private int poolIndex;
    private int pad0;
    private int pad1;
    private int pad2;
    private int pad3;
    private int pad4;
    private int pad5;
    private int pad6;
    private int pad7;
    private int pad8;
    private int pad9;
    private int pada;
    private int padb;
    private int padc;
    private int padd;
    private int pade;
    private int padf;
    private static final int PROBES_PER_PAUSE = 1024;
    private static final int SCANS_PER_PAUSE = 1024 / Runtime.getRuntime().availableProcessors();
    static final long JURandomMultiplier = 25214903917L;
    static final long JURandomAddend = 11L;
    static final long JURandomMask = 0xFFFFFFFFFFFFL;
    static final Unsafe _unsafe;
    static final long baseOffset;
    static final long spOffset;
    static final long qBase;
    static final int qShift;

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        if (pool == null) {
            throw new NullPointerException();
        }
        this.pool = pool;
        this.runState = new RunState();
        this.scans = 1;
        int rseed = randomSeedGenerator.nextInt();
        this.randomVictimSeed = rseed == 0 ? 1 : rseed;
        this.juRandomSeed = randomSeedGenerator.nextLong();
    }

    final void setWorkerPoolIndex(int i) {
        this.poolIndex = i;
    }

    final int getWorkerPoolIndex() {
        return this.poolIndex;
    }

    final RunState getRunState() {
        return this.runState;
    }

    final long getWorkerStealCount() {
        return this.fullStealCount + (long)this.stealCount;
    }

    private final void setSp(int s) {
        _unsafe.putOrderedInt(this, spOffset, s);
    }

    private static final void setSlot(ForkJoinTask<?>[] q, int i, ForkJoinTask<?> t) {
        _unsafe.putOrderedObject(q, (long)(i << qShift) + qBase, t);
    }

    private static final boolean casSlotNull(ForkJoinTask<?>[] q, int i, ForkJoinTask<?> t) {
        return _unsafe.compareAndSwapObject(q, (long)(i << qShift) + qBase, t, null);
    }

    final int getQueueSize() {
        int n = this.sp - this.base;
        return n < 0 ? 0 : n;
    }

    final void pushTask(ForkJoinTask<?> t) {
        ForkJoinTask<?>[] q = this.queue;
        int mask = q.length - 1;
        int s = this.sp;
        this.setSp(s + 1);
        ForkJoinWorkerThread.setSlot(q, s & mask, t);
        if (mask <= s + 1 - this.base) {
            this.growQueue();
        }
    }

    private final ForkJoinTask<?> deqTask() {
        int i;
        ForkJoinTask<?> t;
        int b = this.base;
        ForkJoinTask<?>[] q = this.queue;
        if (b - this.sp < 0 && q != null && (t = q[i = b & q.length - 1]) != null && ForkJoinWorkerThread.casSlotNull(q, i, t)) {
            this.base = b + 1;
            return t;
        }
        return null;
    }

    final ForkJoinTask<?> popTask() {
        int i;
        ForkJoinTask<?> t;
        int s;
        ForkJoinTask<?>[] q = this.queue;
        if (q != null && (s = this.sp - 1) - this.base >= 0 && (t = q[i = s & q.length - 1]) != null && ForkJoinWorkerThread.casSlotNull(q, i, t)) {
            this.setSp(s);
            return t;
        }
        return null;
    }

    private final ForkJoinTask<?> expectedPopTask() {
        ForkJoinTask<?> t;
        int s;
        int i;
        ForkJoinTask<?>[] q = this.queue;
        if (q != null && ForkJoinWorkerThread.casSlotNull(q, i = q.length - 1 & (s = this.sp - 1), t = q[i]) && t != null) {
            this.setSp(s);
            return t;
        }
        return null;
    }

    final boolean popIfNext(ForkJoinTask<?> t) {
        int s;
        ForkJoinTask<?>[] q = this.queue;
        if (t != null && q != null && ForkJoinWorkerThread.casSlotNull(q, q.length - 1 & (s = this.sp - 1), t)) {
            this.setSp(s);
            return true;
        }
        return false;
    }

    final ForkJoinTask<?> peekTask() {
        ForkJoinTask<?>[] q = this.queue;
        return q == null ? null : q[this.sp - 1 & q.length - 1];
    }

    private final void growQueue() {
        ForkJoinTask<?>[] oldQ = this.queue;
        int oldSize = oldQ.length;
        int newSize = oldSize << 1;
        if (newSize > 0x40000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        this.queue = new ForkJoinTask[newSize];
        ForkJoinTask[] newQ = this.queue;
        int b = this.base;
        int bf = b + oldSize;
        int oldMask = oldSize - 1;
        int newMask = newSize - 1;
        do {
            int oldIndex;
            ForkJoinTask<?> t;
            if ((t = oldQ[oldIndex = b & oldMask]) != null && !ForkJoinWorkerThread.casSlotNull(oldQ, oldIndex, t)) {
                t = null;
            }
            ForkJoinWorkerThread.setSlot(newQ, b & newMask, t);
        } while (++b != bf);
    }

    private final void ensureActive() {
        if (this.scans != 0) {
            this.scans = 0;
            this.pool.incrementActiveCount();
        }
    }

    private final boolean tryActivate() {
        if (this.scans != 0) {
            if (!this.pool.tryIncrementActiveCount()) {
                return false;
            }
            this.scans = 0;
        }
        return true;
    }

    private final void ensureInactive() {
        if (this.scans == 0) {
            this.scans = 1;
            this.pool.decrementActiveCount();
        }
    }

    private final boolean tryInactivate() {
        int sc;
        if (this.scans == 0 && !this.pool.tryDecrementActiveCount()) {
            return false;
        }
        ++this.scans;
        if (this.pool.getActiveThreadCount() != 0) {
            if (this.scans >= SCANS_PER_PAUSE) {
                this.scans = 1;
                this.pauseAwaitingWork(null);
            }
            return false;
        }
        if (this.sp != 0) {
            this.setSp(0);
            this.base = 0;
        }
        if ((sc = this.stealCount) != 0) {
            long fsc = this.fullStealCount + (long)sc;
            this.stealCount = 0;
            this.fullStealCount = fsc;
        }
        this.eventCount = this.pool.barrierSync(this.eventCount);
        return true;
    }

    private final void pauseAwaitingWork(ForkJoinTask<?> joinMe) {
        if (this.runState.isAtLeastStopping()) {
            if (joinMe != null) {
                joinMe.cancel();
            }
        } else {
            Thread.yield();
        }
    }

    protected void onStart() {
        this.eventCount = this.pool.barrierSync(0L);
        if (this.queue == null) {
            this.queue = new ForkJoinTask[8192];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTermination(Throwable exception) {
        try {
            this.clearLocalTasks();
            this.ensureInactive();
            this.cancelTasks();
            this.runState.transitionToTerminated();
        }
        finally {
            this.pool.workerTerminated(this, exception);
        }
    }

    @Override
    public void run() {
        try {
            this.onStart();
            this.mainLoop();
            this.onTermination(null);
        }
        catch (Throwable ex) {
            this.onTermination(ex);
        }
    }

    private final void mainLoop() {
        boolean preferSubmission = true;
        while (this.runState.isRunning()) {
            if (!(!preferSubmission && this.runStolenTask() || this.runSubmission())) {
                preferSubmission = !preferSubmission && this.tryInactivate();
                continue;
            }
            this.runLocalTasks();
            preferSubmission = false;
        }
    }

    private final void runLocalTasks() {
        ForkJoinTask<?> t;
        while ((t = this.expectedPopTask()) != null) {
            t.exec();
        }
    }

    private final boolean runStolenTask() {
        ForkJoinTask<?> t = this.getStolenTask();
        if (t != null) {
            t.exec();
            return true;
        }
        return false;
    }

    private final boolean runSubmission() {
        Submission<?> s = this.getSubmission();
        if (s != null) {
            s.exec();
            return true;
        }
        return false;
    }

    private final Submission<?> getSubmission() {
        while (this.pool.mayHaveQueuedSubmissions()) {
            Submission<?> s;
            if (!this.tryActivate() || (s = this.pool.pollSubmission()) == null) continue;
            return s;
        }
        return null;
    }

    private final boolean runLocalTask() {
        ForkJoinTask<?> t = this.popTask();
        if (t != null) {
            t.exec();
            return true;
        }
        return false;
    }

    private final ForkJoinTask<?> getLocalOrStolenTask() {
        ForkJoinTask<?> t = this.popTask();
        return t != null ? t : this.getStolenTask();
    }

    private final boolean runLocalOrStolenTask() {
        ForkJoinTask<?> t = this.getLocalOrStolenTask();
        if (t != null) {
            t.exec();
            return true;
        }
        return false;
    }

    private final void runUntilQuiescent() {
        while (true) {
            ForkJoinTask<?> t;
            if ((t = this.getLocalOrStolenTask()) != null) {
                this.ensureActive();
                t.exec();
                continue;
            }
            this.ensureInactive();
            if (this.pool.getActiveThreadCount() == 0) break;
        }
        this.ensureActive();
    }

    private static final int xorShift(int r) {
        r ^= r << 1;
        r ^= r >>> 3;
        return r ^ r << 10;
    }

    private final ForkJoinTask<?> getStolenTask() {
        int r;
        ForkJoinWorkerThread[] ws = this.pool.workers;
        int mask = ws.length - 1;
        int probes = -mask;
        int idx = r = this.randomVictimSeed;
        ForkJoinTask<?> t = null;
        do {
            ForkJoinWorkerThread v = ws[mask & idx];
            r = ForkJoinWorkerThread.xorShift(r);
            if (v != null && v.base - v.sp < 0) {
                if (this.tryActivate() && (t = v.deqTask()) != null) {
                    this.randomVictimSeed = r;
                    ++this.stealCount;
                    break;
                }
                probes = -mask;
                idx = r;
                continue;
            }
            int n = idx = probes < 0 ? r : idx + 1;
        } while (probes++ <= mask);
        return t;
    }

    private final ForkJoinTask<?> scanWhileJoining(ForkJoinTask<?> joinMe) {
        int r;
        ForkJoinWorkerThread[] ws = this.pool.workers;
        int mask = ws.length - 1;
        int idx = r = this.randomVictimSeed;
        int probes = 0;
        ForkJoinTask<?> t = null;
        while (true) {
            ForkJoinWorkerThread v = ws[idx & mask];
            r = ForkJoinWorkerThread.xorShift(r);
            if (joinMe.status < 0) break;
            if (v != null && (t = v.deqTask()) != null) {
                this.randomVictimSeed = r;
                ++this.stealCount;
                break;
            }
            if ((++probes & 0x3FF) == 0) {
                this.pauseAwaitingWork(joinMe);
            }
            idx = probes <= mask ? r : idx + 1;
        }
        return t;
    }

    final void helpJoinTask(ForkJoinTask<?> joinMe) {
        ForkJoinTask<?> t;
        while (joinMe.status >= 0 && ((t = this.popTask()) != null || (t = this.scanWhileJoining(joinMe)) != null)) {
            t.exec();
        }
    }

    final void doForkJoin(RecursiveAction t1, RecursiveAction t2) {
        Throwable ex;
        if (t1.status >= 0 && t2.status >= 0) {
            this.pushTask(t2);
            if (t1.rawExec()) {
                if (this.popIfNext(t2)) {
                    if (t2.rawExec()) {
                        return;
                    }
                } else {
                    this.helpJoinTask(t2);
                    if (t2.completedNormally()) {
                        return;
                    }
                }
            }
        }
        if ((ex = t1.getException()) != null) {
            t2.cancel();
        } else {
            ex = t2.getException();
            if (ex != null) {
                t1.cancel();
            }
        }
        if (ex != null) {
            ForkJoinTask.rethrowException(ex);
        }
    }

    final boolean doTimedJoinTask(ForkJoinTask<?> joinMe, long nanos) {
        long startTime = System.nanoTime();
        boolean spins = false;
        while (true) {
            ForkJoinTask<?> t = this.popTask();
            if (joinMe.isDone()) {
                return true;
            }
            t = this.getLocalOrStolenTask();
            if (t != null) {
                t.exec();
                continue;
            }
            if (this.runState.isAtLeastStopping()) {
                return false;
            }
            if (nanos - (System.nanoTime() - startTime) <= 0L) break;
        }
        return false;
    }

    private final void clearLocalTasks() {
        while (this.sp - this.base > 0) {
            ForkJoinTask<?> t = this.popTask();
            if (t == null) continue;
            if (this.runState.isAtLeastStopping()) {
                t.setCancelled();
                continue;
            }
            t.exec();
        }
    }

    final void cancelTasks() {
        while (this.sp - this.base > 0) {
            ForkJoinTask<?> t = this.deqTask();
            if (t == null) continue;
            t.setCancelled();
        }
    }

    public static ForkJoinPool getPool() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pool;
    }

    public static int getPoolIndex() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).poolIndex;
    }

    public static int getLocalQueueSize() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getQueueSize();
    }

    public static ForkJoinTask<?> peekLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).peekTask();
    }

    public static ForkJoinTask<?> pollLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).popTask();
    }

    public static boolean executeLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).runLocalTask();
    }

    public static ForkJoinTask<?> pollTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getLocalOrStolenTask();
    }

    public static boolean executeTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).runLocalOrStolenTask();
    }

    public static void helpQuiesce() {
        ((ForkJoinWorkerThread)Thread.currentThread()).runUntilQuiescent();
    }

    public static int getEstimatedSurplusTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).estimatedSurplusTaskCount();
    }

    final int estimatedSurplusTaskCount() {
        return this.sp - this.base - this.pool.getIdleThreadCount();
    }

    public static boolean removeIfNextLocalTask(ForkJoinTask<?> task) {
        return ((ForkJoinWorkerThread)Thread.currentThread()).popIfNext(task);
    }

    public static Future<?> pollSubmission(ForkJoinPool pool) {
        return pool.pollSubmission();
    }

    public static <V> ForkJoinTask<V> getSubmittedTask(Future<V> submission) {
        try {
            return ((Submission)submission).getSubmittedTask();
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException();
        }
    }

    public static <V> void forceCompletion(Future<V> submission, V value) {
        try {
            ((Submission)submission).finishTask(value);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException();
        }
    }

    public static <V> void forceCompletionExceptionally(Future<V> submission, Throwable exception) {
        if (!(exception instanceof RuntimeException) && !(exception instanceof Error)) {
            throw new IllegalArgumentException();
        }
        try {
            ((Submission)submission).finishTaskExceptionally(exception);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException();
        }
    }

    private final int nextJURandom(int bits) {
        long next;
        this.juRandomSeed = next = this.juRandomSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(next >>> 48 - bits);
    }

    private final int nextJURandomInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int bits = this.nextJURandom(31);
        if ((n & -n) == n) {
            return (int)((long)n * (long)bits >> 31);
        }
        int val;
        while (bits - (val = bits % n) + (n - 1) < 0) {
            bits = this.nextJURandom(31);
        }
        return val;
    }

    private final long nextJURandomLong() {
        return ((long)this.nextJURandom(32) << 32) + (long)this.nextJURandom(32);
    }

    private final long nextJURandomLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        long offset = 0L;
        while (n >= Integer.MAX_VALUE) {
            long nextn;
            int bits = this.nextJURandom(2);
            long half = n >>> 1;
            long l = nextn = (bits & 2) == 0 ? half : n - half;
            if ((bits & 1) == 0) {
                offset += n - nextn;
            }
            n = nextn;
        }
        return offset + (long)this.nextJURandomInt((int)n);
    }

    private final double nextJURandomDouble() {
        return (double)(((long)this.nextJURandom(26) << 27) + (long)this.nextJURandom(27)) / 9.007199254740992E15;
    }

    public static int nextRandomInt() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).nextJURandom(32);
    }

    public static int nextRandomInt(int n) {
        return ((ForkJoinWorkerThread)Thread.currentThread()).nextJURandomInt(n);
    }

    public static long nextRandomLong() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).nextJURandomLong();
    }

    public static long nextRandomLong(long n) {
        return ((ForkJoinWorkerThread)Thread.currentThread()).nextJURandomLong(n);
    }

    public static double nextRandomDouble() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).nextJURandomDouble();
    }

    static {
        try {
            if (ForkJoinWorkerThread.class.getClassLoader() != null) {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                _unsafe = (Unsafe)f.get(null);
            } else {
                _unsafe = Unsafe.getUnsafe();
            }
            baseOffset = _unsafe.objectFieldOffset(ForkJoinWorkerThread.class.getDeclaredField("base"));
            spOffset = _unsafe.objectFieldOffset(ForkJoinWorkerThread.class.getDeclaredField("sp"));
            qBase = _unsafe.arrayBaseOffset(ForkJoinTask[].class);
            int s = _unsafe.arrayIndexScale(ForkJoinTask[].class);
            if ((s & s - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            qShift = 31 - Integer.numberOfLeadingZeros(s);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }
}

