/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import jsr166y.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public abstract class ForkJoinTask<V>
implements Serializable {
    static final WeakHashMap<ForkJoinTask<?>, Throwable> exceptionTable = new WeakHashMap();
    volatile int status;
    static final int COMPLETED = -1;
    static final int CANCELLED = -2;
    static final int HAS_EXCEPTION = -3;
    private static final long serialVersionUID = -7721805057305804111L;
    static final Unsafe _unsafe;
    static final long statusOffset;

    static synchronized void setException(ForkJoinTask<?> t, Throwable ex) {
        exceptionTable.put(t, ex);
    }

    static synchronized Throwable getException(ForkJoinTask<?> t) {
        return exceptionTable.get(t);
    }

    static synchronized void clearException(ForkJoinTask<?> t) {
        exceptionTable.remove(t);
    }

    ForkJoinTask() {
    }

    abstract boolean exec();

    final void setDone() {
        _unsafe.putOrderedInt(this, statusOffset, -1);
    }

    final boolean casStatus(int cmp, int val) {
        return cmp == this.status && _unsafe.compareAndSwapInt(this, statusOffset, cmp, val);
    }

    final void setStatus(int s) {
        _unsafe.putOrderedInt(this, statusOffset, s);
    }

    final void incrementStatus() {
        int s;
        while ((s = this.status) >= 0 && !_unsafe.compareAndSwapInt(this, statusOffset, s, s + 1)) {
        }
    }

    final void setDoneExceptionally(Throwable rex) {
        ForkJoinTask.setException(this, rex);
        this.status = -3;
    }

    final void setCancelled() {
        _unsafe.compareAndSwapInt(this, statusOffset, 0, -2);
    }

    static final void rethrowException(Throwable ex) {
        if (ex != null) {
            _unsafe.throwException(ex);
        }
    }

    final void checkedSetDoneExceptionally(Throwable rex) {
        if (!(rex instanceof RuntimeException) && !(rex instanceof Error)) {
            throw new IllegalArgumentException(rex);
        }
        this.setDoneExceptionally(rex);
    }

    final V reportAsForkJoinResult() {
        int s = this.status;
        if (s == -2) {
            throw new CancellationException();
        }
        if (s == -3) {
            ForkJoinTask.rethrowException(ForkJoinTask.getException(this));
        }
        return this.rawResult();
    }

    final V reportAsFutureResult() throws ExecutionException {
        Throwable ex;
        int s = this.status;
        if (s == -2) {
            throw new CancellationException();
        }
        if (s == -3 && (ex = ForkJoinTask.getException(this)) != null) {
            throw new ExecutionException(ex);
        }
        return this.rawResult();
    }

    public final void fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
    }

    public final V join() {
        int s = this.status;
        if (s >= 0) {
            ((ForkJoinWorkerThread)Thread.currentThread()).helpJoinTask(this);
            s = this.status;
        }
        return s < -1 ? this.reportAsForkJoinResult() : this.rawResult();
    }

    public V forkJoin() {
        this.exec();
        return this.join();
    }

    public final boolean isDone() {
        return this.status < 0;
    }

    public final boolean isCancelled() {
        return this.status == -2;
    }

    final boolean completedNormally() {
        return this.status == -1;
    }

    final boolean completedAbnormally() {
        return this.status < -1;
    }

    public void cancel() {
        _unsafe.compareAndSwapInt(this, statusOffset, 0, -2);
    }

    public final Throwable getException() {
        int s = this.status;
        if (s >= -1) {
            return null;
        }
        if (s == -2) {
            return new CancellationException();
        }
        return ForkJoinTask.getException(this);
    }

    public abstract V rawResult();

    public void reinitialize() {
        if (this.status == -3) {
            ForkJoinTask.clearException(this);
        }
        this.status = 0;
    }

    public final void quietlyJoin() {
        ((ForkJoinWorkerThread)Thread.currentThread()).helpJoinTask(this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(ForkJoinTask.getException(this));
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object ex = s.readObject();
        if (ex != null) {
            ForkJoinTask.setException(this, (Throwable)ex);
        }
    }

    static {
        try {
            if (ForkJoinWorkerThread.class.getClassLoader() != null) {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                _unsafe = (Unsafe)f.get(null);
            } else {
                _unsafe = Unsafe.getUnsafe();
            }
            statusOffset = _unsafe.objectFieldOffset(ForkJoinTask.class.getDeclaredField("status"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

