/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Field;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.ForkJoinWorkerThread;
import jsr166y.forkjoin.PoolBarrier;
import jsr166y.forkjoin.RunState;
import jsr166y.forkjoin.Submission;
import sun.misc.Unsafe;

public class ForkJoinPool
implements ForkJoinExecutor {
    private static final DefaultForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
    private static final RuntimePermission modifyThreadPermission = new RuntimePermission("modifyThread");
    private static final AtomicInteger poolNumberGenerator = new AtomicInteger();
    volatile ForkJoinWorkerThread[] workers;
    private final PoolBarrier poolBarrier;
    private final ReentrantLock workerLock;
    private final Condition termination;
    private final RunState runState;
    private final AtomicInteger runningSubmissions;
    private Thread.UncaughtExceptionHandler ueh;
    private final ForkJoinWorkerThreadFactory factory;
    private volatile SQNode sqHead;
    private volatile SQNode sqTail;
    private volatile int activeCount;
    private volatile int poolSize;
    private int runningWorkers;
    private final int poolNumber;
    static final Unsafe _unsafe;
    static final long activeCountOffset;
    static final long sqHeadOffset;
    static final long sqTailOffset;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    private static int workerSizeFor(int ps) {
        return ps <= 1 ? 1 : 1 << 32 - Integer.numberOfLeadingZeros(ps - 1);
    }

    private ForkJoinWorkerThread createWorker(int index) {
        ForkJoinWorkerThread w = this.factory.newThread(this);
        w.setDaemon(true);
        w.setWorkerPoolIndex(index);
        w.setName("ForkJoinPool-" + this.poolNumber + "-worker-" + index);
        Thread.UncaughtExceptionHandler h = this.ueh;
        if (h != null) {
            w.setUncaughtExceptionHandler(h);
        }
        return w;
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(int poolSize) {
        this(poolSize, defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(ForkJoinWorkerThreadFactory factory) {
        this(Runtime.getRuntime().availableProcessors(), factory);
    }

    public ForkJoinPool(int poolSize, ForkJoinWorkerThreadFactory factory) {
        SQNode dummy;
        if (poolSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (factory == null) {
            throw new NullPointerException();
        }
        ForkJoinPool.checkPermission();
        this.poolSize = poolSize;
        this.factory = factory;
        this.poolNumber = poolNumberGenerator.incrementAndGet();
        this.poolBarrier = new PoolBarrier();
        this.runState = new RunState();
        this.runningSubmissions = new AtomicInteger();
        this.workerLock = new ReentrantLock();
        this.termination = this.workerLock.newCondition();
        this.sqHead = dummy = new SQNode(null);
        this.sqTail = dummy;
        this.createAndStartWorkers(poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndStartWorkers(int ps) {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            int i;
            ForkJoinWorkerThread[] ws = new ForkJoinWorkerThread[ForkJoinPool.workerSizeFor(ps)];
            this.workers = ws;
            for (i = 0; i < ps; ++i) {
                ws[i] = this.createWorker(i);
            }
            for (i = 0; i < ps; ++i) {
                ws[i].start();
                ++this.runningWorkers;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <T> T invoke(ForkJoinTask<T> task) {
        return this.doSubmit(task).awaitInvoke();
    }

    @Override
    public <T> Future<T> submit(ForkJoinTask<T> task) {
        return this.doSubmit(task);
    }

    @Override
    public <T> void execute(ForkJoinTask<T> task) {
        this.doSubmit(task);
    }

    private <T> Submission<T> doSubmit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.runState.isAtLeastShutdown()) {
            throw new RejectedExecutionException();
        }
        Submission<T> job = new Submission<T>(task, this);
        this.addSubmission(job);
        this.poolBarrier.signal();
        return job;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public int getParallelismLevel() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningWorkerCount() {
        int r;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            r = this.runningWorkers;
        }
        finally {
            lock.unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread.UncaughtExceptionHandler setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler h) {
        ForkJoinPool.checkPermission();
        Thread.UncaughtExceptionHandler old = null;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            old = this.ueh;
            this.ueh = h;
            ForkJoinWorkerThread[] ws = this.workers;
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread w = ws[i];
                if (w == null) continue;
                w.setUncaughtExceptionHandler(h);
            }
        }
        finally {
            lock.unlock();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler h;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            h = this.ueh;
        }
        finally {
            lock.unlock();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWorkers(int numberToAdd) {
        int nadded = 0;
        ForkJoinPool.checkPermission();
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            if (!this.runState.isAtLeastStopping()) {
                int i;
                ForkJoinWorkerThread[] ws = this.workers;
                int len = ws.length;
                int newLen = len + numberToAdd;
                int newSize = ForkJoinPool.workerSizeFor(newLen);
                ForkJoinWorkerThread[] nws = new ForkJoinWorkerThread[newSize];
                System.arraycopy(ws, 0, nws, 0, len);
                for (i = len; i < newLen; ++i) {
                    nws[i] = this.createWorker(i);
                }
                this.workers = nws;
                for (i = len; i < newLen; ++i) {
                    nws[i].start();
                    ++this.runningWorkers;
                }
                this.poolSize += numberToAdd;
                nadded = numberToAdd;
            }
        }
        finally {
            lock.unlock();
        }
        return nadded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeWorkers(int numberToRemove) {
        int nremoved = 0;
        ForkJoinPool.checkPermission();
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            int k = ws.length;
            while (!this.runState.isAtLeastStopping() && --k > 0 && nremoved < numberToRemove) {
                RunState rs;
                ForkJoinWorkerThread w = ws[k];
                if (w == null || !(rs = w.getRunState()).transitionToShutdown()) continue;
                --this.poolSize;
                ++nremoved;
            }
        }
        finally {
            lock.unlock();
        }
        return nremoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPoolSize(int newSize) {
        ForkJoinPool.checkPermission();
        if (newSize <= 0) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            int ps = this.poolSize;
            if (newSize > ps) {
                this.addWorkers(newSize - ps);
            } else if (newSize < ps) {
                this.removeWorkers(ps - newSize);
            }
        }
        finally {
            lock.unlock();
        }
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void workerTerminated(ForkJoinWorkerThread w, Throwable ex) {
        try {
            ReentrantLock lock = this.workerLock;
            lock.lock();
            try {
                if (!this.runState.isAtLeastStopping()) {
                    int idx = w.getWorkerPoolIndex();
                    ForkJoinWorkerThread[] ws = this.workers;
                    int len = ws.length;
                    if (idx >= 0 && idx < len && ws[idx] == w) {
                        int newSize;
                        int newlen;
                        ws[idx] = null;
                        for (newlen = len; newlen > 0 && ws[newlen - 1] == null; --newlen) {
                        }
                        if (newlen < len && (newSize = ForkJoinPool.workerSizeFor(newlen)) < len) {
                            ForkJoinWorkerThread[] nws = new ForkJoinWorkerThread[newSize];
                            System.arraycopy(ws, 0, nws, 0, newlen);
                            this.workers = nws;
                            this.poolBarrier.signal();
                        }
                    }
                }
                if (--this.runningWorkers == 0) {
                    this.terminate();
                    this.runState.transitionToTerminated();
                    this.termination.signalAll();
                }
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            if (ex != null) {
                ForkJoinTask.rethrowException(ex);
            }
        }
    }

    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.runState.transitionToShutdown();
        this.tryTerminateOnShutdown();
    }

    public void shutdownNow() {
        ForkJoinPool.checkPermission();
        this.terminate();
    }

    public boolean isShutdown() {
        return this.runState.isAtLeastShutdown();
    }

    public boolean isTerminated() {
        return this.runState.isTerminated();
    }

    public boolean isTerminating() {
        return this.runState.isStopping();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            while (true) {
                if (this.runState.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void terminate() {
        if (this.runState.transitionToStopping()) {
            this.stopAllWorkers();
            this.cancelQueuedSubmissions();
            this.cancelQueuedWorkerTasks();
            this.interruptUnterminatedWorkers();
        }
    }

    private void tryTerminateOnShutdown() {
        if (this.runState.isAtLeastShutdown() && this.runningSubmissions.get() == 0 && !this.hasQueuedSubmissions() && this.runningSubmissions.get() == 0) {
            this.terminate();
        }
    }

    private void cancelQueuedSubmissions() {
        Submission<?> task;
        while (this.hasQueuedSubmissions() && (task = this.pollSubmission()) != null) {
            task.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQueuedWorkerTasks() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread t = ws[i];
                if (t == null) continue;
                t.cancelTasks();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread t = ws[i];
                if (t == null) continue;
                RunState rs = t.getRunState();
                rs.transitionToStopping();
            }
        }
        finally {
            lock.unlock();
        }
        this.poolBarrier.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptUnterminatedWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            for (int i = 0; i < ws.length; ++i) {
                RunState rs;
                ForkJoinWorkerThread t = ws[i];
                if (t == null || (rs = t.getRunState()).isTerminated()) continue;
                try {
                    t.interrupt();
                    continue;
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean isQuiescent() {
        return this.activeCount == 0;
    }

    public final int getActiveThreadCount() {
        return this.activeCount;
    }

    public final int getIdleThreadCount() {
        return this.poolSize - this.activeCount;
    }

    public long getStealCount() {
        long sum = 0L;
        ForkJoinWorkerThread[] ws = this.workers;
        for (int i = 0; i < ws.length; ++i) {
            ForkJoinWorkerThread t = ws[i];
            if (t == null) continue;
            sum += t.getWorkerStealCount();
        }
        return sum;
    }

    public long getTotalPerThreadQueueSize() {
        long count = 0L;
        ForkJoinWorkerThread[] ws = this.workers;
        for (int i = 0; i < ws.length; ++i) {
            ForkJoinWorkerThread t = ws[i];
            if (t == null) continue;
            count += (long)t.getQueueSize();
        }
        return count;
    }

    public int getActiveSubmissionCount() {
        return this.runningSubmissions.get();
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    final void submissionStarting() {
        this.runningSubmissions.incrementAndGet();
    }

    final void submissionCompleted() {
        if (this.runningSubmissions.decrementAndGet() == 0 && this.runState.isAtLeastShutdown()) {
            this.tryTerminateOnShutdown();
        }
    }

    final long barrierSync(long eventCount) {
        return this.poolBarrier.sync(eventCount);
    }

    final boolean mayHaveQueuedSubmissions() {
        return this.sqHead != this.sqTail;
    }

    public boolean hasQueuedSubmissions() {
        while (true) {
            SQNode h = this.sqHead;
            SQNode t = this.sqTail;
            SQNode f = (SQNode)h.get();
            if (h != this.sqHead) continue;
            if (f == null) {
                return false;
            }
            if (h != t) {
                return true;
            }
            this.casSqTail(t, f);
        }
    }

    final void addSubmission(Submission<?> x) {
        SQNode t;
        SQNode n = new SQNode(x);
        while (true) {
            t = this.sqTail;
            SQNode s = (SQNode)t.get();
            if (t != this.sqTail) continue;
            if (s != null) {
                this.casSqTail(t, s);
                continue;
            }
            if (t.compareAndSet(s, n)) break;
        }
        this.casSqTail(t, n);
    }

    final Submission<?> pollSubmission() {
        SQNode f;
        while (true) {
            SQNode h = this.sqHead;
            SQNode t = this.sqTail;
            f = (SQNode)h.get();
            if (h != this.sqHead) continue;
            if (f == null) {
                return null;
            }
            if (h == t) {
                this.casSqTail(t, f);
                continue;
            }
            if (this.casSqHead(h, f)) break;
        }
        Submission<?> x = f.submission;
        f.submission = null;
        return x;
    }

    final boolean tryIncrementActiveCount() {
        int c = this.activeCount;
        return _unsafe.compareAndSwapInt(this, activeCountOffset, c, c + 1);
    }

    final boolean tryDecrementActiveCount() {
        int c = this.activeCount;
        return _unsafe.compareAndSwapInt(this, activeCountOffset, c, c - 1);
    }

    final void incrementActiveCount() {
        while (!this.tryIncrementActiveCount()) {
        }
    }

    final void decrementActiveCount() {
        while (!this.tryDecrementActiveCount()) {
        }
    }

    private boolean casSqTail(SQNode cmp, SQNode val) {
        return _unsafe.compareAndSwapObject(this, sqTailOffset, cmp, val);
    }

    private boolean casSqHead(SQNode cmp, SQNode val) {
        return _unsafe.compareAndSwapObject(this, sqHeadOffset, cmp, val);
    }

    static {
        try {
            if (ForkJoinPool.class.getClassLoader() != null) {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                _unsafe = (Unsafe)f.get(null);
            } else {
                _unsafe = Unsafe.getUnsafe();
            }
            activeCountOffset = _unsafe.objectFieldOffset(ForkJoinPool.class.getDeclaredField("activeCount"));
            sqHeadOffset = _unsafe.objectFieldOffset(ForkJoinPool.class.getDeclaredField("sqHead"));
            sqTailOffset = _unsafe.objectFieldOffset(ForkJoinPool.class.getDeclaredField("sqTail"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }

    static final class SQNode
    extends AtomicReference<SQNode> {
        Submission<?> submission;

        SQNode(Submission<?> s) {
            this.submission = s;
        }
    }

    public static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

