import java.awt.*;

/** La classe MaillonDouble tant la classe Maillon qui permet de 
 * modliser graphiquement un maillon d'une liste chaine en 
 * utilisant Swing, mais avec en plus une rfrence sur le maillon qui 
 * le prcedent dans la liste.
 *  
 * @author Eric Beuque et Stphane Chenevoy
 *
 */
public class MaillonDouble extends Maillon{
	private Maillon precedent;
	/** Construit un maillon double vide au point de coordonne (0,0).
	 */
	public MaillonDouble(){
		super();
		precedent=null;
	}
	/** Construit un maillon double au point de coordonne (0,0) contenant un objet, .
	 */
	public MaillonDouble(Object o){
		super(o);
		precedent=null;
	}

	/** Renvoie la rfrence du maillon qui prcdent ce maillon dans la liste.
	 */
	public Maillon getPrecedent(){
		return precedent;
	}
	/** Affecte la rfrence du maillon qui prcdent ce maillon dans la liste.
	 */
	public void setPrecedent(Maillon m){
		precedent=m;
	}
	public boolean isPointSurMaillon(Point p){
		if(p.x>this.getCentre().x && p.x<this.getCentre().x+this.getCaseInfo()+40 
				&& p.y>this.getCentre().y-15 && p.y<this.getCentre().y+15){
			return true;
		}else{
			return false;
		}
	}
	public int largeurMaillon(){
		return this.getCaseInfo()+40;
	}
	public Rectangle occupeSurface(){
		Rectangle precedent,suivant,maillon;
		maillon=new Rectangle(this.getCentre().x,this.getCentre().y-15,this.largeurMaillon(),30);

		if(this.getSuivant()==null){
			suivant=new Rectangle(this.getCentre().x+this.largeurMaillon(),this.getCentre().y-15,41,32);
		}else{
			if(this.getSuivant().getCentre().x==this.getCentre().x){
				suivant=new Rectangle(this.getCentre().x+7,this.getCentre().y-15,this.largeurMaillon(),45);
			}else{
				if(this.getSuivant().getCentre().x>this.getCentre().x){
					suivant=new Rectangle(this.getCentre().x+this.largeurMaillon(),this.getCentre().y-10,40,20);
				}else{
					suivant=new Rectangle(this.getSuivant().getCentre().x+7,this.getCentre().y-15,this.getCentre().x-this.getSuivant().getCentre().x+this.largeurMaillon(),45);
				}
			}
		}
		precedent=new Rectangle(this.getCentre().x,this.getCentre().y-17,40,20);
		if(this.getPrecedent()==null){
			precedent=new Rectangle(this.getCentre().x-44,this.getCentre().y-17,40,20);
		}else{
			if(this.getPrecedent().getCentre().x==this.getCentre().x){
				precedent=new Rectangle(this.getCentre().x-10,this.getCentre().y-15,this.largeurMaillon()+20,50);
			}else{
				if(this.getPrecedent().getCentre().x<this.getCentre().x){
					precedent=new Rectangle(this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon(),this.getCentre().y-10,this.getCentre().x-this.getPrecedent().getCentre().x-this.getPrecedent().largeurMaillon(),20);
				}else{
					precedent=new Rectangle(this.getCentre().x-10,this.getCentre().y-15,this.getPrecedent().getCentre().x-this.getCentre().x+this.largeurMaillon()+20,50);
				}
			}
		}
		return precedent.union(maillon.union(suivant));
	}
	public void paint(Graphics g){
		if(this.getSelected()){
			g.setColor(Color.lightGray);
			g.fillRect(this.getCentre().x,this.getCentre().y-15,this.getCaseInfo()+40,30);
			g.setColor(Color.black);
		}
		
		g.drawRect(this.getCentre().x,this.getCentre().y-15,this.getCaseInfo()+40,30);
		
		if(this.getInfo()!=null){
			g.drawString(this.getInfo().toString(),this.getCentre().x+30,this.getCentre().y+3);
		}
		
		g.fillOval(this.getCentre().x+7,this.getCentre().y-10,6,6);
		g.drawLine(this.getCentre().x+20,this.getCentre().y-15,this.getCentre().x+20,this.getCentre().y+15);
		if(precedent==null){
			g.drawLine(this.getCentre().x-40,this.getCentre().y-7,this.getCentre().x+7,this.getCentre().y-7);
			g.drawLine(this.getCentre().x-40,this.getCentre().y-17,this.getCentre().x-40,this.getCentre().y+3);
			g.drawLine(this.getCentre().x-42,this.getCentre().y-14,this.getCentre().x-42,this.getCentre().y);
			g.drawLine(this.getCentre().x-44,this.getCentre().y-11,this.getCentre().x-44,this.getCentre().y-3);
		}else{
			if(this.getPrecedent().getCentre().x<this.getCentre().x){
				g.drawLine(this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon(),this.getPrecedent().getCentre().y-7,this.getCentre().x+7,this.getCentre().y-7);
				g.drawLine(this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon()+3,this.getPrecedent().getCentre().y-10,this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon(),this.getPrecedent().getCentre().y-7);
				g.drawLine(this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon()+3,this.getPrecedent().getCentre().y-4,this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon(),this.getPrecedent().getCentre().y-7);
			}else{
				g.drawLine(this.getCentre().x+7,this.getCentre().y-7,this.getCentre().x-10,this.getCentre().y-7);
				g.drawLine(this.getCentre().x-10,this.getCentre().y-7,this.getCentre().x-10,this.getCentre().y+35);
				g.drawLine(this.getCentre().x-10,this.getCentre().y+35,this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon()+10,this.getCentre().y+35);
				g.drawLine(this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon()+10,this.getCentre().y+35,this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon()+10,this.getCentre().y-7);
				g.drawLine(this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon()+10,this.getCentre().y-7,this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon(),this.getCentre().y-7);
				g.drawLine(this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon(),this.getCentre().y-7,this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon()+3,this.getCentre().y-10);
				g.drawLine(this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon(),this.getCentre().y-7,this.getPrecedent().getCentre().x+this.getPrecedent().largeurMaillon()+3,this.getCentre().y-4);
			}
		}
		
		g.drawLine(this.getCentre().x+this.getCaseInfo()+20,this.getCentre().y-15,this.getCentre().x+this.getCaseInfo()+20,this.getCentre().y+15);
		g.fillOval(this.getCentre().x+this.getCaseInfo()+27,this.getCentre().y+5,6,6);
		if(this.getSuivant()==null){
			g.drawLine(this.getCentre().x+this.getCaseInfo()+27,this.getCentre().y+7,this.getCentre().x+this.getCaseInfo()+77,this.getCentre().y+7);
			g.drawLine(this.getCentre().x+this.getCaseInfo()+77,this.getCentre().y-3,this.getCentre().x+this.getCaseInfo()+77,this.getCentre().y+17);
			g.drawLine(this.getCentre().x+this.getCaseInfo()+79,this.getCentre().y,this.getCentre().x+this.getCaseInfo()+79,this.getCentre().y+14);
			g.drawLine(this.getCentre().x+this.getCaseInfo()+81,this.getCentre().y+3,this.getCentre().x+this.getCaseInfo()+81,this.getCentre().y+11);
		}else{
			if(this.getSuivant().getCentre().x>this.getCentre().x){
				g.drawLine(this.getCentre().x+this.getCaseInfo()+27,this.getCentre().y+7,this.getSuivant().getCentre().x,this.getSuivant().getCentre().y+7);
				g.drawLine(this.getSuivant().getCentre().x-3,this.getCentre().y+10,this.getSuivant().getCentre().x,this.getSuivant().getCentre().y+7);
				g.drawLine(this.getSuivant().getCentre().x-3,this.getCentre().y+4,this.getSuivant().getCentre().x,this.getSuivant().getCentre().y+7);
				this.getSuivant().paint(g);
			}else{
				g.drawLine(this.getCentre().x+this.getCaseInfo()+27,this.getCentre().y+7,this.getCentre().x+this.getCaseInfo()+47,this.getCentre().y+7);
				g.drawLine(this.getCentre().x+this.getCaseInfo()+47,this.getCentre().y+7,this.getCentre().x+this.getCaseInfo()+47,this.getCentre().y+30);
				g.drawLine(this.getCentre().x+this.getCaseInfo()+47,this.getCentre().y+30,this.getSuivant().getCentre().x+10,this.getCentre().y+30);
				g.drawLine(this.getSuivant().getCentre().x+10,this.getCentre().y+30,this.getSuivant().getCentre().x+10,this.getCentre().y+15);
				g.drawLine(this.getSuivant().getCentre().x+7,this.getCentre().y+18,this.getSuivant().getCentre().x+10,this.getCentre().y+15);
				g.drawLine(this.getSuivant().getCentre().x+13,this.getCentre().y+18,this.getSuivant().getCentre().x+10,this.getCentre().y+15);
			}
		}
	}
}
