/** La classe ListeOrdonnee permet de modliser graphiquement 
 * une liste chaine ordonne en utilisant Swing.
 *  
 * @author Eric Beuque et Stphane Chenevoy
 *
 */
public class ListeOrdonnee extends ListeChaineeSimple implements Ordonnee{
	/** Construit une liste chaine ordonne vide au point de coordonne (0,0).
	 */
	public ListeOrdonnee(){
		super();
	}
	public void ajouterMaillon(Maillon m){
		if(this.getTete()==null){
			this.setTete(m);			
		}else{
			this.setTete(this.placeMaillon(this.getTete(),m));
		}
		this.recalcCentreMaillon();
	}
	public Maillon placeMaillon(Maillon listMaillon, Maillon m){
		if(listMaillon==null){
			return m;
		}else{
			if(m.compareTo(listMaillon)<0){
				m.setSuivant(listMaillon);
				return m;
			}else{
				listMaillon.setSuivant(this.placeMaillon(listMaillon.getSuivant(),m));
				return listMaillon;
			}
		}
	}
	public void fusionner(Liste l) throws FusionListeError{
		Maillon tmp;
		if(l.getClass().getName()!="ListeOrdonnee"){
			throw new FusionListeError("Impossible de fusionner une liste ordonne  une liste non ordonne.");
		}
		while(l.getTete()!=null){
			tmp=l.getTete();
			try{
				l.retirerMaillon(l.getTete());
				this.ajouterMaillon(tmp);
			}catch(ListeChaineeCreatorError err){}
		}
	}
}
