// Etoile.h: interface for the Etoile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ETOILE_H__A4DFC263_FFF8_4ED8_A6CB_6D0A99210B28__INCLUDED_)
#define AFX_ETOILE_H__A4DFC263_FFF8_4ED8_A6CB_6D0A99210B28__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <time.h>
#include "Pion.h"
#include "Joueur.h"
#include "Pile.h"

class Etoile  
{
private:
	Pion*** m_tabPion; // Tableau representant l'toile
	int m_tailleTriangle; // Taille des branches
	Joueur** m_tabJoueur; // Tableau contenant la liste des joueurs
	Pile histo; // Historique des coup a jouer
	int m_nbJoueur;

	// Initialise le tableau de joueur
	void initialiseJoueurs();
	// Demande pour chaque joueur s'il s'agit d'un IA ou d'un humain
	void initialiseIA();
	// Initialise le tableau de pion
	void initialiseEtoile();

	// Deplace un pion (ne verifie pas si le deplacement est valide)
	void deplace(int ligS, int colS, int ligD, int colD);
	// Fait jouer le joueur
	void jouer(int noJoueur);
	// Fait rejouer le joueur (s'il a fait un saut)
	void rejouer(int noJoueur, int& ligS, int& colS);
	// Ajoute un tour d'info dans l'historique des tours
	void ajouteHisto(const InfoTour& inf);

	/* Methode pour l'IA */
	// Fait jouer l'IA
	void deplaceIA(int noJoueur);
	// Permet d'obtenir un point a atteindre de l'IA
	void getObjectifPionIA(int noJoueur, int& ligO, int& colO) const;
	// Permet d'obtenir le pion a deplacer de l'IA en fonction du point a atteindre
	void getSrcPionIA(int noJoueur, int ligO, int colO, int& ligS, int& colS) const;
	// Permet d'obtenir le point de destination de l'IA en fonction du point a atteindre, et du pion a deplacer
	void getDestPionIA(int noJoueur, int ligO, int colO, int ligS, int colS, int& ligD, int& colD) const;
	// Permet d'obtenir le point de destination de l'IA en fonction du point a atteindre, et du pion a deplacer et de la direction souhait
	bool getDestDirection(int ligS, int colS, int& ligD, int& colD, int direction, bool saut) const;
	// Permet de savoir si un point est meilleur qu'un autre du point de vu du sommet du triangle
	bool pointMieuDsTriangle(int numTriangle, int lig1, int col1, int lig2, int col2) const;

public:
	// Constructeurs/destructeur
	Etoile();
	Etoile(int tailleTriangle, int nbJoueur);
	virtual ~Etoile();
	
	// Renvoie la taille d'un triangle
	int getTailleTriangle() const;
	// Renvoie la largeur de l'toile
	int getLargeurEtoile() const;
	// Renvoie la hauteur de l'toile
	int getHauteurEtoile() const;
	// Renvoie le nombre de case pour la ligne de l'toile
	int getNbCaseLigne(int index) const;
	// Renvoie le nombre de joueur
	int getNbJoueur() const;
	// Renvoie le numro du triangle de dpart du joueur
	int getNoTriangle(int noJoueur) const;
	// Renvoie le numro de traingle d'arriv du joueur
	int getNoTriangleFin(int noJoueur) const;
	// Permet au joueur de saisir un point de dpart, les valeurs iront dans lig et col
	void getPointDepart(int noJoueur, int& lig, int& col) const;
	// Permet au joueur de saisir un point d'arriv, les valeurs iront dans lig et col
	void getPointArrive(int noJoueur, int& lig, int& col) const;

	// Renvoie vrai si une coordonne de l'toile est valide
	bool coordValide(int ligne, int colonne) const;
	// Renvoie l'indice de la colonne d'un point de coordonn
	int coor2Indice(int ligne, int colonne) const;
	// Renvoie le numro de colonne de l'indice de colonne du tableau
	int indice2Coord(int indiceLigne, int indiceColonne) const;
	// Renvoie vrai si un point d'indice donn est dans le triangle
	bool indiceDansTriangle(int indiceLigne, int indiceColonne, int noTriangle) const;
	// Renvoie vrai si un deplacement est un deplacement simple
	bool isDeplacementSimple(int ligS, int colS, int ligD, int colD) const;
	// Renvoie vrai si un deplacement est saut
	bool isDeplacementSaut(int ligS, int colS, int ligD, int colD) const;
	// Renvoie 1 si le pion appartient au joueur, 0 si le pion n'est pas au joueur, et -1 s'il n'y a pa de pion
	int isPionJoueur(int noJoueur, int lig, int col) const;

	// Appel le menu principal
	void menuPrincipal();
	// Appel le menu pour creer une nouvelle partie
	void menuNouvellePartie();
	// Charge une partie
	void menuChargerPartie();
	// Sauvegarde une partie
	void menuSauvegarder() const;
	// Lance le tour du joueur et renvoie vrai s'il a gagn
	bool lanceTour(int noJoueur);
	// Renvoie vrai si le joueur a gagn
	bool isGagnant(int noJoueur) const;
	// Verifie si un le pion peut etre dplac
	bool isDeplacable(int lig, int col) const;

	// Oprateurs
	friend ostream& operator << (ostream& out, const Etoile& e);

};

#endif // !defined(AFX_ETOILE_H__A4DFC263_FFF8_4ED8_A6CB_6D0A99210B28__INCLUDED_)
