<?

define("ENDL","\n");

function dd($date) {
  return date("d/m/Y H:i:s",$date);
}
  
function right($str,$nbr) {
  return substr($str,-$nbr);
}

function mkdir_r($dirName, $rights=0777){
  $dirs = explode('/', $dirName);
  $dir='';
  foreach ($dirs as $part) {
    $dir.=$part.'/';
    if (!is_dir($dir) && strlen($dir)>0)
      mkdir($dir, $rights);
  }
}

// fonction d'effacement rcursif de dossier.
// Retourne le nombre de dossiers effacs
function rmdir_r($dir){
  $dossier=opendir($dir);
  while ($fichier = readdir($dossier)) {
    $l = array('.', '..');
    if (!in_array($fichier, $l)){
      if (is_dir($dir."/".$fichier)){
        rmdir_r("$dir/$fichier");
      }else{
        unlink("$dir/$fichier");
      }
    }
  }
  @closedir($dossier);
  return rmdir($dir);
}

function creerMiniature($image,$dest){
  //Header("Content-type: image/jpeg");
  //echo "Minature de ".$image." va etre cre vers ".$dest."<br>";
  $src_im = ImageCreateFromJpeg($image);
  $size = GetImageSize($image);
  $src_w = $size[0];
  $src_h = $size[1];
  //taille de votre image
  $dst_h = 100;
  // Contraint le rchantillonage  une largeur fixe
  // Maintient le ratio de l'image
  $dst_w = round(($dst_h / $src_h) * $src_w);
  //echo "Minature de ".$image." : ".$src_w."x".$src_h." -> ".$dst_w."x".$dst_h."<br>";
  $dst_im = ImageCreateTrueColor($dst_w,$dst_h);
  /* ImageCopyResampled copie et rchantillonne l'image originale */
  ImageCopyResampled($dst_im,$src_im,0,0,0,0,$dst_w,$dst_h,$src_w,$src_h);
  /* ImageJpeg gnre l'image dans la sortie standard (c..d le navigateur).
     Le second paramtre est optionnel ; dans ce cas, 
     l'image est gnre dans un fichier */
  mkdir_r(dirname($dest));   
  ImageJpeg($dst_im,$dest);
  ImageDestroy($dst_im);
  ImageDestroy($src_im);
  //echo "Minature de ".$image." cre vers ".$dest."<br>";
}

function do_bytes($size) {
   $ko = 1024;        // Kilo octets
   $mo = 1024 * $ko;  // Mega octets
   $go = 1024 * $mo;  // Giga octets
   $to = 1024 * $go;  // Tera octets
   if($size == 0) return "n/a";
   if($size < $ko) return $size." octets";
   if($size < $mo) return sprintf("%01.1f", $size/$ko,2)." Ko";
   if($size < $go) return sprintf("%01.1f", $size/$mo,2)." Mo";
   if($size < $to) return sprintf("%01.1f", $size/$go,2)." Go";
   return sprintf("%01.1f", $size/$to,2)." To";
}

function createHTACCESS($htaccess, $htpasswd, $htgroup, $htauthname, $users=null, $groups=null){
  $fd=fopen($htaccess,'w');
  if($fd){
    fwrite($fd,"PerlSetVar AuthFile \"".remplaceRacine($_SERVER["DOCUMENT_ROOT"], "", realpath($htpasswd))."\"\n");
    //fwrite($fd,"AuthUserFile \"".realpath($htpasswd)."\"\n");
    //fwrite($fd,"AuthGroupFile \"".realpath($htgroup)."\"\n");
    fwrite($fd,"AuthName \"".$htauthname."\"\n");
    fwrite($fd,"AuthType Basic\n");
    fwrite($fd,"\n<LIMIT GET POST>\n");
    if($users==null && $groups==null){
      fwrite($fd,"Require valid-user\n");
    }else{
      if($users!=null){
        fwrite($fd,"Require user");
        foreach($users as $usr){
          fwrite($fd," ".$usr);
        }
        fwrite($fd,"\n");
      }
      if($groups!=null){
        fwrite($fd,"Require group");
        foreach($groups as $grp){
          fwrite($fd," ".$grp);
        }
        fwrite($fd,"\n");
      }
    }
    fwrite($fd,"</LIMIT>");
    fclose($fd);
  }else{
    echo 'Problme lors de la cration/ouverture de '.$htaccess.'<br>';
  }
}

function remplaceRacine($fromracine, $toracine, $rep){
  return $toracine.substr($rep,strlen($fromracine),strlen($rep));
}
?>