package filtre;

import java.awt.image.BufferedImage;

import decoupage.Morceau;

/**
 * NoirEtBlanc - Traitement negatif.
 * 
 * @version 1.0 - 28/01/2008
 * @author Beuque & Cornevaux
 */
public class NoirEtBlanc extends Filtre {

	public NoirEtBlanc(Morceau morceau) {
		this.morceau = morceau;
	}
	
	
	/**
	 * traitementNB() - return un tableau des pixels traites.
	 * 
	 * @version 1.0 - 28/01/2008
	 * @author Beuque & Cornevaux
	 */
	public int[] traitementNB() {
		try {
			int dstPixels[] = noirEtBlanc(morceau.getWidth(), morceau.getHeight(), morceau.getPixelsTab());
			BufferedImage dst = new BufferedImage(morceau.getWidth(), morceau.getHeight(), BufferedImage.TYPE_INT_ARGB);
			dst.setRGB(0, 0, morceau.getWidth(), morceau.getHeight(), dstPixels, 0, morceau.getWidth());
			return dst.getRGB(0, 0, morceau.getWidth(), morceau.getHeight(), null, 0, morceau.getWidth());
		} catch (Exception e) {
			System.out.println("Erreur : " + e.toString());
		}
		return null;
	}
	
	

	/**
	 * noirEtBlanc() - 
	 * 
	 * @param width
	 * @param height
	 * @param srcPixels
	 * @return
	 */
	public static int[] noirEtBlanc(int width, int height, int srcPixels[]) {

		int dstPixels[] = new int[srcPixels.length];
		for (int i = 0; i < dstPixels.length; i++) {
			// dstPixels[i] = srcPixels[i] & 0x00006666;
			if (i<10) System.out.println(srcPixels[i]);
			
			if (srcPixels[i] > -5000000) dstPixels[i] = 0xFFFFFF;
			else dstPixels[i] = 0x000000;
		}
		
		
		

		return dstPixels;
	}
	
	
} // fin classe Negatif
