package filtre;

import java.awt.image.BufferedImage;

import decoupage.Morceau;

/**
 * Negatif - Traitement negatif.
 * 
 * @version 1.0 - 28/01/2008
 * @author Beuque & Cornevaux
 */
public class Negatif extends Filtre {

	public Negatif(Morceau morceau) {
		this.morceau = morceau;
	}
	
	
	/**
	 * traitementNegatif() - return un tableau des pixels traites.
	 * 
	 * @version 1.0 - 28/01/2008
	 * @author Beuque & Cornevaux
	 */
	public int[] traitementNegatif() {
		try {
			int dstPixels[] = negatif(morceau.getWidth(), morceau.getHeight(), morceau.getPixelsTab());
			BufferedImage dst = new BufferedImage(morceau.getWidth(), morceau.getHeight(), BufferedImage.TYPE_INT_ARGB);
			dst.setRGB(0, 0, morceau.getWidth(), morceau.getHeight(), dstPixels, 0, morceau.getWidth());
			return dst.getRGB(0, 0, morceau.getWidth(), morceau.getHeight(), null, 0, morceau.getWidth());
		} catch (Exception e) {
			System.out.println("Erreur : " + e.toString());
		}
		return null;
	}
	
	

	/**
	 * negatif() - 
	 * 
	 * @param width
	 * @param height
	 * @param srcPixels
	 * @return
	 */
	public static int[] negatif(int width, int height, int srcPixels[]) {

		int dstPixels[] = new int[srcPixels.length];
		
		for (int i = 0; i < dstPixels.length; i++) {
			// dstPixels[i] = srcPixels[i] & 0x000000FF;
			int alpha = srcPixels[i] & 0xFF000000;
			// Transformation des composantes RGB en leur inverse
		    int rougeInverse = (srcPixels[i] & 0xFF0000) ^ 0xFF0000;
		    int vertInverse  = (srcPixels[i] & 0x00FF00) ^ 0x00FF00;
		    int bleuInverse  = (srcPixels[i] & 0x0000FF) ^ 0x0000FF;
		    dstPixels[i] = alpha | rougeInverse | vertInverse | bleuInverse;
		}

		return dstPixels;
	}
	
	
} // fin classe Negatif
